/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.jobshop;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.cpsolver.ifs.example.jobshop.Job;
import net.sf.cpsolver.ifs.example.jobshop.Location;
import net.sf.cpsolver.ifs.example.jobshop.Machine;
import net.sf.cpsolver.ifs.example.jobshop.Operation;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobShopModel
extends Model<Operation, Location> {
    private int iTotalNumberOfSlots = 1250;
    private Machine[] iMachines;
    private Job[] iJobs;

    public JobShopModel(int nrMachines, int nrJobs) {
        this.iMachines = new Machine[nrMachines];
        this.iJobs = new Job[nrJobs];
    }

    public int getTotalNumberOfSlots() {
        return this.iTotalNumberOfSlots;
    }

    public Machine getMachine(int machineNumber) {
        return this.iMachines[machineNumber];
    }

    public int countMachines() {
        return this.iMachines.length;
    }

    public Job getJob(int jobNumber) {
        return this.iJobs[jobNumber];
    }

    public int countJobs() {
        return this.iJobs.length;
    }

    private void setJob(int jobNumber, Job job) {
        this.iJobs[jobNumber] = job;
    }

    private void setMachine(int machineNumber, Machine machine) {
        this.iMachines[machineNumber] = machine;
    }

    public static JobShopModel loadModel(String file) throws IOException {
        int i;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line.startsWith("#")) {
            line = reader.readLine();
        }
        StringTokenizer stk = new StringTokenizer(line, " ");
        int nrJobs = Integer.parseInt(stk.nextToken());
        int nrMachines = Integer.parseInt(stk.nextToken());
        JobShopModel model = new JobShopModel(nrMachines, nrJobs);
        Machine[] machine = new Machine[nrMachines];
        for (i = 0; i < nrMachines; ++i) {
            machine[i] = new Machine(i);
            model.addConstraint(machine[i]);
            model.setMachine(i, machine[i]);
        }
        for (i = 0; i < nrJobs; ++i) {
            Job job = new Job(i);
            model.addConstraint(job);
            model.setJob(i, job);
            line = reader.readLine();
            stk = new StringTokenizer(line, " ");
            for (int j = 0; j < nrMachines; ++j) {
                int machineNumber = Integer.parseInt(stk.nextToken());
                int processingTime = Integer.parseInt(stk.nextToken());
                Operation operation = new Operation(job, machine[machineNumber], j, processingTime);
                model.addVariable(operation);
                job.addVariable(operation);
                machine[machineNumber].addVariable(operation);
            }
            if (!stk.hasMoreTokens()) continue;
            job.setDueTime(Integer.parseInt(stk.nextToken()));
        }
        reader.close();
        for (Operation o : model.variables()) {
            o.init();
        }
        return model;
    }

    public int getFinishingTime() {
        int ret = 0;
        for (Operation op : this.assignedVariables()) {
            ret = Math.max(ret, ((Location)op.getAssignment()).getFinishingTime());
        }
        return ret;
    }

    @Override
    public Map<String, String> getInfo() {
        Map<String, String> ret = super.getInfo();
        ret.put("Finishing time", String.valueOf(this.getFinishingTime()));
        return ret;
    }

    public void save(String file) throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        for (int i = 0; i < this.countMachines(); ++i) {
            Machine m = this.getMachine(i);
            ArrayList ops = new ArrayList(m.variables());
            Collections.sort(ops, new OperationComparator());
            for (Operation var : ops) {
                Operation op = var;
                if (op.getAssignment() == null) continue;
                writer.print((op.getJobNumber() < 10 ? " " : "") + op.getJobNumber() + " ");
            }
            writer.println();
        }
        writer.println(";");
        Map<String, String> info = this.getInfo();
        for (String key : info.keySet()) {
            String value = info.get(key);
            writer.println("; " + key + ": " + value);
        }
        writer.println(";");
        for (int i = 0; i < this.countJobs(); ++i) {
            Job job = this.getJob(i);
            writer.print("; ");
            for (Operation op : job.variables()) {
                Location loc = (Location)op.getAssignment();
                writer.print((loc == null ? "----" : ToolBox.trim(String.valueOf(loc.getStartTime()), 4)) + " ");
            }
            writer.println();
        }
        writer.flush();
        writer.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OperationComparator
    implements Comparator<Operation> {
        private OperationComparator() {
        }

        @Override
        public int compare(Operation op1, Operation op2) {
            Location loc1 = (Location)op1.getAssignment();
            Location loc2 = (Location)op2.getAssignment();
            if (loc1 == null) {
                if (loc2 == null) {
                    return 0;
                }
                return -1;
            }
            if (loc2 == null) {
                return 1;
            }
            return loc1.getStartTime() < loc2.getStartTime() ? -1 : (loc1.getStartTime() == loc2.getStartTime() ? 0 : 1);
        }
    }
}

