/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.example.csp;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.sf.cpsolver.ifs.example.csp.CSPValue;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSPVariable
extends Variable<CSPVariable, CSPValue> {
    private int iKernelId = -1;

    public CSPVariable(int id, int domainSize) {
        this(id, domainSize, -1);
    }

    public CSPVariable(int id, int domainSize, int kernelId) {
        super(null);
        this.iId = id;
        this.iKernelId = kernelId;
        this.setValues(this.computeValues(domainSize));
    }

    public int getKernelId() {
        return this.iKernelId;
    }

    public void generateInitialValue(Random rnd) {
        CSPValue aValue = (CSPValue)this.values().get((int)(rnd.nextFloat() * (float)this.values().size()));
        this.setInitialAssignment(aValue);
    }

    private List<CSPValue> computeValues(int domainSize) {
        ArrayList<CSPValue> values = new ArrayList<CSPValue>();
        for (int i = 0; i < domainSize; ++i) {
            CSPValue value = new CSPValue(this, i);
            values.add(value);
        }
        return values;
    }

    @Override
    public String getName() {
        return "V" + this.getId();
    }
}

