/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.dbt;

import net.sf.cpsolver.ifs.dbt.DbtPropagation;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.heuristics.VariableSelection;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbtVariableSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements VariableSelection<V, T> {
    private DbtPropagation<V, T> iProp = null;

    public DbtVariableSelection(DataProperties properties) {
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!(extension instanceof DbtPropagation)) continue;
            this.iProp = (DbtPropagation)extension;
        }
    }

    @Override
    public V selectVariable(Solution<V, T> solution) {
        if (solution.getModel().nrUnassignedVariables() == 0) {
            return null;
        }
        if (this.iProp != null) {
            for (Variable variable : solution.getModel().unassignedVariables()) {
                if (!this.iProp.goodValues(variable).isEmpty()) continue;
                return (V)variable;
            }
        }
        return (V)((Variable)solution.getModel().unassignedVariables().iterator().next());
    }
}

