/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.dbt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.ifs.dbt.DbtPropagation;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.extension.ViolatedInitials;
import net.sf.cpsolver.ifs.heuristics.GeneralValueSelection;
import net.sf.cpsolver.ifs.heuristics.ValueSelection;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbtValueSelection<V extends Variable<V, T>, T extends Value<V, T>>
implements ValueSelection<V, T> {
    private static Logger sLogger = Logger.getLogger(GeneralValueSelection.class);
    private double iRandomWalkProb = 0.0;
    private double iInitialSelectionProb = 0.0;
    private int iMPPLimit = -1;
    private double iWeightDeltaInitialAssignment = 0.0;
    private double iWeightNrAssignments = 0.5;
    private double iWeightValue = 0.0;
    private boolean iMPP = false;
    private DbtPropagation<V, T> iProp = null;
    private ViolatedInitials<V, T> iViolatedInitials = null;

    public DbtValueSelection(DataProperties properties) {
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        if (this.iMPP) {
            this.iMPPLimit = properties.getPropertyInt("Value.MPPLimit", -1);
            this.iInitialSelectionProb = properties.getPropertyDouble("Value.InitialSelectionProb", 0.75);
            this.iWeightDeltaInitialAssignment = properties.getPropertyDouble("Value.WeightDeltaInitialAssignments", 0.0);
        }
        this.iRandomWalkProb = properties.getPropertyDouble("Value.RandomWalkProb", 0.0);
        this.iWeightNrAssignments = properties.getPropertyDouble("Value.WeightNrAssignments", 0.5);
        this.iWeightValue = properties.getPropertyDouble("Value.WeightValue", 0.0);
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (DbtPropagation.class.isInstance(extension)) {
                this.iProp = (DbtPropagation)extension;
            }
            if (!ViolatedInitials.class.isInstance(extension)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    @Override
    public T selectValue(Solution<V, T> solution, V selectedVariable) {
        ArrayList<Value> values = null;
        if (this.iProp != null) {
            values = new ArrayList(this.iProp.goodValues(selectedVariable).size());
            for (Value value : ((Variable)selectedVariable).values()) {
                if (!this.iProp.isGood(value)) continue;
                Set<Value> conf = solution.getModel().conflictValues(value);
                if (!conf.isEmpty()) {
                    HashSet<Value> noGood = new HashSet<Value>(2 * conf.size());
                    for (Value v : conf) {
                        noGood.add(v);
                    }
                    this.iProp.setNoGood(value, noGood);
                    sLogger.debug((Object)(value + " become nogood (" + noGood + ")"));
                    continue;
                }
                if (solution.isBestComplete() && !(solution.getBestValue() > solution.getModel().getTotalValue() + value.toDouble())) continue;
                values.add(value);
            }
        } else {
            values = new ArrayList<Value>(((Variable)selectedVariable).values().size());
            for (Value value : ((Variable)selectedVariable).values()) {
                if (!solution.getModel().conflictValues(value).isEmpty() || !solution.isBestComplete() || !(solution.getBestValue() > solution.getModel().getTotalValue() + value.toDouble())) continue;
                values.add(value);
            }
        }
        if (values.isEmpty()) {
            return null;
        }
        if (this.iMPP) {
            if (this.iMPPLimit >= 0 && solution.isBestComplete() && solution.getModel().getBestPerturbations() >= 0 && solution.getModel().getBestPerturbations() <= this.iMPPLimit) {
                this.iMPPLimit = solution.getModel().getBestPerturbations() - 1;
                sLogger.debug((Object)("MPP Limit decreased to " + this.iMPPLimit));
            }
            int nrPerts = solution.getModel().perturbVariables().size();
            if (this.iMPPLimit >= 0 && this.iMPPLimit < nrPerts) {
                return null;
            }
            if (this.iMPPLimit >= 0 && this.iMPPLimit == nrPerts && ((Variable)selectedVariable).getInitialAssignment() != null) {
                if (values.contains(((Variable)selectedVariable).getInitialAssignment())) {
                    return ((Variable)selectedVariable).getInitialAssignment();
                }
                return null;
            }
            if (((Variable)selectedVariable).getInitialAssignment() != null && ToolBox.random() <= this.iInitialSelectionProb && values.contains(((Variable)selectedVariable).getInitialAssignment())) {
                return ((Variable)selectedVariable).getInitialAssignment();
            }
        }
        if (values.size() == 1) {
            return (T)((Value)values.get(0));
        }
        if (ToolBox.random() <= this.iRandomWalkProb) {
            return (T)((Value)ToolBox.random(values));
        }
        ArrayList<Value> bestValues = null;
        double bestWeightedSum = 0.0;
        if (this.iWeightDeltaInitialAssignment == 0.0 && this.iWeightNrAssignments == 0.0 && this.iWeightValue == 0.0) {
            return (T)((Value)ToolBox.random(values));
        }
        for (Value value : values) {
            long deltaInitialAssignments = 0L;
            if (this.iWeightDeltaInitialAssignment != 0.0) {
                Set<Value> violations;
                if (this.iViolatedInitials != null && (violations = this.iViolatedInitials.getViolatedInitials(value)) != null) {
                    for (Value aValue : violations) {
                        if (((Variable)aValue.variable()).getAssignment() != null && !((Value)((Variable)aValue.variable()).getAssignment()).equals(aValue)) continue;
                        deltaInitialAssignments += 2L;
                    }
                }
                if (((Variable)selectedVariable).getInitialAssignment() != null && !((Value)((Variable)selectedVariable).getInitialAssignment()).equals(value)) {
                    ++deltaInitialAssignments;
                }
                if (this.iMPPLimit >= 0 && (long)solution.getModel().perturbVariables().size() + deltaInitialAssignments > (long)this.iMPPLimit) continue;
            }
            double weightedSum = this.iWeightDeltaInitialAssignment * (double)deltaInitialAssignments + this.iWeightNrAssignments * (double)value.countAssignments() + this.iWeightValue * value.toDouble();
            if (bestValues == null || bestWeightedSum > weightedSum) {
                bestWeightedSum = weightedSum;
                if (bestValues == null) {
                    bestValues = new ArrayList<Value>();
                } else {
                    bestValues.clear();
                }
                bestValues.add(value);
                continue;
            }
            if (bestWeightedSum != weightedSum) continue;
            bestValues.add(value);
        }
        return (T)(bestValues == null ? null : (Value)ToolBox.random(bestValues));
    }
}

