/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.criteria;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCriterion<V extends Variable<V, T>, T extends Value<V, T>>
implements Criterion<V, T> {
    private Model<V, T> iModel;
    protected double iBest = 0.0;
    protected double iValue = 0.0;
    protected double iWeight = 0.0;
    private double[] iBounds = null;
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
    protected static DecimalFormat sPercentFormat = new DecimalFormat("0.##", new DecimalFormatSymbols(Locale.US));
    protected boolean iDebug = false;
    protected ValueUpdateType iValueUpdateType = ValueUpdateType.BeforeUnassignedAfterAssigned;

    public String getWeightName() {
        return "Weight." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46));
    }

    public double getWeightDefault(DataProperties config) {
        return 0.0;
    }

    @Override
    public boolean init(Solver<V, T> solver) {
        this.iModel = solver.currentSolution().getModel();
        this.iWeight = solver.getProperties().getPropertyDouble(this.getWeightName(), this.getWeightDefault(solver.getProperties()));
        this.iDebug = solver.getProperties().getPropertyBoolean("Debug." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)), solver.getProperties().getPropertyBoolean("Debug.Criterion", false));
        return true;
    }

    public Model<V, T> getModel() {
        return this.iModel;
    }

    @Override
    public double getValue() {
        return this.iValue;
    }

    @Override
    public double getBest() {
        return this.iBest;
    }

    @Override
    public double getValue(Collection<V> variables) {
        double ret = 0.0;
        for (Variable v : variables) {
            Object t = v.getAssignment();
            if (t == null) continue;
            ret += this.getValue(t, null);
        }
        return ret;
    }

    @Override
    public double getWeight() {
        return this.iWeight;
    }

    @Override
    public double getWeightedBest() {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getBest();
    }

    @Override
    public double getWeightedValue() {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getValue();
    }

    @Override
    public double getWeightedValue(T value, Set<T> conflicts) {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getValue(value, conflicts);
    }

    @Override
    public double getWeightedValue(Collection<V> variables) {
        return this.getWeight() == 0.0 ? 0.0 : this.getWeight() * this.getValue(variables);
    }

    protected double[] computeBounds() {
        return this.getBounds(new ArrayList<V>(this.getModel().variables()));
    }

    @Override
    public double[] getBounds() {
        double[] dArray;
        if (this.iBounds == null) {
            this.iBounds = this.computeBounds();
        }
        if (this.iBounds == null) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        } else {
            dArray = this.iBounds;
        }
        return dArray;
    }

    @Override
    public double[] getBounds(Collection<V> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Variable v : variables) {
            Double min = null;
            Double max = null;
            for (Value t : v.values()) {
                double value = this.getValue(t, null);
                if (min == null) {
                    min = value;
                    max = value;
                    continue;
                }
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            if (min == null) continue;
            bounds[0] = bounds[0] + min;
            bounds[1] = bounds[1] + max;
        }
        return bounds;
    }

    @Override
    public void beforeAssigned(long iteration, T value) {
        switch (this.iValueUpdateType) {
            case AfterUnassignedBeforeAssigned: 
            case BeforeUnassignedBeforeAssigned: {
                this.iValue += this.getValue(value, null);
            }
        }
    }

    @Override
    public void afterAssigned(long iteration, T value) {
        switch (this.iValueUpdateType) {
            case AfterUnassignedAfterAssigned: 
            case BeforeUnassignedAfterAssigned: {
                this.iValue += this.getValue(value, null);
            }
        }
    }

    @Override
    public void beforeUnassigned(long iteration, T value) {
        switch (this.iValueUpdateType) {
            case BeforeUnassignedBeforeAssigned: 
            case BeforeUnassignedAfterAssigned: {
                this.iValue -= this.getValue(value, null);
            }
        }
    }

    @Override
    public void afterUnassigned(long iteration, T value) {
        switch (this.iValueUpdateType) {
            case AfterUnassignedBeforeAssigned: 
            case AfterUnassignedAfterAssigned: {
                this.iValue -= this.getValue(value, null);
            }
        }
    }

    @Override
    public void bestSaved() {
        this.iBest = this.iValue;
    }

    @Override
    public void bestRestored() {
        this.iValue = this.iBest;
    }

    @Override
    public void inc(double value) {
        this.iValue += value;
    }

    @Override
    public String getName() {
        return this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)).replaceAll("(?<=[^A-Z])([A-Z])", " $1");
    }

    protected void clearCache() {
        this.iBounds = null;
    }

    @Override
    public void variableAdded(V variable) {
        this.clearCache();
    }

    @Override
    public void variableRemoved(V variable) {
        this.clearCache();
    }

    @Override
    public void constraintAdded(Constraint<V, T> constraint) {
        this.clearCache();
    }

    @Override
    public void constraintRemoved(Constraint<V, T> constraint) {
        this.clearCache();
    }

    protected String getPerc(double value, double min, double max) {
        if (max == min) {
            return sPercentFormat.format(100.0);
        }
        return sPercentFormat.format(100.0 - 100.0 * (value - min) / (max - min));
    }

    protected String getPercRev(double value, double min, double max) {
        if (max == min) {
            return sPercentFormat.format(0.0);
        }
        return sPercentFormat.format(100.0 * (value - min) / (max - min));
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.iDebug) {
            double val = this.getValue();
            double w = this.getWeightedValue();
            double prec = this.getValue(this.getModel().variables());
            double[] bounds = this.getBounds();
            if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1]) {
                info.put("[C] " + this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (value: " + sDoubleFormat.format(val) + (prec != val ? ", precise:" + sDoubleFormat.format(prec) : "") + ", weighted:" + sDoubleFormat.format(w) + ", bounds: " + sDoubleFormat.format(bounds[0]) + "&hellip;" + sDoubleFormat.format(bounds[1]) + ")");
            } else if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0]) {
                info.put("[C] " + this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (value: " + sDoubleFormat.format(val) + (prec != val ? ", precise:" + sDoubleFormat.format(prec) : "") + ", weighted:" + sDoubleFormat.format(w) + ", bounds: " + sDoubleFormat.format(bounds[1]) + "&hellip;" + sDoubleFormat.format(bounds[0]) + ")");
            } else if (bounds[0] != val || val != bounds[1]) {
                info.put("[C] " + this.getName(), sDoubleFormat.format(val) + " (" + (prec != val ? "precise:" + sDoubleFormat.format(prec) + ", " : "") + "weighted:" + sDoubleFormat.format(w) + (bounds[0] != bounds[1] ? ", bounds: " + sDoubleFormat.format(bounds[0]) + "&hellip;" + sDoubleFormat.format(bounds[1]) : "") + ")");
            }
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<V> variables) {
        if (this.iDebug) {
            double val = this.getValue(variables);
            double w = this.getWeightedValue(variables);
            double[] bounds = this.getBounds(variables);
            if (bounds[0] <= val && val <= bounds[1]) {
                info.put("[C] " + this.getName(), this.getPerc(val, bounds[0], bounds[1]) + "% (value: " + sDoubleFormat.format(val) + ", weighted:" + sDoubleFormat.format(w) + ", bounds: " + sDoubleFormat.format(bounds[0]) + "&hellip;" + sDoubleFormat.format(bounds[1]) + ")");
            } else if (bounds[1] <= val && val <= bounds[0]) {
                info.put("[C] " + this.getName(), this.getPercRev(val, bounds[1], bounds[0]) + "% (value: " + sDoubleFormat.format(val) + ", weighted:" + sDoubleFormat.format(w) + ", bounds: " + sDoubleFormat.format(bounds[1]) + "&hellip;" + sDoubleFormat.format(bounds[0]) + ")");
            } else if (bounds[0] != val || val != bounds[1]) {
                info.put("[C] " + this.getName(), sDoubleFormat.format(val) + " (weighted:" + sDoubleFormat.format(w) + (bounds[0] != bounds[1] ? ", bounds: " + sDoubleFormat.format(bounds[0]) + "&hellip;" + sDoubleFormat.format(bounds[1]) : "") + ")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ValueUpdateType {
        BeforeUnassignedBeforeAssigned,
        AfterUnassignedBeforeAssigned,
        BeforeUnassignedAfterAssigned,
        AfterUnassignedAfterAssigned,
        NoUpdate;

    }
}

