/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.constant;

import java.util.ArrayList;
import java.util.List;
import net.sf.cpsolver.ifs.constant.ConstantVariable;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantModel<V extends Variable<V, T>, T extends Value<V, T>>
extends Model<V, T> {
    private List<V> iConstantVariables = null;

    public List<V> constantVariables() {
        return this.iConstantVariables;
    }

    public boolean hasConstantVariables() {
        return this.iConstantVariables != null && !this.iConstantVariables.isEmpty();
    }

    public boolean isConstant(V variable) {
        return this.iConstantVariables != null && variable instanceof ConstantVariable && ((ConstantVariable)variable).isConstant();
    }

    @Override
    public void addVariable(V variable) {
        if (variable instanceof ConstantVariable && ((ConstantVariable)variable).isConstant()) {
            if (this.iConstantVariables == null) {
                this.iConstantVariables = new ArrayList<V>();
            }
            ((Variable)variable).setModel(this);
            this.iConstantVariables.add(variable);
            if (((Variable)variable).getAssignment() != null) {
                ((Variable)variable).assign(0L, ((Variable)variable).getAssignment());
            }
        } else {
            super.addVariable(variable);
        }
    }

    @Override
    public void removeVariable(V variable) {
        if (this.isConstant(variable)) {
            ((Variable)variable).setModel(null);
            this.iConstantVariables.remove(variable);
        } else {
            super.removeVariable(variable);
        }
    }

    @Override
    public void beforeAssigned(long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.beforeAssigned(iteration, value);
        }
    }

    @Override
    public void beforeUnassigned(long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.beforeUnassigned(iteration, value);
        }
    }

    @Override
    public void afterAssigned(long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.afterAssigned(iteration, value);
        }
    }

    @Override
    public void afterUnassigned(long iteration, T value) {
        if (!this.isConstant(((Value)value).variable())) {
            super.afterUnassigned(iteration, value);
        }
    }
}

