/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms.neighbourhoods;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomSwapMove<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T>,
HillClimberSelection {
    protected int iMaxAttempts = 3;
    protected boolean iHC = false;
    protected int iTimeLimit = 200;

    public RandomSwapMove(DataProperties config) {
        this.iMaxAttempts = config.getPropertyInt("RandomSwap.MaxAttempts", this.iMaxAttempts);
        this.iTimeLimit = config.getPropertyInt("RandomSwap.TimeLimit", this.iTimeLimit);
    }

    @Override
    public void setHcMode(boolean hcMode) {
        this.iHC = hcMode;
    }

    @Override
    public void init(Solver<V, T> solver) {
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        Model<V, Value> model = solution.getModel();
        double total = model.getTotalValue();
        int varIdx = ToolBox.random(model.variables().size());
        block0: for (int i = 0; i < model.variables().size(); ++i) {
            Variable variable = (Variable)model.variables().get((i + varIdx) % model.variables().size());
            List values = variable.values();
            if (values.isEmpty()) continue;
            int valIdx = ToolBox.random(values.size());
            Object old = variable.getAssignment();
            int attempts = 0;
            long startTime = JProf.currentTimeMillis();
            for (int j = 0; j < values.size(); ++j) {
                Set<Value> conflicts;
                Value value = (Value)values.get((j + valIdx) % values.size());
                if (value.equals(old) || (conflicts = model.conflictValues(value)).contains(value)) continue;
                if (conflicts.isEmpty()) {
                    SimpleNeighbour<Variable, Value> n = new SimpleNeighbour<Variable, Value>(variable, value);
                    if (this.iHC && !(n.value() <= 0.0)) continue;
                    return n;
                }
                HashMap<Variable, Value> assignments = new HashMap<Variable, Value>();
                assignments.put(variable, value);
                for (Value conflict : conflicts) {
                    ((Variable)conflict.variable()).unassign(solution.getIteration());
                }
                variable.assign(solution.getIteration(), value);
                Double v = this.resolve(solution, total, startTime, assignments, new ArrayList<Value>(conflicts), 0);
                if (!conflicts.isEmpty()) {
                    ++attempts;
                }
                variable.unassign(solution.getIteration());
                for (Value conflict : conflicts) {
                    ((Variable)conflict.variable()).assign(solution.getIteration(), (Value)conflict);
                }
                if (old != null) {
                    variable.assign(solution.getIteration(), old);
                }
                if (v != null) {
                    return new SwapNeighbour(assignments.values(), v);
                }
                if (attempts >= this.iMaxAttempts) continue block0;
            }
        }
        return null;
    }

    protected boolean isTimeLimitReached(long startTime) {
        return this.iTimeLimit > 0 && JProf.currentTimeMillis() - startTime > (long)this.iTimeLimit;
    }

    public Double resolve(Solution<V, T> solution, double total, long startTime, Map<V, T> assignments, List<T> conflicts, int index) {
        if (index == conflicts.size()) {
            return solution.getModel().getTotalValue() - total;
        }
        Value conflict = (Value)conflicts.get(index);
        Object variable = conflict.variable();
        List values = ((Variable)variable).values();
        if (values.isEmpty()) {
            return null;
        }
        int valIdx = ToolBox.random(values.size());
        int attempts = 0;
        for (int i = 0; i < values.size(); ++i) {
            Value value = (Value)values.get((i + valIdx) % values.size());
            if (value.equals(conflict) || solution.getModel().inConflict(value)) continue;
            ((Variable)variable).assign(solution.getIteration(), (Value)value);
            Double v = this.resolve(solution, total, startTime, assignments, conflicts, 1 + index);
            ((Variable)variable).unassign(solution.getIteration());
            ++attempts;
            if (v != null && (!this.iHC || v <= 0.0)) {
                assignments.put((Value)variable, (T)value);
                return v;
            }
            if (attempts >= this.iMaxAttempts || this.isTimeLimitReached(startTime)) break;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SwapNeighbour
    extends Neighbour<V, T> {
        private double iValue = 0.0;
        private Collection<T> iAssignments = null;

        public SwapNeighbour(Collection<T> assignments, double value) {
            this.iAssignments = assignments;
            this.iValue = value;
        }

        @Override
        public double value() {
            return this.iValue;
        }

        @Override
        public void assign(long iteration) {
            for (Value placement : this.iAssignments) {
                if (((Variable)placement.variable()).getAssignment() == null) continue;
                ((Variable)placement.variable()).unassign(iteration);
            }
            for (Value placement : this.iAssignments) {
                ((Variable)placement.variable()).assign(iteration, (Value)placement);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Swap{" + this.iValue + ": ");
            Iterator i = this.iAssignments.iterator();
            while (i.hasNext()) {
                Value p = (Value)i.next();
                sb.append("\n    " + ((Variable)p.variable()).getName() + " " + p.getName() + (i.hasNext() ? "," : ""));
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

