/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cpsolver.ifs.algorithms.NeighbourSelector;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.RandomMove;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.RandomSwapMove;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.SuggestionMove;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.LazyNeighbour;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NeighbourSearch<V extends Variable<V, T>, T extends Value<V, T>>
implements NeighbourSelection<V, T>,
SolutionListener<V, T>,
LazyNeighbour.LazyNeighbourAcceptanceCriterion<V, T> {
    protected Logger iLog;
    protected DecimalFormat iDF2 = new DecimalFormat("0.00");
    protected long iT0 = -1L;
    protected int iIter = 0;
    protected String iPhase = this.getClass().getSimpleName().replaceAll("(?<=[^A-Z])([A-Z])", " $1");
    protected Progress iProgress = null;
    private List<NeighbourSelector<V, T>> iNeighbours = null;
    private boolean iRandomSelection = false;
    private boolean iUpdatePoints = false;
    private double iTotalBonus;

    public NeighbourSearch(DataProperties properties) {
        this.iLog = Logger.getLogger(this.getClass());
        this.iRandomSelection = properties.getPropertyBoolean(this.getParameterBaseName() + ".Random", this.iRandomSelection);
        this.iUpdatePoints = properties.getPropertyBoolean(this.getParameterBaseName() + ".Update", this.iUpdatePoints);
        String neighbours = properties.getProperty(this.getParameterBaseName() + ".Neighbours", RandomMove.class.getName() + ";" + RandomSwapMove.class.getName() + "@0.01;" + SuggestionMove.class.getName() + "@0.01");
        neighbours = neighbours + ";" + properties.getProperty(this.getParameterBaseName() + ".AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelector<V, T>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                double bonus = 1.0;
                if (neighbour.indexOf(64) >= 0) {
                    bonus = Double.parseDouble(neighbour.substring(neighbour.indexOf(64) + 1));
                    neighbour = neighbour.substring(0, neighbour.indexOf(64));
                }
                Class<?> clazz = Class.forName(neighbour);
                NeighbourSelection selection = (NeighbourSelection)clazz.getConstructor(DataProperties.class).newInstance(properties);
                this.addNeighbourSelection(selection, bonus);
            }
            catch (Exception e) {
                this.iLog.error((Object)("Unable to use " + neighbour + ": " + e.getMessage()));
            }
        }
    }

    protected void addNeighbourSelection(NeighbourSelection<V, T> ns, double bonus) {
        this.iNeighbours.add(new NeighbourSelector<V, T>(ns, bonus, this.iUpdatePoints));
    }

    private double totalPoints() {
        if (!this.iUpdatePoints) {
            return this.iTotalBonus;
        }
        double total = 0.0;
        for (NeighbourSelector<V, T> ns : this.iNeighbours) {
            total += ns.getPoints();
        }
        return total;
    }

    protected void setHCMode(boolean hcMode) {
        for (NeighbourSelector<V, T> s : this.iNeighbours) {
            if (!(s.selection() instanceof HillClimberSelection)) continue;
            ((HillClimberSelection)((Object)s.selection())).setHcMode(hcMode);
        }
    }

    protected List<? extends NeighbourSelection<V, T>> getNeighbours() {
        return this.iNeighbours;
    }

    @Override
    public void init(Solver<V, T> solver) {
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iT0 = -1L;
        solver.currentSolution().addSolutionListener(this);
        solver.setUpdateProgress(false);
        for (NeighbourSelection neighbourSelection : this.iNeighbours) {
            neighbourSelection.init(solver);
        }
        solver.setUpdateProgress(false);
        this.iTotalBonus = 0.0;
        for (NeighbourSelector<V, T> neighbourSelector : this.iNeighbours) {
            neighbourSelector.init(solver);
            this.iTotalBonus += neighbourSelector.getBonus();
        }
    }

    protected NeighbourSelection<V, T> nextNeighbourSelection() {
        NeighbourSelector<V, T> ns2 = null;
        if (this.iRandomSelection) {
            ns2 = ToolBox.random(this.iNeighbours);
        } else {
            double points = ToolBox.random() * this.totalPoints();
            for (NeighbourSelector<V, T> ns2 : this.iNeighbours) {
                double d = this.iUpdatePoints ? ns2.getPoints() : ns2.getBonus();
                if (!((points -= d) <= 0.0)) continue;
                break;
            }
        }
        return ns2;
    }

    protected void logNeibourStatus() {
        if (this.iUpdatePoints) {
            for (NeighbourSelector<V, T> ns : this.iNeighbours) {
                this.iLog.info((Object)("  " + ns + " (" + this.iDF2.format(ns.getPoints()) + " pts, " + this.iDF2.format(100.0 * (this.iUpdatePoints ? ns.getPoints() : ns.getBonus()) / this.totalPoints()) + "%)"));
            }
        }
    }

    public Neighbour<V, T> generateMove(Solution<V, T> solution) {
        return this.nextNeighbourSelection().selectNeighbour(solution);
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        if (this.iT0 < 0L) {
            this.activate(solution);
        }
        while (this.canContinue(solution)) {
            this.incIteration(solution);
            Neighbour<V, T> n = this.generateMove(solution);
            if (n == null || !this.accept(solution, n)) continue;
            return n;
        }
        this.deactivate(solution);
        return null;
    }

    protected boolean canContinue(Solution<V, T> solution) {
        return true;
    }

    protected void incIteration(Solution<V, T> solution) {
        ++this.iIter;
    }

    protected long getTimeMillis() {
        return JProf.currentTimeMillis() - this.iT0;
    }

    protected boolean accept(Solution<V, T> solution, Neighbour<V, T> neighbour) {
        if (neighbour instanceof LazyNeighbour) {
            ((LazyNeighbour)neighbour).setAcceptanceCriterion(this);
            return true;
        }
        return this.accept(solution.getModel(), neighbour, neighbour.value(), false);
    }

    @Override
    public boolean accept(LazyNeighbour<V, T> neighbour, double value) {
        return this.accept(neighbour.getModel(), neighbour, value, true);
    }

    protected abstract boolean accept(Model<V, T> var1, Neighbour<V, T> var2, double var3, boolean var5);

    protected void activate(Solution<V, T> solution) {
        this.iT0 = JProf.currentTimeMillis();
        this.iIter = 0;
        this.iProgress.setPhase(this.iPhase + "...");
    }

    protected void deactivate(Solution<V, T> solution) {
        this.iT0 = -1L;
    }

    public abstract String getParameterBaseName();

    @Override
    public void bestSaved(Solution<V, T> solution) {
    }

    @Override
    public void solutionUpdated(Solution<V, T> solution) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<V, T> solution, Map<String, String> info, Collection<V> variables) {
    }

    @Override
    public void bestCleared(Solution<V, T> solution) {
    }

    @Override
    public void bestRestored(Solution<V, T> solution) {
    }
}

