/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.algorithms;

import net.sf.cpsolver.ifs.algorithms.NeighbourSearch;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HillClimber<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSearch<V, T> {
    protected int iMaxIdleIters = 10000;
    protected int iLastImprovingIter = 0;
    protected double iBestValue = 0.0;
    protected boolean iSetHCMode = false;

    public HillClimber(DataProperties properties) {
        super(properties);
        this.iMaxIdleIters = properties.getPropertyInt(this.getParameterBaseName() + ".MaxIdle", this.iMaxIdleIters);
        this.iSetHCMode = properties.getPropertyBoolean(this.getParameterBaseName() + ".SetHCMode", this.iSetHCMode);
    }

    public void setPhase(String phase) {
        this.iPhase = phase;
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        if (this.iSetHCMode) {
            this.setHCMode(true);
        }
    }

    @Override
    protected void incIteration(Solution<V, T> solution) {
        super.incIteration(solution);
        if (this.iIter % 10000 == 0) {
            this.iLog.info((Object)("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + this.iDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + this.iDF2.format(1000.0 * (double)this.iIter / (double)this.getTimeMillis()) + " it/s"));
            this.logNeibourStatus();
        }
        this.iProgress.setProgress(Math.round(100.0 * (double)(this.iIter - this.iLastImprovingIter) / (double)this.iMaxIdleIters));
    }

    @Override
    protected boolean canContinue(Solution<V, T> solution) {
        return this.iIter - this.iLastImprovingIter < this.iMaxIdleIters;
    }

    @Override
    protected void activate(Solution<V, T> solution) {
        super.activate(solution);
        this.iLastImprovingIter = this.iIter;
    }

    @Override
    public void bestSaved(Solution<V, T> solution) {
        if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
            this.iLastImprovingIter = this.iIter;
            this.iBestValue = solution.getBestValue();
        }
    }

    @Override
    protected boolean accept(Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
        return value <= 0.0;
    }

    @Override
    public String getParameterBaseName() {
        return "HillClimber";
    }
}

