/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.split;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.RoomPenalty;
import net.sf.cpsolver.exam.criteria.RoomSizePenalty;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.exam.split.ExamSplitter;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamSplitMoves
implements NeighbourSelection<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamSplitMoves.class);
    private ExamSplitter iSplitter = null;

    public ExamSplitMoves(DataProperties properties) {
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        this.iSplitter = (ExamSplitter)solver.currentSolution().getModel().getCriterion(ExamSplitter.class);
        if (this.iSplitter == null) {
            throw new RuntimeException("ExamSplitter criterion needs to be used as well.");
        }
    }

    public Set<ExamRoomPlacement> findBestAvailableRooms(Exam exam, ExamPeriodPlacement period, int examSize) {
        if (exam.getMaxRooms() == 0) {
            return new HashSet<ExamRoomPlacement>();
        }
        double sw = exam.getModel().getCriterion(RoomSizePenalty.class).getWeight();
        double pw = exam.getModel().getCriterion(RoomPenalty.class).getWeight();
        block0: for (int nrRooms = 1; nrRooms <= exam.getMaxRooms(); ++nrRooms) {
            int size;
            int bestSize;
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (size = 0; rooms.size() < nrRooms && size < examSize; size += bestSize) {
                int minSize = (examSize - size) / (nrRooms - rooms.size());
                ExamRoomPlacement best = null;
                double bestWeight = 0.0;
                bestSize = 0;
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (!room.isAvailable(period.getPeriod()) || !room.getRoom().getPlacements(period.getPeriod()).isEmpty() || rooms.contains(room)) continue;
                    int s = room.getSize(exam.hasAltSeating());
                    if (s < minSize) break;
                    int p = room.getPenalty(period.getPeriod());
                    double w = pw * (double)p + sw * (double)(s - minSize);
                    double d = 0.0;
                    if (!rooms.isEmpty()) {
                        for (ExamRoomPlacement r : rooms) {
                            d += r.getDistanceInMeters(room);
                        }
                        w += d / (double)rooms.size();
                    }
                    if (best != null && !(bestWeight > w)) continue;
                    best = room;
                    bestSize = s;
                    bestWeight = w;
                }
                if (best == null) continue block0;
                rooms.add(best);
            }
            if (size < examSize) continue;
            return rooms;
        }
        return null;
    }

    public ExamSplitNeighbour bestSplit(Exam exam) {
        ExamSplitNeighbour split = null;
        ExamPlacement placement = (ExamPlacement)exam.getAssignment();
        int px = ToolBox.random(exam.getPeriodPlacements().size());
        for (int p = 0; p < exam.getPeriodPlacements().size(); ++p) {
            Set<ExamRoomPlacement> rooms;
            ExamPeriodPlacement period = exam.getPeriodPlacements().get((p + px) % exam.getPeriodPlacements().size());
            if (placement != null && placement.getPeriod().equals(period)) continue;
            ExamSplitNeighbour s = new ExamSplitNeighbour(exam, new ExamPlacement(exam, period, null));
            if (split != null && !(s.value() < split.value()) || (rooms = this.findBestAvailableRooms(exam, period, s.nrStudents())) == null) continue;
            s.placement().getRoomPlacements().addAll(rooms);
            split = s;
        }
        return split;
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamMergeNeighbour merge;
        ExamSplitNeighbour split;
        ExamShuffleNeighbour shuffle;
        Exam exam = ToolBox.random(solution.getModel().assignedVariables());
        Exam parent = this.iSplitter.parent(exam);
        List<Exam> children = this.iSplitter.children(parent);
        if (children != null && !children.isEmpty() && (shuffle = new ExamShuffleNeighbour(exam)).value() < 0.0) {
            return shuffle;
        }
        if (this.iSplitter.canSplit(exam) && (split = this.bestSplit(exam)) != null && split.value() < 0.0) {
            return split;
        }
        if (this.iSplitter.canMerge(exam) && (merge = new ExamMergeNeighbour(exam)).value() < 0.0) {
            return merge;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExamShuffleNeighbour
    extends Neighbour<Exam, ExamPlacement> {
        private Exam iExam;
        private double iValue = 0.0;

        public ExamShuffleNeighbour(Exam exam) {
            this.iExam = exam;
            Exam parent = ExamSplitMoves.this.iSplitter.parent(exam);
            List<Exam> children = ExamSplitMoves.this.iSplitter.children(parent);
            for (ExamStudent student : parent.getStudents()) {
                Double delta = null;
                for (Exam x : children) {
                    double d = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)parent.getAssignment(), (ExamPlacement)x.getAssignment());
                    if (delta != null && !(d < delta)) continue;
                    delta = d;
                }
                if (delta == null || !(delta < 0.0)) continue;
                this.iValue += delta.doubleValue();
            }
            for (Exam child : children) {
                for (ExamStudent student : child.getStudents()) {
                    double delta = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)child.getAssignment(), (ExamPlacement)parent.getAssignment());
                    for (Exam x : children) {
                        double d;
                        if (x.equals(child) || !((d = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)child.getAssignment(), (ExamPlacement)x.getAssignment())) < delta)) continue;
                        delta = d;
                    }
                    if (!(delta < 0.0)) continue;
                    this.iValue += delta;
                }
            }
        }

        @Override
        public void assign(long iteration) {
            sLog.info((Object)("Shuffling " + this.iExam.getName() + " (" + ((ExamPlacement)this.iExam.getAssignment()).getName() + ", value: " + this.iValue + ")"));
            ExamSplitMoves.this.iSplitter.shuffle(this.iExam, iteration);
        }

        @Override
        public double value() {
            return this.iValue;
        }

        public Exam exam() {
            return this.iExam;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExamMergeNeighbour
    extends Neighbour<Exam, ExamPlacement> {
        private Exam iExam;
        private double iValue = 0.0;

        public ExamMergeNeighbour(Exam exam) {
            this.iExam = exam;
            Exam parent = ExamSplitMoves.this.iSplitter.parent(exam);
            List<Exam> children = ExamSplitMoves.this.iSplitter.children(parent);
            for (ExamStudent student : exam.getStudents()) {
                double delta = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)exam.getAssignment(), (ExamPlacement)parent.getAssignment());
                for (Exam child : children) {
                    double d;
                    if (child.equals(exam) || !((d = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)exam.getAssignment(), (ExamPlacement)child.getAssignment())) < delta)) continue;
                    delta = d;
                }
                this.iValue += delta;
            }
            this.iValue -= ExamSplitMoves.this.iSplitter.getWeight();
        }

        @Override
        public void assign(long iteration) {
            sLog.info((Object)("Mergning " + this.iExam.getName() + " (" + ((ExamPlacement)this.iExam.getAssignment()).getName() + ", value: " + this.iValue + ")"));
            ExamSplitMoves.this.iSplitter.merge(this.iExam, iteration);
        }

        @Override
        public double value() {
            return this.iValue;
        }

        public int nrStudents() {
            return this.iExam.getStudents().size();
        }

        public Exam exam() {
            return this.iExam;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExamSplitNeighbour
    extends Neighbour<Exam, ExamPlacement> {
        private Exam iExam;
        private ExamPlacement iPlacement;
        private double iValue = 0.0;
        private int iNrStudents = 0;

        public ExamSplitNeighbour(Exam exam, ExamPlacement placement) {
            this.iExam = exam;
            this.iPlacement = placement;
            Exam parent = ExamSplitMoves.this.iSplitter.parent(exam);
            List<Exam> children = ExamSplitMoves.this.iSplitter.children(parent);
            for (ExamStudent student : parent.getStudents()) {
                double delta = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)parent.getAssignment(), placement);
                if (!(delta < 0.0)) continue;
                this.iValue += delta;
                ++this.iNrStudents;
            }
            if (children != null) {
                for (Exam child : children) {
                    for (ExamStudent student : child.getStudents()) {
                        double delta = ExamSplitMoves.this.iSplitter.delta(student, (ExamPlacement)child.getAssignment(), placement);
                        if (!(delta < 0.0)) continue;
                        this.iValue += delta;
                        ++this.iNrStudents;
                    }
                }
            }
            this.iValue += ExamSplitMoves.this.iSplitter.getWeight();
        }

        @Override
        public void assign(long iteration) {
            sLog.info((Object)("Splitting " + this.iExam.getName() + " (" + ((ExamPlacement)this.iExam.getAssignment()).getName() + ", " + this.iPlacement.getName() + ", value: " + this.iValue + ")"));
            ExamSplitMoves.this.iSplitter.split(this.iExam, iteration, this.iPlacement);
        }

        @Override
        public double value() {
            return this.iValue;
        }

        public int nrStudents() {
            return this.iNrStudents;
        }

        public Exam exam() {
            return this.iExam;
        }

        public ExamPlacement placement() {
            return this.iPlacement;
        }
    }
}

