/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.neighbours;

import java.text.DecimalFormat;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamSimpleNeighbour
extends SimpleNeighbour<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamSimpleNeighbour.class);
    private static boolean sCheck = false;
    private double iValue = 0.0;
    private double iDx;

    public ExamSimpleNeighbour(ExamPlacement placement) {
        super(placement.variable(), placement);
        this.iValue = placement.toDouble();
        this.iValue = ((Exam)placement.variable()).getAssignment() != null ? (this.iValue -= ((ExamPlacement)((Exam)placement.variable()).getAssignment()).toDouble()) : (this.iValue -= 1000.0);
        if (sCheck) {
            this.iDx = placement.toDouble();
            if (((Exam)placement.variable()).getAssignment() != null) {
                this.iDx -= ((ExamPlacement)((Exam)placement.variable()).getAssignment()).toDouble();
            }
        }
    }

    @Override
    public void assign(long iteration) {
        if (sCheck) {
            double beforeVal = ((Exam)this.getVariable()).getModel().getTotalValue();
            double[] beforeValM = ((ExamModel)((Exam)this.getVariable()).getModel()).getTotalMultiValue();
            String n = this.toString();
            ((Exam)this.getVariable()).assign(iteration, (ExamPlacement)this.getValue());
            double afterVal = ((Exam)this.getVariable()).getModel().getTotalValue();
            double[] afterValM = ((ExamModel)((Exam)this.getVariable()).getModel()).getTotalMultiValue();
            if (Math.abs(afterVal - beforeVal - this.iDx) >= 1.0E-7) {
                sLog.error((Object)("-- value mischmatch (delta:" + (afterVal - beforeVal) + ", value:" + this.iDx + ")"));
                sLog.error((Object)("  -- neighbour: " + n));
                sLog.error((Object)("  -- solution:  " + ExamSimpleNeighbour.toString(afterValM, beforeValM)));
            }
        } else {
            ((Exam)this.getVariable()).assign(iteration, (ExamPlacement)this.getValue());
        }
    }

    protected static String toString(double[] x) {
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(df.format(x[i]));
        }
        return "[" + s.toString() + "]";
    }

    protected static String toString(double[] x, double[] y) {
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < x.length; ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(df.format(x[i] - y[i]));
        }
        return "[" + s.toString() + "]";
    }

    @Override
    public String toString() {
        return ((Exam)this.getVariable()).getAssignment() + " -> " + ((ExamPlacement)this.getValue()).toString() + " / " + " (value:" + this.value() + ")";
    }

    @Override
    public double value() {
        return this.iValue;
    }
}

