/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.neighbours;

import java.util.ArrayList;
import java.util.Set;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.exam.neighbours.ExamRoomSwapNeighbour;
import net.sf.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamRoomMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamRoomMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamRoomMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamRoomMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Set<ExamRoomPlacement> rooms;
        ExamPeriodPlacement period;
        ExamModel model = (ExamModel)solution.getModel();
        Exam exam = (Exam)ToolBox.random(model.variables());
        if (exam.getMaxRooms() <= 0) {
            return null;
        }
        ExamPlacement placement = (ExamPlacement)exam.getAssignment();
        ExamPeriodPlacement examPeriodPlacement = period = placement != null ? placement.getPeriodPlacement() : ToolBox.random(exam.getPeriodPlacements());
        if (this.iCheckStudentConflicts && placement == null && exam.countStudentConflicts(period) > 0) {
            return null;
        }
        if (this.iCheckDistributionConstraints && placement == null && !exam.checkDistributionConstraints(period)) {
            return null;
        }
        Set<ExamRoomPlacement> set = rooms = placement != null ? placement.getRoomPlacements() : exam.findBestAvailableRooms(period);
        if (rooms == null || rooms.isEmpty()) {
            return null;
        }
        if (placement == null) {
            placement = new ExamPlacement(exam, period, rooms);
        }
        ArrayList<ExamRoomPlacement> roomVect = new ArrayList<ExamRoomPlacement>(rooms);
        int rx = ToolBox.random(roomVect.size());
        for (int r = 0; r < roomVect.size(); ++r) {
            ExamRoomPlacement current = (ExamRoomPlacement)roomVect.get((r + rx) % roomVect.size());
            int mx = ToolBox.random(exam.getRoomPlacements().size());
            for (int m = 0; m < exam.getRoomPlacements().size(); ++m) {
                ExamRoomPlacement swap = exam.getRoomPlacements().get((m + mx) % exam.getRoomPlacements().size());
                ExamRoomSwapNeighbour n = new ExamRoomSwapNeighbour(placement, current, swap);
                if (!n.canDo()) continue;
                return n;
            }
        }
        rooms = exam.findRoomsRandom(period);
        if (rooms == null) {
            return null;
        }
        return new ExamSimpleNeighbour(new ExamPlacement(exam, period, rooms));
    }
}

