/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.neighbours;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.DistributionPenalty;
import net.sf.cpsolver.exam.criteria.RoomPenalty;
import net.sf.cpsolver.exam.criteria.RoomSizePenalty;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamDistributionConstraint;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.exam.model.ExamRoomSharing;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.LazySwap;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamPeriodSwapMove
implements NeighbourSelection<Exam, ExamPlacement> {
    private boolean iCheckStudentConflicts = false;
    private boolean iCheckDistributionConstraints = true;

    public ExamPeriodSwapMove(DataProperties properties) {
        this.iCheckStudentConflicts = properties.getPropertyBoolean("ExamPeriodSwapMove.CheckStudentConflicts", this.iCheckStudentConflicts);
        this.iCheckDistributionConstraints = properties.getPropertyBoolean("ExamPeriodSwapMove.CheckDistributionConstraints", this.iCheckDistributionConstraints);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        Exam x1 = (Exam)ToolBox.random(model.variables());
        if (x1.getAssignment() == null) {
            return null;
        }
        int x = ToolBox.random(model.variables().size());
        for (int v = 0; v < model.variables().size(); ++v) {
            Exam x2 = (Exam)model.variables().get((v + x) % model.variables().size());
            if (x1.equals(x2) || x2.getAssignment() == null) continue;
            ExamPeriodPlacement p1 = x1.getPeriodPlacement(((ExamPlacement)x2.getAssignment()).getPeriod());
            ExamPeriodPlacement p2 = x2.getPeriodPlacement(((ExamPlacement)x1.getAssignment()).getPeriod());
            if (p1 == null || p2 == null || this.iCheckStudentConflicts && (x1.countStudentConflicts(p1) > 0 || x2.countStudentConflicts(p2) > 0)) continue;
            if (this.iCheckDistributionConstraints) {
                HashMap<Exam, ExamPlacement> placements = new HashMap<Exam, ExamPlacement>();
                placements.put(x1, new ExamPlacement(x1, p1, new HashSet<ExamRoomPlacement>()));
                placements.put(x2, new ExamPlacement(x2, p2, new HashSet<ExamRoomPlacement>()));
                if (!this.checkDistributionConstraints(x1, p1, placements) || !this.checkDistributionConstraints(x2, p2, placements)) continue;
            }
            HashSet<ExamPlacement> conflicts = new HashSet<ExamPlacement>();
            conflicts.add((ExamPlacement)x1.getAssignment());
            conflicts.add((ExamPlacement)x2.getAssignment());
            HashMap<Exam, ExamPlacement> placements = new HashMap<Exam, ExamPlacement>();
            Set<ExamRoomPlacement> r1 = this.findBestAvailableRooms(x1, p1, conflicts, placements);
            if (r1 == null) continue;
            placements.put(x1, new ExamPlacement(x1, p1, r1));
            Set<ExamRoomPlacement> r2 = this.findBestAvailableRooms(x2, p2, conflicts, placements);
            if (r2 == null) continue;
            return new LazySwap<Exam, ExamPlacement>(new ExamPlacement(x1, p1, r1), new ExamPlacement(x2, p2, r2));
        }
        return null;
    }

    public boolean checkDistributionConstraints(Exam exam, ExamPeriodPlacement period, Map<Exam, ExamPlacement> placements) {
        for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
            if (!dc.isHard()) continue;
            boolean before = true;
            for (Exam other : dc.variables()) {
                ExamPlacement placement;
                if (other.equals(this)) {
                    before = false;
                    continue;
                }
                ExamPlacement examPlacement = placement = placements.containsKey(other) ? placements.get(other) : (ExamPlacement)other.getAssignment();
                if (placement == null) continue;
                switch (dc.getType()) {
                    case 2: {
                        if (period.getIndex() == placement.getPeriod().getIndex()) break;
                        return false;
                    }
                    case 3: {
                        if (period.getIndex() != placement.getPeriod().getIndex()) break;
                        return false;
                    }
                    case 4: {
                        if (!(before ? period.getIndex() <= placement.getPeriod().getIndex() : period.getIndex() >= placement.getPeriod().getIndex())) break;
                        return false;
                    }
                    case 5: {
                        if (!(before ? period.getIndex() >= placement.getPeriod().getIndex() : period.getIndex() <= placement.getPeriod().getIndex())) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean checkDistributionConstraints(Exam exam, ExamRoomPlacement room, Set<ExamPlacement> conflictsToIgnore, Map<Exam, ExamPlacement> placements) {
        for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
            if (!dc.isHard()) continue;
            for (Exam other : dc.variables()) {
                ExamPlacement placement;
                if (other.equals(exam) || (placement = placements.containsKey(other) ? placements.get(other) : (ExamPlacement)other.getAssignment()) == null || conflictsToIgnore.contains(placement)) continue;
                switch (dc.getType()) {
                    case 0: {
                        if (placement.getRoomPlacements().contains(room)) break;
                        return false;
                    }
                    case 1: {
                        if (!placement.getRoomPlacements().contains(room)) break;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public int getDistributionConstraintPenalty(Exam exam, ExamRoomPlacement room, Set<ExamPlacement> conflictsToIgnore, Map<Exam, ExamPlacement> placements) {
        int penalty = 0;
        for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
            if (dc.isHard()) continue;
            for (Exam other : dc.variables()) {
                ExamPlacement placement;
                if (other.equals(this) || (placement = placements.containsKey(other) ? placements.get(other) : (ExamPlacement)other.getAssignment()) == null || conflictsToIgnore.contains(placement)) continue;
                switch (dc.getType()) {
                    case 0: {
                        if (placement.getRoomPlacements().contains(room)) break;
                        penalty += dc.getWeight();
                        break;
                    }
                    case 1: {
                        if (!placement.getRoomPlacements().contains(room)) break;
                        penalty += dc.getWeight();
                    }
                }
            }
        }
        return penalty;
    }

    public Set<ExamRoomPlacement> findBestAvailableRooms(Exam exam, ExamPeriodPlacement period, Set<ExamPlacement> conflictsToIgnore, Map<Exam, ExamPlacement> placements) {
        if (exam.getMaxRooms() == 0) {
            return new HashSet<ExamRoomPlacement>();
        }
        double sw = exam.getModel().getCriterion(RoomSizePenalty.class).getWeight();
        double pw = exam.getModel().getCriterion(RoomPenalty.class).getWeight();
        double cw = exam.getModel().getCriterion(DistributionPenalty.class).getWeight();
        ExamRoomSharing sharing = ((ExamModel)exam.getModel()).getRoomSharing();
        block0: for (int nrRooms = 1; nrRooms <= exam.getMaxRooms(); ++nrRooms) {
            int size;
            int bestSize;
            HashSet<ExamRoomPlacement> rooms = new HashSet<ExamRoomPlacement>();
            for (size = 0; rooms.size() < nrRooms && size < exam.getSize(); size += bestSize) {
                int minSize = (exam.getSize() - size) / (nrRooms - rooms.size());
                ExamRoomPlacement best = null;
                double bestWeight = 0.0;
                bestSize = 0;
                for (ExamRoomPlacement room : exam.getRoomPlacements()) {
                    if (!room.isAvailable(period.getPeriod()) || rooms.contains(room)) continue;
                    ArrayList<ExamPlacement> overlaps = new ArrayList<ExamPlacement>();
                    for (ExamPlacement overlap : room.getRoom().getPlacements(period.getPeriod())) {
                        if (conflictsToIgnore.contains(overlap)) continue;
                        overlaps.add(overlap);
                    }
                    for (ExamPlacement other : placements.values()) {
                        if (!other.getPeriod().equals(period.getPeriod())) continue;
                        for (ExamRoomPlacement r : other.getRoomPlacements()) {
                            if (!r.getRoom().equals(room.getRoom())) continue;
                            overlaps.add(other);
                        }
                    }
                    if (nrRooms != 1 || sharing == null ? !overlaps.isEmpty() : sharing.inConflict(exam, overlaps, room.getRoom())) continue;
                    if (this.iCheckDistributionConstraints && !this.checkDistributionConstraints(exam, room, conflictsToIgnore, placements)) continue;
                    int s = room.getSize(exam.hasAltSeating());
                    if (s < minSize) break;
                    int p = room.getPenalty(period.getPeriod());
                    double w = pw * (double)p + sw * (double)(s - minSize) + cw * (double)this.getDistributionConstraintPenalty(exam, room, conflictsToIgnore, placements);
                    double d = 0.0;
                    if (!rooms.isEmpty()) {
                        for (ExamRoomPlacement r : rooms) {
                            d += r.getDistanceInMeters(room);
                        }
                        w += d / (double)rooms.size();
                    }
                    if (best != null && !(bestWeight > w)) continue;
                    best = room;
                    bestSize = s;
                    bestWeight = w;
                }
                if (best == null) continue block0;
                rooms.add(best);
            }
            if (size < exam.getSize()) continue;
            return rooms;
        }
        return null;
    }
}

