/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomSharing;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.ConstraintListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamRoom
extends Constraint<Exam, ExamPlacement> {
    private List<ExamPlacement>[] iTable;
    private boolean[] iAvailable;
    private int[] iPenalty;
    private String iName;
    private int iSize;
    private int iAltSize;
    private Double iCoordX;
    private Double iCoordY;

    public ExamRoom(ExamModel model, long id, String name, int size, int altSize, Double coordX, Double coordY) {
        this.iAssignedVariables = null;
        this.iId = id;
        this.iName = name;
        this.iCoordX = coordX;
        this.iCoordY = coordY;
        this.iSize = size;
        this.iAltSize = altSize;
        this.iTable = new List[model.getNrPeriods()];
        this.iAvailable = new boolean[model.getNrPeriods()];
        this.iPenalty = new int[model.getNrPeriods()];
        for (int i = 0; i < this.iTable.length; ++i) {
            this.iTable[i] = new ArrayList<ExamPlacement>();
            this.iAvailable[i] = true;
            this.iPenalty[i] = 0;
        }
    }

    public double getDistanceInMeters(ExamRoom other) {
        return ((ExamModel)this.getModel()).getDistanceMetric().getDistanceInMeters(this.getId(), this.getCoordX(), this.getCoordY(), other.getId(), other.getCoordX(), other.getCoordY());
    }

    public int getSize() {
        return this.iSize;
    }

    public int getAltSize() {
        return this.iAltSize;
    }

    public Double getCoordX() {
        return this.iCoordX;
    }

    public Double getCoordY() {
        return this.iCoordY;
    }

    @Deprecated
    public ExamPlacement getPlacement(ExamPeriod period) {
        return this.iTable[period.getIndex()].isEmpty() ? null : this.iTable[period.getIndex()].iterator().next();
    }

    public List<ExamPlacement> getPlacements(ExamPeriod period) {
        return this.iTable[period.getIndex()];
    }

    public boolean isAvailable(ExamPeriod period) {
        return this.iAvailable[period.getIndex()];
    }

    public boolean isAvailable(int period) {
        return this.iAvailable[period];
    }

    public boolean isAvailable() {
        for (boolean a : this.iAvailable) {
            if (!a) continue;
            return true;
        }
        return false;
    }

    public void setAvailable(ExamPeriod period, boolean available) {
        this.iAvailable[period.getIndex()] = available;
    }

    public void setAvailable(int period, boolean available) {
        this.iAvailable[period] = available;
    }

    public int getPenalty(ExamPeriod period) {
        return this.iPenalty[period.getIndex()];
    }

    public int getPenalty(int period) {
        return this.iPenalty[period];
    }

    public void setPenalty(ExamPeriod period, int penalty) {
        this.iPenalty[period.getIndex()] = penalty;
    }

    public void setPenalty(int period, int penalty) {
        this.iPenalty[period] = penalty;
    }

    public ExamRoomSharing getRoomSharing() {
        return ((ExamModel)this.getModel()).getRoomSharing();
    }

    @Override
    public void computeConflicts(ExamPlacement p, Set<ExamPlacement> conflicts) {
        if (!p.contains(this)) {
            return;
        }
        if (this.getRoomSharing() == null) {
            for (ExamPlacement conflict : this.iTable[p.getPeriod().getIndex()]) {
                if (((Exam)conflict.variable()).equals(p.variable())) continue;
                conflicts.add(conflict);
            }
        } else {
            this.getRoomSharing().computeConflicts(p, this.iTable[p.getPeriod().getIndex()], this, conflicts);
        }
    }

    @Override
    public boolean inConflict(ExamPlacement p) {
        if (!p.contains(this)) {
            return false;
        }
        if (this.getRoomSharing() == null) {
            for (ExamPlacement conflict : this.iTable[p.getPeriod().getIndex()]) {
                if (((Exam)conflict.variable()).equals(p.variable())) continue;
                return true;
            }
            return false;
        }
        return this.getRoomSharing().inConflict(p, this.iTable[p.getPeriod().getIndex()], this);
    }

    @Override
    public boolean isConsistent(ExamPlacement p1, ExamPlacement p2) {
        return p1.getPeriod() != p2.getPeriod() || !p1.contains(this) || !p2.contains(this);
    }

    @Override
    public void assigned(long iteration, ExamPlacement p) {
        if (p.contains(this) && !this.iTable[p.getPeriod().getIndex()].isEmpty()) {
            HashSet<ExamPlacement> confs = new HashSet<ExamPlacement>();
            this.computeConflicts(p, (Set<ExamPlacement>)confs);
            for (ExamPlacement conf : confs) {
                ((Exam)conf.variable()).unassign(iteration);
            }
            if (this.iConstraintListeners != null) {
                for (ConstraintListener listener : this.iConstraintListeners) {
                    listener.constraintAfterAssigned(iteration, this, p, confs);
                }
            }
        }
    }

    public void afterAssigned(long iteration, ExamPlacement p) {
        if (p.contains(this)) {
            this.iTable[p.getPeriod().getIndex()].add(p);
        }
    }

    @Override
    public void unassigned(long iteration, ExamPlacement p) {
    }

    public void afterUnassigned(long iteration, ExamPlacement p) {
        if (p.contains(this)) {
            this.iTable[p.getPeriod().getIndex()].remove(p);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamRoom)) {
            return false;
        }
        ExamRoom r = (ExamRoom)o;
        return this.getId() == r.getId();
    }

    @Override
    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    public String getName() {
        return this.hasName() ? this.iName : String.valueOf(this.getId());
    }

    public boolean hasName() {
        return this.iName != null && this.iName.length() > 0;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Constraint<Exam, ExamPlacement> o) {
        return this.toString().compareTo(o.toString());
    }
}

