/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamOwner;
import net.sf.cpsolver.exam.model.ExamPeriod;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.model.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamInstructor
extends Constraint<Exam, ExamPlacement> {
    private Set<Exam>[] iTable;
    private Set<Exam>[] iDayTable;
    private String iName;
    private boolean iAllowDirectConflicts = true;
    private List<ExamOwner> iOwners = new ArrayList<ExamOwner>();
    private boolean[] iAvailable = null;

    public ExamInstructor(ExamModel model, long id, String name) {
        int i;
        this.iAllowDirectConflicts = model.getProperties().getPropertyBoolean("Instructor.AllowDirectConflicts", this.iAllowDirectConflicts);
        this.iAssignedVariables = null;
        this.iId = id;
        this.iName = name;
        this.iTable = new Set[model.getNrPeriods()];
        for (i = 0; i < this.iTable.length; ++i) {
            this.iTable[i] = new HashSet<Exam>();
        }
        this.iDayTable = new Set[model.getNrDays()];
        for (i = 0; i < this.iDayTable.length; ++i) {
            this.iDayTable[i] = new HashSet<Exam>();
        }
    }

    public boolean isAllowDirectConflicts() {
        return this.iAllowDirectConflicts;
    }

    public void setAllowDirectConflicts(boolean allowDirectConflicts) {
        this.iAllowDirectConflicts = allowDirectConflicts;
    }

    public Set<Exam> getExams(ExamPeriod period) {
        return this.iTable[period.getIndex()];
    }

    public Set<Exam> getExamsADay(ExamPeriod period) {
        return this.iDayTable[period.getDay()];
    }

    public Set<Exam> getExamsADay(int day) {
        return this.iDayTable[day];
    }

    @Override
    public void computeConflicts(ExamPlacement p, Set<ExamPlacement> conflicts) {
        if (this.isAllowDirectConflicts()) {
            return;
        }
        for (Exam exam : this.iTable[p.getPeriod().getIndex()]) {
            conflicts.add((ExamPlacement)exam.getAssignment());
        }
    }

    @Override
    public boolean inConflict(ExamPlacement p) {
        if (this.isAllowDirectConflicts()) {
            return false;
        }
        return !this.iTable[p.getPeriod().getIndex()].isEmpty();
    }

    @Override
    public boolean isConsistent(ExamPlacement p1, ExamPlacement p2) {
        if (this.isAllowDirectConflicts()) {
            return true;
        }
        return p1.getPeriod() != p2.getPeriod();
    }

    public void afterAssigned(long iteration, ExamPlacement p) {
        this.iTable[p.getPeriod().getIndex()].add((Exam)p.variable());
        this.iDayTable[p.getPeriod().getDay()].add((Exam)p.variable());
    }

    public void afterUnassigned(long iteration, ExamPlacement p) {
        this.iTable[p.getPeriod().getIndex()].remove(p.variable());
        this.iDayTable[p.getPeriod().getDay()].remove(p.variable());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamInstructor)) {
            return false;
        }
        ExamInstructor s = (ExamInstructor)o;
        return this.getId() == s.getId();
    }

    @Override
    public int hashCode() {
        return (int)(this.getId() ^ this.getId() >>> 32);
    }

    @Override
    public String getName() {
        return this.hasName() ? this.iName : String.valueOf(this.getId());
    }

    public boolean hasName() {
        return this.iName != null && this.iName.length() > 0;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(ExamInstructor o) {
        return this.toString().compareTo(o.toString());
    }

    public List<ExamOwner> getOwners() {
        return this.iOwners;
    }

    @Override
    public boolean isHard() {
        return !this.isAllowDirectConflicts();
    }

    public boolean isAvailable(ExamPeriod period) {
        return this.iAvailable == null ? true : this.iAvailable[period.getIndex()];
    }

    public void setAvailable(int period, boolean available) {
        if (this.iAvailable == null) {
            this.iAvailable = new boolean[this.iTable.length];
            for (int i = 0; i < this.iTable.length; ++i) {
                this.iAvailable[i] = true;
            }
        }
        this.iAvailable[period] = available;
    }
}

