/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import net.sf.cpsolver.exam.heuristics.ExamColoringConstruction;
import net.sf.cpsolver.exam.heuristics.ExamConstruction;
import net.sf.cpsolver.exam.heuristics.ExamGreatDeluge;
import net.sf.cpsolver.exam.heuristics.ExamHillClimbing;
import net.sf.cpsolver.exam.heuristics.ExamSimulatedAnnealing;
import net.sf.cpsolver.exam.heuristics.ExamTabuSearch;
import net.sf.cpsolver.exam.heuristics.ExamUnassignedVariableSelection;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.termination.TerminationCondition;
import net.sf.cpsolver.ifs.util.Callback;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamNeighbourSelection
implements NeighbourSelection<Exam, ExamPlacement>,
TerminationCondition<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamNeighbourSelection.class);
    private ExamColoringConstruction iColor = null;
    private ExamConstruction iCon = null;
    private StandardNeighbourSelection<Exam, ExamPlacement> iStd = null;
    private ExamSimulatedAnnealing iSA = null;
    private ExamHillClimbing iHC = null;
    private ExamHillClimbing iFin = null;
    private ExamGreatDeluge iGD = null;
    private int iPhase = -1;
    private boolean iUseGD = false;
    private Progress iProgress = null;
    private Callback iFinalPhaseFinished = null;
    private boolean iCanContinue = true;
    private TerminationCondition<Exam, ExamPlacement> iTerm = null;

    public ExamNeighbourSelection(DataProperties properties) {
        if (properties.getPropertyBoolean("Exam.ColoringConstruction", false)) {
            this.iColor = new ExamColoringConstruction(properties);
        }
        this.iCon = new ExamConstruction(properties);
        try {
            this.iStd = new StandardNeighbourSelection(properties);
            this.iStd.setVariableSelection(new ExamUnassignedVariableSelection(properties));
            this.iStd.setValueSelection(new ExamTabuSearch(properties));
        }
        catch (Exception e) {
            sLog.error((Object)("Unable to initialize standard selection, reason: " + e.getMessage()), (Throwable)e);
            this.iStd = null;
        }
        this.iSA = new ExamSimulatedAnnealing(properties);
        this.iHC = new ExamHillClimbing(properties, "Hill Climbing");
        this.iFin = new ExamHillClimbing(properties, "Finalization");
        this.iGD = new ExamGreatDeluge(properties);
        this.iUseGD = properties.getPropertyBoolean("Exam.GreatDeluge", this.iUseGD);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        if (this.iColor != null) {
            this.iColor.init(solver);
        }
        this.iCon.init(solver);
        this.iStd.init(solver);
        this.iSA.init(solver);
        this.iHC.init(solver);
        this.iFin.init(solver);
        this.iGD.init(solver);
        if (this.iTerm == null) {
            this.iTerm = solver.getTerminationCondition();
            solver.setTerminalCondition(this);
        }
        this.iCanContinue = true;
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
    }

    @Override
    public synchronized Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Neighbour<Exam, ExamPlacement> n = null;
        if (!this.isFinalPhase() && !this.iTerm.canContinue(solution)) {
            this.setFinalPhase(null);
        }
        switch (this.iPhase) {
            case -1: {
                ++this.iPhase;
                sLog.info((Object)"***** construction phase *****");
                if (this.iColor != null && (n = this.iColor.selectNeighbour(solution)) != null) {
                    return n;
                }
            }
            case 0: {
                n = this.iCon.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                if (solution.getModel().nrUnassignedVariables() > 0) {
                    this.iProgress.setPhase("Searching for initial solution...", solution.getModel().variables().size());
                }
                ++this.iPhase;
                sLog.info((Object)"***** cbs/tabu-search phase *****");
            }
            case 1: {
                if (this.iStd != null && solution.getModel().nrUnassignedVariables() > 0) {
                    this.iProgress.setProgress(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables());
                    n = this.iStd.selectNeighbour(solution);
                    if (n != null) {
                        return n;
                    }
                }
                ++this.iPhase;
                sLog.info((Object)"***** hill climbing phase *****");
            }
            case 2: {
                n = this.iHC.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                ++this.iPhase;
                sLog.info((Object)("***** " + (this.iUseGD ? "great deluge" : "simulated annealing") + " phase *****"));
            }
            case 3: {
                if (this.iUseGD) {
                    return this.iGD.selectNeighbour(solution);
                }
                return this.iSA.selectNeighbour(solution);
            }
            case 9999: {
                n = this.iFin.selectNeighbour(solution);
                if (n != null) {
                    return n;
                }
                this.iPhase = -1;
                if (this.iFinalPhaseFinished != null) {
                    this.iFinalPhaseFinished.execute();
                }
                this.iCanContinue = false;
            }
        }
        return null;
    }

    public synchronized void setFinalPhase(Callback finalPhaseFinished) {
        sLog.info((Object)"***** final phase *****");
        this.iFinalPhaseFinished = finalPhaseFinished;
        this.iPhase = 9999;
    }

    public boolean isFinalPhase() {
        return this.iPhase == 9999;
    }

    @Override
    public boolean canContinue(Solution<Exam, ExamPlacement> currentSolution) {
        return this.iCanContinue;
    }
}

