/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.neighbours.ExamRandomMove;
import net.sf.cpsolver.exam.neighbours.ExamRoomMove;
import net.sf.cpsolver.exam.neighbours.ExamTimeMove;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.LazyNeighbour;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solution.SolutionListener;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamGreatDeluge
implements NeighbourSelection<Exam, ExamPlacement>,
SolutionListener<Exam, ExamPlacement>,
LazyNeighbour.LazyNeighbourAcceptanceCriterion<Exam, ExamPlacement> {
    private static Logger sLog = Logger.getLogger(ExamGreatDeluge.class);
    private static DecimalFormat sDF2 = new DecimalFormat("0.00");
    private static DecimalFormat sDF5 = new DecimalFormat("0.00000");
    private double iBound = 0.0;
    private double iCoolRate = 0.99999995;
    private long iIter;
    private double iUpperBound;
    private double iUpperBoundRate = 1.05;
    private double iLowerBoundRate = 0.95;
    private int iMoves = 0;
    private int iAcceptedMoves = 0;
    private int iNrIdle = 0;
    private long iT0 = -1L;
    private long iLastImprovingIter = 0L;
    private double iBestValue = 0.0;
    private Progress iProgress = null;
    private List<NeighbourSelection<Exam, ExamPlacement>> iNeighbours = null;

    public ExamGreatDeluge(DataProperties properties) {
        this.iCoolRate = properties.getPropertyDouble("GreatDeluge.CoolRate", this.iCoolRate);
        this.iUpperBoundRate = properties.getPropertyDouble("GreatDeluge.UpperBoundRate", this.iUpperBoundRate);
        this.iLowerBoundRate = properties.getPropertyDouble("GreatDeluge.LowerBoundRate", this.iLowerBoundRate);
        String neighbours = properties.getProperty("GreatDeluge.Neighbours", ExamRandomMove.class.getName() + ";" + ExamRoomMove.class.getName() + ";" + ExamTimeMove.class.getName());
        neighbours = neighbours + ";" + properties.getProperty("GreatDeluge.AdditionalNeighbours", "");
        this.iNeighbours = new ArrayList<NeighbourSelection<Exam, ExamPlacement>>();
        for (String neighbour : neighbours.split("\\;")) {
            if (neighbour == null || neighbour.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(neighbour);
                this.iNeighbours.add((NeighbourSelection<Exam, ExamPlacement>)clazz.getConstructor(DataProperties.class).newInstance(properties));
            }
            catch (Exception e) {
                sLog.error((Object)("Unable to use " + neighbour + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        this.iIter = -1L;
        solver.currentSolution().addSolutionListener(this);
        for (NeighbourSelection<Exam, ExamPlacement> neighbour : this.iNeighbours) {
            neighbour.init(solver);
        }
        solver.setUpdateProgress(false);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
    }

    protected void info(Solution<Exam, ExamPlacement> solution) {
        sLog.info((Object)("Iter=" + this.iIter / 1000L + "k, NonImpIter=" + sDF2.format((double)(this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + sDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s"));
        sLog.info((Object)("Bound is " + sDF2.format(this.iBound) + ", " + "best value is " + sDF2.format(solution.getBestValue()) + " (" + sDF2.format(100.0 * this.iBound / solution.getBestValue()) + "%), " + "current value is " + sDF2.format(solution.getModel().getTotalValue()) + " (" + sDF2.format(100.0 * this.iBound / solution.getModel().getTotalValue()) + "%), " + "#idle=" + this.iNrIdle + ", " + "Pacc=" + sDF5.format(100.0 * (double)this.iAcceptedMoves / (double)this.iMoves) + "%"));
        this.iMoves = 0;
        this.iAcceptedMoves = 0;
    }

    public Neighbour<Exam, ExamPlacement> genMove(Solution<Exam, ExamPlacement> solution) {
        NeighbourSelection<Exam, ExamPlacement> ns;
        Neighbour<Exam, ExamPlacement> n;
        do {
            this.incIter(solution);
        } while ((n = (ns = this.iNeighbours.get(ToolBox.random(this.iNeighbours.size()))).selectNeighbour(solution)) == null);
        return n;
    }

    protected boolean accept(Solution<Exam, ExamPlacement> solution, Neighbour<Exam, ExamPlacement> neighbour) {
        if (neighbour instanceof LazyNeighbour) {
            ((LazyNeighbour)neighbour).setAcceptanceCriterion(this);
            return true;
        }
        return neighbour.value() <= 0.0 || solution.getModel().getTotalValue() + neighbour.value() <= this.iBound;
    }

    @Override
    public boolean accept(LazyNeighbour<Exam, ExamPlacement> neighbour, double value) {
        return value <= 0.0 || neighbour.getModel().getTotalValue() <= this.iBound;
    }

    protected void incIter(Solution<Exam, ExamPlacement> solution) {
        double lowerBound;
        if (this.iIter < 0L) {
            this.iIter = 0L;
            this.iLastImprovingIter = 0L;
            this.iT0 = JProf.currentTimeMillis();
            this.iUpperBound = this.iBound = solution.getBestValue() > 0.0 ? this.iUpperBoundRate * solution.getBestValue() : solution.getBestValue() / this.iUpperBoundRate;
            this.iNrIdle = 0;
            this.iProgress.setPhase("Great deluge [" + (1 + this.iNrIdle) + "]...");
        } else {
            ++this.iIter;
            this.iBound = solution.getBestValue() >= 0.0 ? (this.iBound *= this.iCoolRate) : (this.iBound /= this.iCoolRate);
        }
        if (this.iIter % 100000L == 0L) {
            this.info(solution);
        }
        double d = lowerBound = solution.getBestValue() >= 0.0 ? Math.pow(this.iLowerBoundRate, 1 + this.iNrIdle) * solution.getBestValue() : solution.getBestValue() / Math.pow(this.iLowerBoundRate, 1 + this.iNrIdle);
        if (this.iBound < lowerBound) {
            ++this.iNrIdle;
            sLog.info((Object)(" -<[" + this.iNrIdle + "]>- "));
            this.iUpperBound = this.iBound = Math.max(solution.getBestValue() + 2.0, solution.getBestValue() >= 0.0 ? Math.pow(this.iUpperBoundRate, this.iNrIdle) * solution.getBestValue() : solution.getBestValue() / Math.pow(this.iUpperBoundRate, this.iNrIdle));
            this.iProgress.setPhase("Great deluge [" + (1 + this.iNrIdle) + "]...");
        }
        this.iProgress.setProgress(100L - Math.round(100.0 * (this.iBound - lowerBound) / (this.iUpperBound - lowerBound)));
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        Neighbour<Exam, ExamPlacement> neighbour = null;
        while ((neighbour = this.genMove(solution)) != null) {
            ++this.iMoves;
            if (!this.accept(solution, neighbour)) continue;
            ++this.iAcceptedMoves;
            break;
        }
        return neighbour == null ? null : neighbour;
    }

    @Override
    public void bestSaved(Solution<Exam, ExamPlacement> solution) {
        if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
            this.iLastImprovingIter = this.iIter;
            this.iNrIdle = 0;
            this.iBestValue = solution.getBestValue();
        }
    }

    @Override
    public void solutionUpdated(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info) {
    }

    @Override
    public void getInfo(Solution<Exam, ExamPlacement> solution, Map<String, String> info, Collection<Exam> variables) {
    }

    @Override
    public void bestCleared(Solution<Exam, ExamPlacement> solution) {
    }

    @Override
    public void bestRestored(Solution<Exam, ExamPlacement> solution) {
    }
}

