/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.heuristics;

import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamModel;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.exam.neighbours.ExamSimpleNeighbour;
import net.sf.cpsolver.ifs.heuristics.NeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.Progress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExamConstruction
implements NeighbourSelection<Exam, ExamPlacement> {
    private HashSet<String> iAssignments = new HashSet();
    private boolean iCheckLocalOptimality = false;
    private HashSet<Exam> iSkip = new HashSet();
    private Progress iProgress = null;
    private boolean iActive;

    public ExamConstruction(DataProperties properties) {
        this.iCheckLocalOptimality = properties.getPropertyBoolean("ExamConstruction.CheckLocalOptimality", this.iCheckLocalOptimality);
    }

    @Override
    public void init(Solver<Exam, ExamPlacement> solver) {
        this.iSkip.clear();
        solver.setUpdateProgress(false);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        this.iActive = false;
    }

    public Neighbour<Exam, ExamPlacement> checkLocalOptimality(ExamModel model) {
        if (this.iCheckLocalOptimality) {
            for (Exam exam : model.assignedVariables()) {
                ExamPlacement current = (ExamPlacement)exam.getAssignment();
                if (current.getTimeCost() <= 0.0) continue;
                ExamPlacement best = null;
                for (ExamPeriodPlacement period : exam.getPeriodPlacements()) {
                    Set<ExamRoomPlacement> rooms;
                    if (exam.countStudentConflicts(period) > 0 && this.iAssignments.contains(exam.getId() + ":" + period.getIndex()) || !exam.checkDistributionConstraints(period)) continue;
                    ExamPlacement placement = new ExamPlacement(exam, period, null);
                    if (best != null && !(best.getTimeCost() > placement.getTimeCost()) || (rooms = exam.findBestAvailableRooms(period)) == null) continue;
                    best = new ExamPlacement(exam, period, rooms);
                }
                if (best == null || !(best.getTimeCost() < current.getTimeCost())) continue;
                return new ExamSimpleNeighbour(best);
            }
        }
        this.iActive = false;
        return null;
    }

    @Override
    public Neighbour<Exam, ExamPlacement> selectNeighbour(Solution<Exam, ExamPlacement> solution) {
        ExamModel model = (ExamModel)solution.getModel();
        if (!this.iActive) {
            this.iActive = true;
            this.iProgress.setPhase("Construction ...", model.variables().size());
        }
        this.iProgress.setProgress(model.nrAssignedVariables());
        if (model.nrUnassignedVariables() <= this.iSkip.size()) {
            return this.checkLocalOptimality(model);
        }
        Exam bestExam = null;
        for (Exam exam : model.unassignedVariables()) {
            if (this.iSkip.contains(exam) || bestExam != null && exam.compareTo(bestExam) >= 0) continue;
            bestExam = exam;
        }
        ExamPlacement best = null;
        for (ExamPeriodPlacement period : bestExam.getPeriodPlacements()) {
            Set<ExamRoomPlacement> rooms;
            if (bestExam.countStudentConflicts(period) > 0 && this.iAssignments.contains(bestExam.getId() + ":" + period.getIndex()) || !bestExam.checkDistributionConstraints(period)) continue;
            ExamPlacement placement = new ExamPlacement(bestExam, period, null);
            if (best != null && !(best.getTimeCost() > placement.getTimeCost()) || (rooms = bestExam.findBestAvailableRooms(period)) == null) continue;
            best = new ExamPlacement(bestExam, period, rooms);
        }
        if (best != null) {
            this.iAssignments.add(bestExam.getId() + ":" + best.getPeriod().getIndex());
            return new ExamSimpleNeighbour(best);
        }
        if (!this.iSkip.contains(bestExam)) {
            this.iSkip.add(bestExam);
            return this.selectNeighbour(solution);
        }
        return this.checkLocalOptimality(model);
    }
}

