/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria.additional;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomViolation
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exam.SoftRooms";
    }

    @Override
    public String getXmlWeightName() {
        return "softRooms";
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        double penalty = 0.0;
        if (value.getRoomPlacements() != null) {
            for (ExamRoomPlacement r : value.getRoomPlacements()) {
                penalty += this.getWeight() == (double)r.getPenalty() || this.getWeight() == (double)r.getRoom().getPenalty(value.getPeriod()) ? 1.0 / (double)value.getRoomPlacements().size() : 0.0;
            }
        }
        return penalty;
    }

    @Override
    public double[] getBounds(Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        block0: for (Exam exam : variables) {
            if (exam.getRoomPlacements().isEmpty()) continue;
            for (ExamRoomPlacement roomPlacement : exam.getRoomPlacements()) {
                if (this.getWeight() != (double)roomPlacement.getPenalty() || !roomPlacement.getRoom().isAvailable()) continue;
                bounds[1] = bounds[1] + 1.0;
                continue block0;
            }
        }
        return bounds;
    }

    public String toString() {
        return this.getValue() <= 0.0 ? "" : "!R:" + sDoubleFormat.format(this.getValue());
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

