/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentMoreThan2ADayConflicts
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.MoreThanTwoADayWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 100.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamStudent s : exam.getStudents()) {
            Set<Exam> exams = s.getExamsADay(value.getPeriod());
            int nrExams = exams.size() + (exams.contains(exam) ? 0 : 1);
            if (nrExams <= 2) continue;
            ++penalty;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "More Than 2 A Day Conflicts";
    }

    @Override
    public String getXmlWeightName() {
        return "moreThanTwoADayWeight";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue()));
        }
    }

    public String toString() {
        return "M2D:" + sDoubleFormat.format(this.getValue());
    }
}

