/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamStudent;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentBackToBackConflicts
extends ExamCriterion {
    private boolean iDayBreakBackToBack = false;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        boolean ret = super.init(solver);
        this.iDayBreakBackToBack = solver.getProperties().getPropertyBoolean("Exams.IsDayBreakBackToBack", this.iDayBreakBackToBack);
        return ret;
    }

    @Override
    public String getWeightName() {
        return "Exams.BackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "backToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 10.0;
    }

    public boolean isDayBreakBackToBack() {
        return this.iDayBreakBackToBack;
    }

    public void setDayBreakBackToBack(boolean dayBreakBackToBack) {
        this.iDayBreakBackToBack = dayBreakBackToBack;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("isDayBreakBackToBack", this.isDayBreakBackToBack() ? "true" : "false");
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.setDayBreakBackToBack("true".equals(params.get("isDayBreakBackToBack")));
        }
        catch (NumberFormatException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        for (ExamStudent s : exam.getStudents()) {
            int nrExams;
            Set<Exam> exams;
            if (value.getPeriod().prev() != null && (this.isDayBreakBackToBack() || value.getPeriod().prev().getDay() == value.getPeriod().getDay())) {
                exams = s.getExams(value.getPeriod().prev());
                nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
                penalty += nrExams;
            }
            if (value.getPeriod().next() == null || !this.isDayBreakBackToBack() && value.getPeriod().next().getDay() != value.getPeriod().getDay()) continue;
            exams = s.getExams(value.getPeriod().next());
            nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
            penalty += nrExams;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Back-To-Back Conflicts";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue()));
        }
    }

    public String toString() {
        return "BTB:" + sDoubleFormat.format(this.getValue());
    }
}

