/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Set;
import net.sf.cpsolver.exam.criteria.PerturbationPenalty;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.exam.model.ExamRoomPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomPerturbationPenalty
extends PerturbationPenalty {
    @Override
    public String getWeightName() {
        return "Exams.RoomPerturbationWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "roomPerturbationWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 0.01;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        if (!this.isMPP()) {
            return 0.0;
        }
        Exam exam = (Exam)value.variable();
        ExamPlacement initial = (ExamPlacement)exam.getInitialAssignment();
        if (initial == null) {
            return 0.0;
        }
        int penalty = 0;
        if (value.getRoomPlacements() != null) {
            for (ExamRoomPlacement rp : value.getRoomPlacements()) {
                if (initial.getRoomPlacements() != null && initial.getRoomPlacements().contains(rp)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public String toString() {
        return this.isMPP() ? "IRP:" + sDoubleFormat.format(this.getValue()) : "";
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

