/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.criteria.additional.PeriodViolation;
import net.sf.cpsolver.exam.model.Exam;
import net.sf.cpsolver.exam.model.ExamPeriodPlacement;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodPenalty
extends ExamCriterion {
    protected Integer iSoftPeriods = null;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        if (super.init(solver)) {
            this.iSoftPeriods = solver.getProperties().getPropertyInteger("Exam.SoftPeriods", null);
            if (this.iSoftPeriods != null) {
                PeriodViolation pv = new PeriodViolation();
                this.getModel().addCriterion(pv);
                return pv.init(solver);
            }
        }
        return true;
    }

    @Override
    public String getWeightName() {
        return "Exams.PeriodWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "periodWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        return this.iSoftPeriods == null || value.getPeriodPlacement().getExamPenalty() != this.iSoftPeriods.intValue() && value.getPeriodPlacement().getPeriod().getPenalty() != this.iSoftPeriods.intValue() ? (double)value.getPeriodPlacement().getPenalty() : 0.0;
    }

    @Override
    public double[] getBounds(Collection<Exam> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Exam exam : variables) {
            if (exam.getPeriodPlacements().isEmpty()) continue;
            int minPenalty = Integer.MAX_VALUE;
            int maxPenalty = Integer.MIN_VALUE;
            for (ExamPeriodPlacement periodPlacement : exam.getPeriodPlacements()) {
                if (this.iSoftPeriods != null && (periodPlacement.getExamPenalty() == this.iSoftPeriods.intValue() || periodPlacement.getPeriod().getPenalty() == this.iSoftPeriods.intValue())) continue;
                minPenalty = Math.min(minPenalty, periodPlacement.getPenalty());
                maxPenalty = Math.max(maxPenalty, periodPlacement.getPenalty());
            }
            bounds[0] = bounds[0] + (double)minPenalty;
            bounds[1] = bounds[1] + (double)maxPenalty;
        }
        return bounds;
    }

    public String toString() {
        return "PP:" + sDoubleFormat.format(this.getValue());
    }
}

