/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.exam.criteria.ExamCriterion;
import net.sf.cpsolver.exam.model.ExamPlacement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodIndexPenalty
extends ExamCriterion {
    @Override
    public String getWeightName() {
        return "Exams.PeriodIndexWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "periodIndexWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0E-7;
    }

    @Override
    public double getValue(ExamPlacement value, Set<ExamPlacement> conflicts) {
        return value.getPeriod().getIndex();
    }

    @Override
    public String getName() {
        return "Average Period";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        if (this.getValue() != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue() / (double)this.getModel().nrAssignedVariables()));
        }
    }

    public String toString() {
        return "PI:" + sDoubleFormat.format(this.getValue() / (double)this.getModel().nrAssignedVariables());
    }
}

