/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.neighbourhoods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.algorithms.neighbourhoods.RandomSwapMove;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.model.SimpleNeighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomSwap
extends RandomSwapMove<Lecture, Placement> {
    public RoomSwap(DataProperties config) {
        super(config);
    }

    @Override
    public void init(Solver<Lecture, Placement> solver) {
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        TimetableModel model = (TimetableModel)solution.getModel();
        double total = model.getTotalValue();
        int varIdx = ToolBox.random(model.variables().size());
        block0: for (int i = 0; i < model.variables().size(); ++i) {
            List<RoomLocation> values;
            Lecture lecture = (Lecture)model.variables().get((i + varIdx) % model.variables().size());
            Placement old = (Placement)lecture.getAssignment();
            if (old == null || old.getNrRooms() != 1 || (values = lecture.roomLocations()).isEmpty()) continue;
            int attempts = 0;
            int valIdx = ToolBox.random(values.size());
            long startTime = JProf.currentTimeMillis();
            for (int j = 0; j < values.size(); ++j) {
                Set<Placement> conflicts;
                Placement placement;
                RoomLocation room = values.get((j + valIdx) % values.size());
                if (room.getPreference() > 50 || room.equals(old.getRoomLocation()) || !(placement = new Placement(lecture, old.getTimeLocation(), room)).isValid() || (conflicts = model.conflictValues(placement)).contains(placement)) continue;
                if (conflicts.isEmpty()) {
                    SimpleNeighbour<Lecture, Placement> n = new SimpleNeighbour<Lecture, Placement>(lecture, placement);
                    if (this.iHC && !(n.value() <= 0.0)) continue;
                    return n;
                }
                HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
                assignments.put(lecture, placement);
                for (Placement conflict : conflicts) {
                    ((Lecture)conflict.variable()).unassign(solution.getIteration());
                }
                lecture.assign(solution.getIteration(), placement);
                Double v = this.resolve(solution, total, startTime, (Map<Lecture, Placement>)assignments, (List<Placement>)new ArrayList<Placement>(conflicts), 0);
                if (!conflicts.isEmpty()) {
                    ++attempts;
                }
                lecture.unassign(solution.getIteration());
                for (Placement conflict : conflicts) {
                    ((Lecture)conflict.variable()).assign(solution.getIteration(), conflict);
                }
                lecture.assign(solution.getIteration(), old);
                if (v != null) {
                    return new RandomSwapMove.SwapNeighbour(this, assignments.values(), v);
                }
                if (attempts >= this.iMaxAttempts) continue block0;
            }
        }
        return null;
    }

    @Override
    public Double resolve(Solution<Lecture, Placement> solution, double total, long startTime, Map<Lecture, Placement> assignments, List<Placement> conflicts, int index) {
        if (index == conflicts.size()) {
            return solution.getModel().getTotalValue() - total;
        }
        Placement conflict = conflicts.get(index);
        Lecture variable = (Lecture)conflict.variable();
        if (conflict.getNrRooms() != 1) {
            return null;
        }
        List<RoomLocation> values = variable.roomLocations();
        if (values.isEmpty()) {
            return null;
        }
        int valIdx = ToolBox.random(values.size());
        int attempts = 0;
        for (int i = 0; i < values.size(); ++i) {
            Placement value;
            RoomLocation room = values.get((i + valIdx) % values.size());
            if (room.getPreference() > 50 || room.equals(conflict.getRoomLocation()) || !(value = new Placement(variable, conflict.getTimeLocation(), room)).isValid() || solution.getModel().inConflict(value)) continue;
            variable.assign(solution.getIteration(), value);
            Double v = this.resolve(solution, total, startTime, assignments, conflicts, 1 + index);
            variable.unassign(solution.getIteration());
            ++attempts;
            if (v != null && (!this.iHC || v <= 0.0)) {
                assignments.put(variable, value);
                return v;
            }
            if (attempts >= this.iMaxAttempts || this.isTimeLimitReached(startTime)) break;
        }
        return null;
    }
}

