/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.model;

import java.util.BitSet;
import java.util.Enumeration;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.ifs.util.ToolBox;

public class TimeLocation {
    private int iStartSlot;
    private int iPreference;
    private double iNormalizedPreference;
    private Long iTimePatternId = null;
    private int iHashCode;
    private int iDayCode;
    private int iLength;
    private int iNrMeetings;
    private int iBreakTime;
    private BitSet iWeekCode;
    private Long iDatePatternId = null;
    private String iDatePatternName = null;
    private int iDatePreference;
    private int[] iDaysCache = null;
    private Integer iFirstMeeting = null;

    public TimeLocation(int dayCode, int startTime, int length, int pref, double normPref, int datePatternPreference, Long datePatternId, String datePatternName, BitSet weekCode, int breakTime) {
        int i;
        this.iPreference = pref;
        this.iNormalizedPreference = normPref;
        this.iStartSlot = startTime;
        this.iDayCode = dayCode;
        this.iLength = length;
        this.iBreakTime = breakTime;
        this.iNrMeetings = 0;
        for (i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.iDayCode & Constants.DAY_CODES[i]) == 0) continue;
            ++this.iNrMeetings;
        }
        this.iHashCode = TimeLocation.combine(TimeLocation.combine(this.iDayCode, this.iStartSlot), this.iLength);
        this.iDatePatternName = datePatternName;
        this.iWeekCode = weekCode;
        this.iDatePatternId = datePatternId;
        if (this.iDatePatternName == null) {
            this.iDatePatternName = "not set";
        }
        this.iDatePreference = datePatternPreference;
        if (this.iWeekCode == null) {
            this.iWeekCode = new BitSet(366);
            for (i = 0; i <= 365; ++i) {
                this.iWeekCode.set(i);
            }
        }
    }

    public TimeLocation(int dayCode, int startTime, int length, int pref, double normPref, Long datePatternId, String datePatternName, BitSet weekCode, int breakTime) {
        this(dayCode, startTime, length, pref, normPref, 0, datePatternId, datePatternName, weekCode, breakTime);
    }

    public int getNrMeetings() {
        return this.iNrMeetings;
    }

    public int getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(int breakTime) {
        this.iBreakTime = breakTime;
    }

    private static int combine(int a, int b) {
        int ret = 0;
        for (int i = 0; i < 15; ++i) {
            ret = ret | (a & 1 << i) << i | (b & 1 << i) << i + 1;
        }
        return ret;
    }

    public int getDayCode() {
        return this.iDayCode;
    }

    public String getDayHeader() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((this.iDayCode & Constants.DAY_CODES[i]) == 0) continue;
            sb.append(Constants.DAY_NAMES_SHORT[i]);
        }
        return sb.toString();
    }

    public String getStartTimeHeader() {
        int min = this.iStartSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int h = min / 60;
        int m = min % 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public String getEndTimeHeader() {
        int min = (this.iStartSlot + this.iLength) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - this.getBreakTime();
        int m = min % 60;
        int h = min / 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public String getEndTimeHeaderNoAdj() {
        int min = (this.iStartSlot + this.iLength) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        int m = min % 60;
        int h = min / 60;
        return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a");
    }

    public int getStartSlot() {
        return this.iStartSlot;
    }

    public boolean shareDays(TimeLocation anotherLocation) {
        return (this.iDayCode & anotherLocation.iDayCode) != 0;
    }

    public int nrSharedDays(TimeLocation anotherLocation) {
        int ret = 0;
        for (int i = 0; i < Constants.NR_DAYS; ++i) {
            if ((this.iDayCode & Constants.DAY_CODES[i]) == 0 || (anotherLocation.iDayCode & Constants.DAY_CODES[i]) == 0) continue;
            ++ret;
        }
        return ret;
    }

    public boolean shareHours(TimeLocation anotherLocation) {
        return this.iStartSlot + this.iLength > anotherLocation.iStartSlot && anotherLocation.iStartSlot + anotherLocation.iLength > this.iStartSlot;
    }

    public int nrSharedHours(TimeLocation anotherLocation) {
        int start;
        int end = Math.min(this.iStartSlot + this.iLength, anotherLocation.iStartSlot + anotherLocation.iLength);
        return end < (start = Math.max(this.iStartSlot, anotherLocation.iStartSlot)) ? 0 : end - start;
    }

    public boolean shareWeeks(TimeLocation anotherLocation) {
        return this.iWeekCode.intersects(anotherLocation.iWeekCode);
    }

    public boolean shareWeeks(BitSet weekCode) {
        return this.iWeekCode.intersects(weekCode);
    }

    public boolean hasDay(int day) {
        return this.iWeekCode.get(day);
    }

    public boolean hasIntersection(TimeLocation anotherLocation) {
        return this.shareDays(anotherLocation) && this.shareHours(anotherLocation) && this.shareWeeks(anotherLocation);
    }

    public IntEnumeration getSlots() {
        return new SlotsEnum();
    }

    public IntEnumeration getStartSlots() {
        return new StartSlotsEnum();
    }

    public IntEnumeration getDays() {
        return new DaysEnum();
    }

    public int[] getDaysArray() {
        if (this.iDaysCache == null) {
            this.iDaysCache = new int[this.getNrMeetings()];
            int i = 0;
            IntEnumeration e = this.getDays();
            while (e.hasMoreElements()) {
                this.iDaysCache[i++] = (Integer)e.nextElement();
            }
        }
        return this.iDaysCache;
    }

    public String getName() {
        return this.getDayHeader() + " " + this.getStartTimeHeader();
    }

    public String getLongName() {
        return this.getDayHeader() + " " + this.getStartTimeHeader() + " - " + this.getEndTimeHeader() + " " + this.getDatePatternName();
    }

    public String getLongNameNoAdj() {
        return this.getDayHeader() + " " + this.getStartTimeHeader() + " - " + this.getEndTimeHeaderNoAdj() + " " + this.getDatePatternName();
    }

    public int getPreference() {
        return this.iPreference;
    }

    public void setPreference(int preference) {
        this.iPreference = preference;
    }

    public int getLength() {
        return this.iLength;
    }

    public int getNrSlotsPerMeeting() {
        return this.iLength;
    }

    public double getNormalizedPreference() {
        return this.iNormalizedPreference;
    }

    public void setNormalizedPreference(double normalizedPreference) {
        this.iNormalizedPreference = normalizedPreference;
    }

    public Long getTimePatternId() {
        return this.iTimePatternId;
    }

    public Long getDatePatternId() {
        return this.iDatePatternId;
    }

    public void setTimePatternId(Long timePatternId) {
        this.iTimePatternId = timePatternId;
    }

    public BitSet getWeekCode() {
        return this.iWeekCode;
    }

    public String getDatePatternName() {
        return this.iDatePatternName;
    }

    public void setDatePattern(Long datePatternId, String datePatternName, BitSet weekCode) {
        this.iDatePatternId = datePatternId;
        this.iDatePatternName = datePatternName;
        this.iWeekCode = weekCode;
    }

    public int getDatePatternPreference() {
        return this.iDatePreference;
    }

    public String toString() {
        return this.getName() + " (" + this.iNormalizedPreference + ")";
    }

    public int hashCode() {
        return this.iHashCode;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimeLocation)) {
            return false;
        }
        TimeLocation t = (TimeLocation)o;
        if (this.getStartSlot() != t.getStartSlot()) {
            return false;
        }
        if (this.getLength() != t.getLength()) {
            return false;
        }
        if (this.getDayCode() != t.getDayCode()) {
            return false;
        }
        return ToolBox.equals(this.getTimePatternId(), t.getTimePatternId()) && ToolBox.equals(this.getDatePatternId(), t.getDatePatternId());
    }

    public int getNrWeeks() {
        return this.getNrWeeks(0, this.iWeekCode.size() - 1);
    }

    public int getNrWeeks(int startDay, int endDay) {
        int card = this.iWeekCode.get(startDay, endDay).cardinality();
        if (card == 0) {
            return 0;
        }
        if (card <= 7) {
            return 1;
        }
        return (5 + card) / 6;
    }

    public int getFirstMeeting(int dayOfWeekOffset) {
        if (this.iFirstMeeting == null) {
            int idx = -1;
            while ((idx = this.getWeekCode().nextSetBit(1 + idx)) >= 0) {
                int dow = (idx + dayOfWeekOffset) % 7;
                if ((this.getDayCode() & Constants.DAY_CODES[dow]) == 0) continue;
                break;
            }
            this.iFirstMeeting = idx;
        }
        return this.iFirstMeeting;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IntEnumeration
    extends Enumeration<Integer> {
        @Deprecated
        public Integer nextInt();
    }

    private class SlotsEnum
    extends StartSlotsEnum {
        int pos;

        private SlotsEnum() {
            this.pos = 0;
        }

        private boolean nextSlot() {
            if (this.pos + 1 < TimeLocation.this.iLength) {
                ++this.pos;
                return true;
            }
            if (this.nextDay()) {
                this.pos = 0;
                return true;
            }
            return false;
        }

        public Integer nextElement() {
            int slot = this.day * 288 + TimeLocation.this.iStartSlot + this.pos;
            this.hasNext = this.nextSlot();
            return slot;
        }
    }

    private class DaysEnum
    extends StartSlotsEnum {
        private DaysEnum() {
        }

        public Integer nextElement() {
            int ret = this.day;
            this.hasNext = this.nextDay();
            return ret;
        }
    }

    private class StartSlotsEnum
    implements IntEnumeration {
        int day = -1;
        boolean hasNext = this.nextDay();

        private StartSlotsEnum() {
        }

        boolean nextDay() {
            do {
                ++this.day;
                if (this.day < Constants.DAY_CODES.length) continue;
                return false;
            } while ((Constants.DAY_CODES[this.day] & TimeLocation.this.iDayCode) == 0);
            return true;
        }

        public boolean hasMoreElements() {
            return this.hasNext;
        }

        public Integer nextElement() {
            int slot = this.day * 288 + TimeLocation.this.iStartSlot;
            this.hasNext = this.nextDay();
            return slot;
        }

        @Deprecated
        public Integer nextInt() {
            return this.nextElement();
        }
    }
}

