/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.sf.cpsolver.coursett.model.Configuration;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.ifs.util.Progress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialSectioning {
    protected Collection<Student> iStudents = null;
    protected Group[] iGroups = null;
    protected Long iOfferingId = null;
    protected Progress iProgress = null;

    public InitialSectioning(Progress progress, Long offeringId, Collection<?> lectureOrConfigurations, Collection<Student> students) {
        this.iOfferingId = offeringId;
        this.iStudents = new HashSet<Student>(students);
        this.iProgress = progress;
        this.iGroups = new Group[lectureOrConfigurations.size()];
        int idx = 0;
        double total = 0.0;
        for (Object lectureOrConfiguration : lectureOrConfigurations) {
            if (lectureOrConfiguration instanceof Lecture) {
                Lecture lecture = (Lecture)lectureOrConfiguration;
                this.iGroups[idx] = new Group(lecture);
            } else {
                Configuration configuration = (Configuration)lectureOrConfiguration;
                this.iGroups[idx] = new Group(configuration);
            }
            total += this.iGroups[idx].getMaxSize();
            ++idx;
        }
        this.tweakSizes(total);
        progress.trace("Initial sectioning:");
        progress.trace("  going to section " + this.iStudents.size() + " into " + total + " seats");
        for (idx = 0; idx < this.iGroups.length; ++idx) {
            progress.trace("    " + (idx + 1) + ". group can accomodate <" + this.iGroups[idx].getMinSize() + "," + this.iGroups[idx].getMaxSize() + "> students");
        }
    }

    protected void tweakSizes(double total) {
        if (total == 0.0) {
            for (int idx = 0; idx < this.iGroups.length; ++idx) {
                this.iGroups[idx].setMaxSize(1.0);
                total += 1.0;
            }
        }
        double studentsWeight = 0.0;
        for (Student s : this.iStudents) {
            studentsWeight += s.getOfferingWeight(this.iOfferingId);
        }
        double factor = studentsWeight / total;
        for (int idx = 0; idx < this.iGroups.length; ++idx) {
            this.iGroups[idx].setMaxSize(factor * this.iGroups[idx].getMaxSize());
            this.iGroups[idx].setMinSize(Math.min(this.iGroups[idx].getMinSize(), 0.9 * this.iGroups[idx].getMaxSize()));
        }
    }

    public void addStudent(Student student) {
        this.iStudents.add(student);
    }

    private boolean moveAwayOneStudent(Group group) {
        Group newGroup = null;
        Student movingStudent = null;
        double curDist = 0.0;
        double newDist = 0.0;
        block0: for (Student student : group.getStudents()) {
            if (group.isEnrolled(student)) continue;
            double cd = group.getDistance(student);
            for (int x = 0; x < this.iGroups.length; ++x) {
                if (group.equals(this.iGroups[x]) || this.iGroups[x].size() > this.iGroups[x].getMaxSize() || !this.iGroups[x].canEnroll(student)) continue;
                double nd = this.iGroups[x].getDistance(student);
                if (newGroup != null && !(newDist - curDist < nd - cd)) continue;
                newGroup = this.iGroups[x];
                movingStudent = student;
                newDist = nd;
                curDist = cd;
                if (newDist - curDist < 0.01) continue block0;
            }
        }
        if (newGroup != null) {
            group.removeStudent(movingStudent);
            newGroup.addStudent(movingStudent);
            return true;
        }
        return false;
    }

    public boolean moveIntoOneStudent(Group group) {
        Group oldGroup = null;
        Student movingStudent = null;
        double curDist = 0.0;
        double newDist = 0.0;
        block0: for (int x = 0; x < this.iGroups.length; ++x) {
            if (group.equals(this.iGroups[x]) || this.iGroups[x].size() <= this.iGroups[x].getMinSize()) continue;
            for (Student student : this.iGroups[x].getStudents()) {
                if (!group.canEnroll(student) || this.iGroups[x].isEnrolled(student)) continue;
                double cd = this.iGroups[x].getDistance(student);
                double nd = group.getDistance(student);
                if (oldGroup != null && !(newDist - curDist < nd - cd)) continue;
                oldGroup = this.iGroups[x];
                movingStudent = student;
                newDist = nd;
                curDist = cd;
                if (!(newDist - curDist < 0.01)) continue;
                continue block0;
            }
        }
        if (oldGroup != null) {
            oldGroup.removeStudent(movingStudent);
            group.addStudent(movingStudent);
            return true;
        }
        return false;
    }

    public Group[] getGroups() {
        double minDist = 1.0 / (double)this.iGroups.length;
        Iterator<Student> i = this.iStudents.iterator();
        while (i.hasNext()) {
            Student student = i.next();
            Group group = null;
            for (int idx = 0; idx < this.iGroups.length; ++idx) {
                if (!this.iGroups[idx].isEnrolled(student)) continue;
                group = this.iGroups[idx];
                break;
            }
            if (group == null) continue;
            group.addStudent(student);
            i.remove();
        }
        for (Student student : this.iStudents) {
            double d;
            int idx;
            double studentWeight = student.getOfferingWeight(this.iOfferingId);
            Group group = null;
            double dist = 0.0;
            for (int idx2 = 0; idx2 < this.iGroups.length; ++idx2) {
                Group g = this.iGroups[idx2];
                if (!g.canEnroll(student) || g.size() + studentWeight > g.getMaxSize()) continue;
                double d2 = g.getDistance(student);
                if (group != null && !(d2 < dist)) continue;
                group = g;
                dist = d2;
                if (d2 < minDist) break;
            }
            if (group != null) {
                group.addStudent(student);
                continue;
            }
            int excess = 0;
            for (idx = 0; idx < this.iGroups.length; ++idx) {
                Group g = this.iGroups[idx];
                if (!g.canEnroll(student)) continue;
                d = g.getDistance(student);
                int ex = (int)Math.round(g.size() + studentWeight - g.getMaxSize());
                if (group != null && ex >= excess && (ex != excess || !(d < dist))) continue;
                group = g;
                dist = d;
                excess = ex;
            }
            if (group != null) {
                group.addStudent(student);
                continue;
            }
            for (idx = 0; idx < this.iGroups.length; ++idx) {
                Group g = this.iGroups[idx];
                d = g.getDistance(student);
                if (group != null && !(d < dist)) continue;
                group = g;
                dist = d;
            }
            this.iProgress.debug("Unable to find a valid section for student " + student.getId() + ", enrolling to " + (group.getLecture() != null ? group.getLecture().getName() : group.getConfiguration().getConfigId().toString()));
            group.addStudent(student);
        }
        for (int idx = 0; idx < this.iGroups.length; ++idx) {
            Group group = this.iGroups[idx];
            while (group.size() > group.getMaxSize() && this.moveAwayOneStudent(group)) {
            }
            while (group.size() > group.getMaxSize()) {
                Group newGroup = null;
                Student movingStudent = null;
                for (Student student : group.getStudents()) {
                    if (group.isEnrolled(student)) continue;
                    for (int x = 0; x < this.iGroups.length; ++x) {
                        if (idx == x || !this.iGroups[x].canEnroll(student)) continue;
                        while (this.iGroups[x].size() + student.getOfferingWeight(this.iOfferingId) > this.iGroups[x].getMaxSize() && this.moveAwayOneStudent(this.iGroups[x])) {
                        }
                        if (this.iGroups[x].size() + student.getOfferingWeight(this.iOfferingId) > this.iGroups[x].getMaxSize()) continue;
                        newGroup = this.iGroups[x];
                        movingStudent = student;
                        break;
                    }
                    if (newGroup == null) continue;
                    break;
                }
                if (newGroup == null) break;
                group.removeStudent(movingStudent);
                newGroup.addStudent(movingStudent);
            }
            while (group.size() < group.getMinSize() && this.moveIntoOneStudent(group)) {
            }
        }
        return this.iGroups;
    }

    public static void initialSectioningCfg(Progress p, Long offeringId, String courseName, Collection<Student> students, List<Configuration> configurations) {
        if (students == null || students.isEmpty()) {
            return;
        }
        if (configurations == null || configurations.isEmpty()) {
            return;
        }
        if (configurations.size() == 1) {
            Configuration cfg = configurations.get(0);
            for (Student st : students) {
                st.addConfiguration(cfg);
            }
            for (Long subpartId : cfg.getTopSubpartIds()) {
                InitialSectioning.initialSectioning(p, offeringId, courseName, students, cfg.getTopLectures(subpartId));
            }
        } else {
            p.trace("sectioning " + students.size() + " students of course " + courseName + " into " + configurations.size() + " configurations");
            InitialSectioning sect = new InitialSectioning(p, offeringId, configurations, students);
            Group[] studentsPerSection = sect.getGroups();
            for (int i = 0; i < configurations.size(); ++i) {
                Group group = studentsPerSection[i];
                p.trace(i + 1 + ". configuration got " + group.getStudents().size() + " students (weighted=" + group.size() + ", cfgLimit=" + group.getConfiguration().getLimit() + ")");
                for (Student st : group.getStudents()) {
                    st.addConfiguration(group.getConfiguration());
                }
                for (Long subpartId : group.getConfiguration().getTopSubpartIds()) {
                    InitialSectioning.initialSectioning(p, offeringId, courseName, group.getStudents(), group.getConfiguration().getTopLectures(subpartId));
                }
            }
        }
    }

    private static String getClassLabel(Lecture lecture) {
        return "<A href='classDetail.do?cid=" + lecture.getClassId() + "'>" + lecture.getName() + "</A>";
    }

    private static void initialSectioning(Progress p, Long offeringId, String parentName, Collection<Student> students, Collection<Lecture> lectures) {
        block12: {
            block11: {
                if (lectures == null || lectures.isEmpty()) {
                    return;
                }
                if (students == null || students.isEmpty()) {
                    return;
                }
                for (Lecture lecture : lectures) {
                    if (lecture.classLimit() != 0 || lecture.isCommitted()) continue;
                    p.warn("Class " + InitialSectioning.getClassLabel(lecture) + " has zero class limit.");
                }
                p.trace("sectioning " + students.size() + " students of course " + parentName + " into " + lectures.size() + " sections");
                if (lectures.size() != 1) break block11;
                Lecture lect = lectures.iterator().next();
                for (Student st : students) {
                    if (!st.canEnroll(lect)) {
                        p.info("Unable to enroll student " + st.getId() + " in class " + InitialSectioning.getClassLabel(lect));
                    }
                    lect.addStudent(st);
                    st.addLecture(lect);
                }
                if (!lect.hasAnyChildren()) break block12;
                for (Long subpartId : lect.getChildrenSubpartIds()) {
                    List<Lecture> children = lect.getChildren(subpartId);
                    InitialSectioning.initialSectioning(p, offeringId, lect.getName(), students, children);
                }
                break block12;
            }
            InitialSectioning sect = new InitialSectioning(p, offeringId, lectures, students);
            Group[] groupArray = sect.getGroups();
            for (int i = 0; i < groupArray.length; ++i) {
                Group group = groupArray[i];
                Lecture lect = group.getLecture();
                if (group.getStudents().isEmpty()) {
                    p.trace("Lecture " + InitialSectioning.getClassLabel(lect) + " got no students (cl=" + lect.classLimit() + ")");
                    continue;
                }
                p.trace("Lecture " + InitialSectioning.getClassLabel(lect) + " got " + group.getStudents().size() + " students (weighted=" + group.size() + ", classLimit=" + lect.classLimit() + ")");
                List<Student> studentsThisSection = group.getStudents();
                for (Student st : studentsThisSection) {
                    if (!st.canEnroll(lect)) {
                        p.info("Unable to enroll student " + st.getId() + " in class " + InitialSectioning.getClassLabel(lect));
                    }
                    lect.addStudent(st);
                    st.addLecture(lect);
                }
                if (!lect.hasAnyChildren()) continue;
                for (Long subpartId : lect.getChildrenSubpartIds()) {
                    List<Lecture> children = lect.getChildren(subpartId);
                    InitialSectioning.initialSectioning(p, offeringId, lect.getName(), studentsThisSection, children);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Group {
        private ArrayList<Student> iStudents = new ArrayList();
        private Lecture iLecture = null;
        private Configuration iConfiguration = null;
        private Double iDist = null;
        private double iMinSize = 0.0;
        private double iMaxSize = 0.0;
        private HashMap<Student, Double> iDistCache = new HashMap();
        private double iSize = 0.0;

        public Group(Lecture lecture) {
            this.iLecture = lecture;
            this.iMinSize = lecture.minClassLimit();
            this.iMaxSize = lecture.maxAchievableClassLimit();
        }

        public Group(Configuration configuration) {
            this.iConfiguration = configuration;
            this.iMinSize = this.iMaxSize = (double)this.iConfiguration.getLimit();
        }

        public Configuration getConfiguration() {
            return this.iConfiguration;
        }

        public Lecture getLecture() {
            return this.iLecture;
        }

        public double getMinSize() {
            return this.iMinSize;
        }

        public double getMaxSize() {
            return this.iMaxSize;
        }

        public void setMinSize(double minSize) {
            this.iMinSize = minSize;
        }

        public void setMaxSize(double maxSize) {
            this.iMaxSize = maxSize;
        }

        public double getDistance() {
            if (this.iDist == null) {
                double dist = 0.0;
                double prob = 10.0 / (double)this.iStudents.size();
                int cnt = 0;
                for (Student s1 : this.iStudents) {
                    if (!(Math.random() < prob)) continue;
                    for (Student s2 : this.iStudents) {
                        if (s1.getId().compareTo(s2.getId()) <= 0 || !(Math.random() < prob)) continue;
                        dist += s1.getDistance(s2);
                        ++cnt;
                    }
                }
                this.iDist = new Double(dist / (double)cnt);
            }
            return this.iDist;
        }

        public double getDistance(Student student) {
            Double cachedDist = this.iDistCache.get(student);
            if (cachedDist != null) {
                return cachedDist;
            }
            double dist = 0.0;
            double prob = 10.0 / (double)this.iStudents.size();
            int cnt = 0;
            for (Student s : this.iStudents) {
                if (!(prob >= 1.0) && !(Math.random() < prob)) continue;
                dist += s.getDistance(student);
                ++cnt;
            }
            this.iDistCache.put(student, new Double(dist / (double)cnt));
            return dist / (double)cnt;
        }

        public void addStudent(Student student) {
            this.iStudents.add(student);
            this.iSize += student.getOfferingWeight(InitialSectioning.this.iOfferingId);
            this.iDist = null;
            this.iDistCache.clear();
        }

        public void removeStudent(Student student) {
            this.iStudents.remove(student);
            this.iSize -= student.getOfferingWeight(InitialSectioning.this.iOfferingId);
            this.iDist = null;
            this.iDistCache.clear();
        }

        public List<Student> getStudents() {
            return this.iStudents;
        }

        public double size() {
            return this.iSize;
        }

        public String toString() {
            return "{" + this.size() + "-" + this.getDistance() + "/" + this.getStudents() + "}";
        }

        public boolean canEnroll(Student student) {
            if (this.getLecture() != null) {
                return student.canEnroll(this.getLecture());
            }
            for (Long subpartId : this.getConfiguration().getTopSubpartIds()) {
                boolean canEnrollThisSubpart = false;
                for (Lecture lecture : this.getConfiguration().getTopLectures(subpartId)) {
                    if (!student.canEnroll(lecture)) continue;
                    canEnrollThisSubpart = true;
                    break;
                }
                if (canEnrollThisSubpart) continue;
                return false;
            }
            return true;
        }

        public boolean isEnrolled(Student student) {
            if (this.getLecture() != null) {
                return student.getLectures().contains(this.getLecture());
            }
            for (Lecture lect : student.getLectures()) {
                if (!lect.getConfiguration().equals(this.getConfiguration())) continue;
                return true;
            }
            return false;
        }
    }
}

