/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.JenrlConstraint;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.model.Configuration;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinalSectioning
implements Runnable {
    private TimetableModel iModel = null;
    public static double sEps = 1.0E-4;
    private boolean iWeighStudents = false;

    public FinalSectioning(TimetableModel model) {
        this.iModel = model;
        this.iWeighStudents = model.getProperties().getPropertyBoolean("General.WeightStudents", this.iWeighStudents);
    }

    @Override
    public void run() {
        Progress p = Progress.getInstance(this.iModel);
        p.setStatus("Student Sectioning...");
        AbstractCollection variables = new ArrayList(this.iModel.variables());
        if (this.iModel.hasConstantVariables()) {
            for (Lecture lecture : this.iModel.constantVariables()) {
                variables.add(lecture);
            }
        }
        while (!variables.isEmpty()) {
            p.setPhase("moving students ...", variables.size());
            HashSet<Lecture> lecturesToRecompute = new HashSet<Lecture>(variables.size());
            for (Lecture lecture : variables) {
                Configuration cfg;
                if (lecture.getParent() == null && (cfg = lecture.getConfiguration()) != null && cfg.getAltConfigurations().size() > 1) {
                    this.findAndPerformMoves(cfg, lecturesToRecompute);
                }
                this.findAndPerformMoves(lecture, lecturesToRecompute);
                p.incProgress();
            }
            variables = lecturesToRecompute;
        }
    }

    public void resection(Lecture lecture, boolean recursive, boolean configAsWell) {
        Configuration cfg;
        HashSet<Lecture> variables = new HashSet<Lecture>();
        this.findAndPerformMoves(lecture, variables);
        if (configAsWell && (cfg = lecture.getConfiguration()) != null && cfg.getAltConfigurations().size() > 1) {
            this.findAndPerformMoves(cfg, variables);
        }
        if (recursive) {
            while (!variables.isEmpty()) {
                HashSet<Lecture> lecturesToRecompute = new HashSet<Lecture>();
                for (Lecture l : variables) {
                    Configuration cfg2;
                    if (configAsWell && l.getParent() == null && (cfg2 = l.getConfiguration()) != null && cfg2.getAltConfigurations().size() > 1) {
                        this.findAndPerformMoves(cfg2, lecturesToRecompute);
                    }
                    this.findAndPerformMoves(l, lecturesToRecompute);
                }
                variables = lecturesToRecompute;
            }
        }
    }

    public void findAndPerformMoves(Lecture lecture, HashSet<Lecture> lecturesToRecompute) {
        Set<Student> conflictStudents;
        Move m;
        if (lecture.sameSubpartLectures() == null || lecture.getAssignment() == null) {
            return;
        }
        if (lecture.getClassLimitConstraint() != null) {
            while (lecture.nrWeightedStudents() > sEps + (double)lecture.minClassLimit() && (m = this.findAwayMove(lecture)) != null) {
                if (!m.perform()) continue;
                lecturesToRecompute.add(m.secondLecture());
            }
        } else if (!this.iWeighStudents) {
            while ((m = this.findAwayMove(lecture)) != null) {
                if (!m.perform()) continue;
                lecturesToRecompute.add(m.secondLecture());
            }
        }
        if ((conflictStudents = lecture.conflictStudents()) == null || conflictStudents.isEmpty()) {
            return;
        }
        if (lecture.sameSubpartLectures().size() > 1) {
            for (Student student : conflictStudents) {
                Move m2;
                if (lecture.getAssignment() == null || (m2 = this.findMove(lecture, student)) == null || !m2.perform()) continue;
                lecturesToRecompute.add(m2.secondLecture());
            }
        } else {
            for (Student student : conflictStudents) {
                for (Lecture anotherLecture : lecture.conflictLectures(student)) {
                    if (anotherLecture.equals(lecture) || anotherLecture.sameSubpartLectures() == null || anotherLecture.getAssignment() == null || anotherLecture.sameSubpartLectures().size() <= 1) continue;
                    lecturesToRecompute.add(anotherLecture);
                }
            }
        }
    }

    public void findAndPerformMoves(Configuration configuration, HashSet<Lecture> lecturesToRecompute) {
        for (Student student : configuration.students()) {
            MoveBetweenCfgs m;
            if (!configuration.hasConflict(student) || (m = this.findMove(configuration, student)) == null || !m.perform()) continue;
            lecturesToRecompute.addAll(m.secondLectures());
        }
    }

    public Move findAwayMove(Lecture lecture) {
        ArrayList<Move> bestMoves = null;
        double bestDelta = 0.0;
        for (Student student : lecture.students()) {
            if (!student.canUnenroll(lecture)) continue;
            for (Lecture sameLecture : lecture.sameSubpartLectures()) {
                Move m;
                double studentWeight = student.getOfferingWeight(sameLecture.getConfiguration());
                if (!student.canEnroll(sameLecture) || sameLecture.equals(lecture) || sameLecture.getAssignment() == null || !(sameLecture.nrWeightedStudents() + studentWeight <= sEps + (double)sameLecture.classLimit()) || (m = this.createMove(lecture, student, sameLecture, null)) == null || m.isTabu()) continue;
                double delta = m.getDelta();
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList<Move>();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                    continue;
                }
                if (delta != bestDelta) continue;
                if (bestMoves == null) {
                    bestMoves = new ArrayList();
                }
                bestMoves.add(m);
            }
        }
        if (bestDelta < -sEps && bestMoves != null) {
            Move m = (Move)ToolBox.random(bestMoves);
            return m;
        }
        return null;
    }

    public Move findMove(Lecture lecture, Student student) {
        if (!student.canUnenroll(lecture)) {
            return null;
        }
        double bestDelta = 0.0;
        ArrayList<Move> bestMoves = null;
        double studentWeight = student.getOfferingWeight(lecture.getConfiguration());
        for (Lecture sameLecture : lecture.sameSubpartLectures()) {
            if (!student.canEnroll(sameLecture) || sameLecture.equals(lecture) || sameLecture.getAssignment() == null) continue;
            if (sameLecture.nrWeightedStudents() + studentWeight <= sEps + (double)sameLecture.classLimit()) {
                Move m = this.createMove(lecture, student, sameLecture, null);
                if (m == null || m.isTabu()) continue;
                double delta = m.getDelta();
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList<Move>();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                } else if (delta == bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    }
                    bestMoves.add(m);
                }
            }
            for (Student anotherStudent : sameLecture.students()) {
                double anotherStudentWeight;
                if (!anotherStudent.canUnenroll(sameLecture) || !anotherStudent.canEnroll(lecture) || (anotherStudentWeight = anotherStudent.getOfferingWeight(lecture.getConfiguration())) != studentWeight && (sameLecture.nrWeightedStudents() - anotherStudentWeight + studentWeight > sEps + (double)sameLecture.classLimit() || lecture.nrWeightedStudents() - studentWeight + anotherStudentWeight > sEps + (double)lecture.classLimit())) continue;
                if (bestDelta < -sEps && bestMoves != null && bestMoves.size() > 10) break;
                Move m = this.createMove(lecture, student, sameLecture, anotherStudent);
                if (m == null || m.isTabu()) continue;
                double delta = m.getDelta();
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                    continue;
                }
                if (delta != bestDelta) continue;
                if (bestMoves == null) {
                    bestMoves = new ArrayList();
                }
                bestMoves.add(m);
            }
            if (!(Math.abs(bestDelta) < sEps) || bestMoves == null || bestMoves.size() <= 10) continue;
            break;
        }
        if (bestDelta < -sEps && bestMoves != null) {
            return (Move)ToolBox.random(bestMoves);
        }
        return null;
    }

    public MoveBetweenCfgs findMove(Configuration config, Student student) {
        double bestDelta = 0.0;
        ArrayList<MoveBetweenCfgs> bestMoves = null;
        for (Configuration altConfig : config.getAltConfigurations()) {
            if (altConfig.equals(config)) continue;
            MoveBetweenCfgs m = this.createMove(config, student, altConfig, null);
            if (m != null && !m.isTabu()) {
                double delta = m.getDelta();
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList<MoveBetweenCfgs>();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                } else if (delta == bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    }
                    bestMoves.add(m);
                }
            }
            for (Student anotherStudent : altConfig.students()) {
                if (bestDelta < -sEps && bestMoves != null && bestMoves.size() > 10) break;
                m = this.createMove(config, student, altConfig, anotherStudent);
                if (m == null || m.isTabu()) continue;
                double delta = m.getDelta();
                if (delta < bestDelta) {
                    if (bestMoves == null) {
                        bestMoves = new ArrayList();
                    } else {
                        bestMoves.clear();
                    }
                    bestMoves.add(m);
                    bestDelta = delta;
                    continue;
                }
                if (delta != bestDelta) continue;
                if (bestMoves == null) {
                    bestMoves = new ArrayList();
                }
                bestMoves.add(m);
            }
            if (!(Math.abs(bestDelta) < sEps) || bestMoves == null || bestMoves.size() <= 10) continue;
            break;
        }
        if (bestDelta < -sEps && bestMoves != null) {
            return (MoveBetweenCfgs)ToolBox.random(bestMoves);
        }
        return null;
    }

    public Move createMove(Lecture firstLecture, Student firstStudent, Lecture secondLecture, Student secondStudent) {
        return this.createMove(firstLecture, firstStudent, secondLecture, secondStudent, null);
    }

    public Move createMove(Lecture firstLecture, Student firstStudent, Lecture secondLecture, Student secondStudent, Move parentMove) {
        Move move;
        block29: {
            Lecture firstChildLecture;
            if (!firstStudent.canUnenroll(firstLecture) || !firstStudent.canEnroll(secondLecture)) {
                return null;
            }
            if (!(secondStudent == null || secondStudent.canUnenroll(secondLecture) && secondStudent.canEnroll(firstLecture))) {
                return null;
            }
            if (firstLecture.getParent() != null && secondLecture.getParent() == null) {
                return null;
            }
            if (firstLecture.getParent() == null && secondLecture.getParent() != null) {
                return null;
            }
            move = new Move(firstLecture, firstStudent, secondLecture, secondStudent);
            if (parentMove == null) {
                Lecture l1 = firstLecture;
                Lecture l2 = secondLecture;
                while (l1.getParent() != null && l2.getParent() != null && !l1.getParent().equals(l2.getParent())) {
                    double w2;
                    Lecture p1 = l1.getParent();
                    Lecture p2 = l2.getParent();
                    if (p1.getAssignment() == null || p2.getAssignment() == null) {
                        return null;
                    }
                    double w1 = firstStudent.getOfferingWeight(p1.getConfiguration());
                    double d = w2 = secondStudent == null ? 0.0 : secondStudent.getOfferingWeight(p2.getConfiguration());
                    if (w1 != w2) {
                        if (p1.nrWeightedStudents() - w1 + w2 > sEps + (double)p1.classLimit()) {
                            return null;
                        }
                        if (p2.nrWeightedStudents() - w2 + w1 > sEps + (double)p2.classLimit()) {
                            return null;
                        }
                    }
                    if (!(firstStudent.canUnenroll(p2) && firstStudent.canEnroll(p1) && (secondStudent == null || secondStudent.canUnenroll(p1) && secondStudent.canEnroll(p2)))) {
                        return null;
                    }
                    move.addChildMove(new Move(p1, firstStudent, p2, secondStudent));
                    l1 = p1;
                    l2 = p2;
                }
            }
            if (firstLecture.hasAnyChildren() != secondLecture.hasAnyChildren()) {
                return null;
            }
            if (!firstLecture.hasAnyChildren()) break block29;
            if (secondStudent != null) {
                for (Long subpartId : firstLecture.getChildrenSubpartIds()) {
                    double secondStudentWeight;
                    firstChildLecture = firstLecture.getChild(firstStudent, subpartId);
                    Lecture secondChildLecture = secondLecture.getChild(secondStudent, subpartId);
                    if (firstChildLecture == null || secondChildLecture == null) {
                        return null;
                    }
                    double firstStudentWeight = firstStudent.getOfferingWeight(firstChildLecture.getConfiguration());
                    if (firstStudentWeight != (secondStudentWeight = secondStudent.getOfferingWeight(secondChildLecture.getConfiguration()))) {
                        if (firstChildLecture.nrWeightedStudents() - firstStudentWeight + secondStudentWeight > sEps + (double)firstChildLecture.classLimit()) {
                            return null;
                        }
                        if (secondChildLecture.nrWeightedStudents() - secondStudentWeight + firstStudentWeight > sEps + (double)secondChildLecture.classLimit()) {
                            return null;
                        }
                    }
                    if (firstChildLecture.getAssignment() != null && secondChildLecture.getAssignment() != null) {
                        Move m = this.createMove(firstChildLecture, firstStudent, secondChildLecture, secondStudent, move);
                        if (m == null) {
                            return null;
                        }
                        move.addChildMove(m);
                        continue;
                    }
                    return null;
                }
            } else {
                for (Long subpartId : firstLecture.getChildrenSubpartIds()) {
                    firstChildLecture = firstLecture.getChild(firstStudent, subpartId);
                    if (firstChildLecture == null || firstChildLecture.getAssignment() == null) {
                        return null;
                    }
                    double firstStudentWeight = firstStudent.getOfferingWeight(firstChildLecture.getConfiguration());
                    List<Lecture> secondChildLectures = secondLecture.getChildren(subpartId);
                    if (secondChildLectures == null || secondChildLectures.isEmpty()) {
                        return null;
                    }
                    ArrayList<Move> bestMoves = null;
                    double bestDelta = 0.0;
                    for (Lecture secondChildLecture : secondChildLectures) {
                        Move m;
                        if (secondChildLecture.getAssignment() == null || secondChildLecture.nrWeightedStudents() + firstStudentWeight > sEps + (double)secondChildLecture.classLimit() || (m = this.createMove(firstChildLecture, firstStudent, secondChildLecture, secondStudent, move)) == null) continue;
                        double delta = m.getDelta();
                        if (bestMoves == null || delta < bestDelta) {
                            if (bestMoves == null) {
                                bestMoves = new ArrayList<Move>();
                            } else {
                                bestMoves.clear();
                            }
                            bestMoves.add(m);
                            bestDelta = delta;
                            continue;
                        }
                        if (delta != bestDelta) continue;
                        bestMoves.add(m);
                    }
                    if (bestDelta >= 0.0 || bestMoves == null) {
                        return null;
                    }
                    Move m = (Move)ToolBox.random(bestMoves);
                    move.addChildMove(m);
                }
            }
        }
        return move;
    }

    public MoveBetweenCfgs createMove(Configuration firstConfig, Student firstStudent, Configuration secondConfig, Student secondStudent) {
        MoveBetweenCfgs m = new MoveBetweenCfgs(firstConfig, firstStudent, secondConfig, secondStudent);
        for (Long subpartId : firstConfig.getTopSubpartIds()) {
            if (this.addLectures(firstStudent, secondStudent, m.firstLectures(), firstConfig.getTopLectures(subpartId))) continue;
            return null;
        }
        for (Long subpartId : secondConfig.getTopSubpartIds()) {
            if (this.addLectures(secondStudent, firstStudent, m.secondLectures(), secondConfig.getTopLectures(subpartId))) continue;
            return null;
        }
        return m;
    }

    private boolean addLectures(Student student, Student newStudent, Set<Lecture> studentLectures, Collection<Lecture> lectures) {
        Lecture lecture = null;
        if (lectures == null) {
            return false;
        }
        if (student != null) {
            for (Lecture l : lectures) {
                if (!l.students().contains(student)) continue;
                lecture = l;
                if (!student.canUnenroll(lecture)) {
                    return false;
                }
                break;
            }
        } else {
            int bestValue = 0;
            Lecture bestLecture = null;
            for (Lecture l : lectures) {
                int val = this.test(newStudent, l);
                if (val < 0 || bestLecture != null && bestValue <= val) continue;
                bestValue = val;
                bestLecture = l;
            }
            lecture = bestLecture;
        }
        if (lecture == null) {
            return false;
        }
        if (newStudent != null && !newStudent.canEnroll(lecture)) {
            return false;
        }
        studentLectures.add(lecture);
        if (lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                if (this.addLectures(student, newStudent, studentLectures, lecture.getChildren(subpartId))) continue;
                return false;
            }
        }
        return true;
    }

    public int test(Student student, Lecture lecture) {
        if (lecture.getAssignment() == null) {
            return -1;
        }
        double studentWeight = student.getOfferingWeight(lecture.getConfiguration());
        if (lecture.nrWeightedStudents() + studentWeight > sEps + (double)lecture.classLimit()) {
            return -1;
        }
        if (!student.canEnroll(lecture)) {
            return -1;
        }
        int test = 0;
        for (Lecture x : student.getLectures()) {
            if (x.getAssignment() == null || !JenrlConstraint.isInConflict((Placement)lecture.getAssignment(), (Placement)x.getAssignment(), this.iModel.getDistanceMetric())) continue;
            ++test;
        }
        test += student.countConflictPlacements((Placement)lecture.getAssignment());
        if (lecture.getChildrenSubpartIds() != null) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                int bestTest = -1;
                for (Lecture child : lecture.getChildren(subpartId)) {
                    int t = this.test(student, child);
                    if (t < 0 || bestTest >= 0 && bestTest <= t) continue;
                    bestTest = t;
                }
                if (bestTest < 0) {
                    return -1;
                }
                test += bestTest;
            }
        }
        return test;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MoveBetweenCfgs {
        Configuration iFirstConfig = null;
        Set<Lecture> iFirstLectures = new HashSet<Lecture>();
        Student iFirstStudent = null;
        Configuration iSecondConfig = null;
        Set<Lecture> iSecondLectures = new HashSet<Lecture>();
        Student iSecondStudent = null;

        public MoveBetweenCfgs(Configuration firstConfig, Student firstStudent, Configuration secondConfig, Student secondStudent) {
            this.iFirstConfig = firstConfig;
            this.iFirstStudent = firstStudent;
            this.iSecondConfig = secondConfig;
            this.iSecondStudent = secondStudent;
        }

        public Configuration firstConfiguration() {
            return this.iFirstConfig;
        }

        public Student firstStudent() {
            return this.iFirstStudent;
        }

        public Set<Lecture> firstLectures() {
            return this.iFirstLectures;
        }

        public Configuration secondConfiguration() {
            return this.iSecondConfig;
        }

        public Student secondStudent() {
            return this.iSecondStudent;
        }

        public Set<Lecture> secondLectures() {
            return this.iSecondLectures;
        }

        public boolean perform() {
            int k;
            Object[] vars;
            JenrlConstraint jenrl;
            double conflicts = this.firstLectures().iterator().next().getModel().getCriterion(StudentConflict.class).getValue();
            this.firstStudent().removeConfiguration(this.firstConfiguration());
            this.firstStudent().addConfiguration(this.secondConfiguration());
            for (Lecture lecture : this.firstStudent().getLectures()) {
                for (Lecture firstLecture : this.firstLectures()) {
                    if (firstLecture.equals(lecture) || this.firstLectures().contains(lecture) && firstLecture.getClassId().compareTo(lecture.getClassId()) > 0 || (jenrl = firstLecture.jenrlConstraint(lecture)) == null) continue;
                    jenrl.decJenrl(this.firstStudent());
                    if (jenrl.getNrStudents() != 0) continue;
                    vars = jenrl.variables().toArray();
                    for (k = 0; k < vars.length; ++k) {
                        jenrl.removeVariable((Lecture)vars[k]);
                    }
                    FinalSectioning.this.iModel.removeConstraint(jenrl);
                }
            }
            if (this.secondStudent() != null) {
                this.secondStudent().removeConfiguration(this.secondConfiguration());
                this.secondStudent().addConfiguration(this.firstConfiguration());
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    for (Lecture secondLecture : this.secondLectures()) {
                        if (secondLecture.equals(lecture) || this.secondLectures().contains(lecture) && secondLecture.getClassId().compareTo(lecture.getClassId()) > 0 || (jenrl = secondLecture.jenrlConstraint(lecture)) == null) continue;
                        jenrl.decJenrl(this.secondStudent());
                        if (jenrl.getNrStudents() != 0) continue;
                        vars = jenrl.variables().toArray();
                        for (k = 0; k < vars.length; ++k) {
                            jenrl.removeVariable((Lecture)vars[k]);
                        }
                        FinalSectioning.this.iModel.removeConstraint(jenrl);
                    }
                }
            }
            for (Lecture firstLecture : this.firstLectures()) {
                firstLecture.removeStudent(this.firstStudent());
                this.firstStudent().removeLecture(firstLecture);
                if (this.secondStudent() == null) continue;
                firstLecture.addStudent(this.secondStudent());
                this.secondStudent().addLecture(firstLecture);
            }
            for (Lecture secondLecture : this.secondLectures()) {
                secondLecture.addStudent(this.firstStudent());
                this.firstStudent().addLecture(secondLecture);
                if (this.secondStudent() == null) continue;
                secondLecture.removeStudent(this.secondStudent());
                this.secondStudent().removeLecture(secondLecture);
            }
            for (Lecture lecture : this.firstStudent().getLectures()) {
                for (Lecture secondLecture : this.secondLectures()) {
                    if (secondLecture.equals(lecture) || this.secondLectures().contains(lecture) && secondLecture.getClassId().compareTo(lecture.getClassId()) > 0) continue;
                    jenrl = secondLecture.jenrlConstraint(lecture);
                    if (jenrl == null) {
                        jenrl = new JenrlConstraint();
                        FinalSectioning.this.iModel.addConstraint(jenrl);
                        jenrl.addVariable(secondLecture);
                        jenrl.addVariable(lecture);
                    }
                    jenrl.incJenrl(this.firstStudent());
                }
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    for (Lecture firstLecture : this.firstLectures()) {
                        if (firstLecture.equals(lecture) || this.firstLectures().contains(lecture) && firstLecture.getClassId().compareTo(lecture.getClassId()) > 0) continue;
                        jenrl = firstLecture.jenrlConstraint(lecture);
                        if (jenrl == null) {
                            jenrl = new JenrlConstraint();
                            FinalSectioning.this.iModel.addConstraint(jenrl);
                            jenrl.addVariable(firstLecture);
                            jenrl.addVariable(lecture);
                        }
                        jenrl.incJenrl(this.secondStudent());
                    }
                }
            }
            return this.firstLectures().iterator().next().getModel().getCriterion(StudentConflict.class).getValue() < conflicts;
        }

        public double getDelta() {
            JenrlConstraint jenrl;
            double delta = 0.0;
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.getAssignment() == null) continue;
                for (Lecture firstLecture : this.firstLectures()) {
                    if (firstLecture.getAssignment() == null || firstLecture.equals(lecture) || (jenrl = firstLecture.jenrlConstraint(lecture)) == null || !jenrl.isInConflict()) continue;
                    delta -= jenrl.getJenrlWeight(this.firstStudent());
                }
                for (Lecture secondLecture : this.secondLectures()) {
                    if (secondLecture.getAssignment() == null || secondLecture.equals(lecture)) continue;
                    jenrl = secondLecture.jenrlConstraint(lecture);
                    if (jenrl != null) {
                        if (!jenrl.isInConflict()) continue;
                        delta += jenrl.getJenrlWeight(this.firstStudent());
                        continue;
                    }
                    if (!JenrlConstraint.isInConflict((Placement)secondLecture.getAssignment(), (Placement)lecture.getAssignment(), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                    delta += this.firstStudent().getJenrlWeight(secondLecture, lecture);
                }
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.getAssignment() == null) continue;
                    for (Lecture secondLecture : this.secondLectures()) {
                        if (secondLecture.getAssignment() == null || secondLecture.equals(lecture) || (jenrl = secondLecture.jenrlConstraint(lecture)) == null || !jenrl.isInConflict()) continue;
                        delta -= jenrl.getJenrlWeight(this.secondStudent());
                    }
                    for (Lecture firstLecture : this.firstLectures()) {
                        if (firstLecture.getAssignment() == null || firstLecture.equals(lecture)) continue;
                        jenrl = firstLecture.jenrlConstraint(lecture);
                        if (jenrl != null) {
                            if (!jenrl.isInConflict()) continue;
                            delta += jenrl.getJenrlWeight(this.secondStudent());
                            continue;
                        }
                        if (!JenrlConstraint.isInConflict((Placement)firstLecture.getAssignment(), (Placement)lecture.getAssignment(), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                        delta += this.secondStudent().getJenrlWeight(firstLecture, lecture);
                    }
                }
            }
            for (Lecture firstLecture : this.firstLectures()) {
                Placement p1 = (Placement)firstLecture.getAssignment();
                if (p1 == null) continue;
                delta -= (double)this.firstStudent().countConflictPlacements(p1);
                if (this.secondStudent() == null) continue;
                delta += (double)this.secondStudent().countConflictPlacements(p1);
            }
            for (Lecture secondLecture : this.secondLectures()) {
                Placement p2 = (Placement)secondLecture.getAssignment();
                if (p2 == null) continue;
                delta += (double)this.firstStudent().countConflictPlacements(p2);
                if (this.secondStudent() == null) continue;
                delta -= (double)this.secondStudent().countConflictPlacements(p2);
            }
            return delta;
        }

        public boolean isTabu() {
            return false;
        }

        public String toString() {
            return "Move{" + this.firstStudent() + "/" + this.firstConfiguration().getConfigId() + " <-> " + this.secondStudent() + "/" + this.secondConfiguration().getConfigId() + ", d=" + this.getDelta() + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Move {
        Lecture iFirstLecture = null;
        Student iFirstStudent = null;
        Lecture iSecondLecture = null;
        Student iSecondStudent = null;
        List<Move> iChildMoves = null;

        private Move(Lecture firstLecture, Student firstStudent, Lecture secondLecture, Student secondStudent) {
            this.iFirstLecture = firstLecture;
            this.iFirstStudent = firstStudent;
            this.iSecondLecture = secondLecture;
            this.iSecondStudent = secondStudent;
        }

        public Lecture firstLecture() {
            return this.iFirstLecture;
        }

        public Student firstStudent() {
            return this.iFirstStudent;
        }

        public Lecture secondLecture() {
            return this.iSecondLecture;
        }

        public Student secondStudent() {
            return this.iSecondStudent;
        }

        public void addChildMove(Move move) {
            if (this.iChildMoves == null) {
                this.iChildMoves = new ArrayList<Move>();
            }
            this.iChildMoves.add(move);
        }

        public List<Move> getChildMoves() {
            return this.iChildMoves;
        }

        public boolean perform() {
            int j;
            Object[] vars;
            JenrlConstraint jenrl;
            double conflicts = this.firstLecture().getModel().getCriterion(StudentConflict.class).getValue();
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.equals(this.firstLecture()) || (jenrl = this.firstLecture().jenrlConstraint(lecture)) == null) continue;
                jenrl.decJenrl(this.firstStudent());
                if (jenrl.getNrStudents() != 0) continue;
                vars = jenrl.variables().toArray();
                for (j = 0; j < vars.length; ++j) {
                    jenrl.removeVariable((Lecture)vars[j]);
                }
                FinalSectioning.this.iModel.removeConstraint(jenrl);
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.equals(this.secondLecture()) || (jenrl = this.secondLecture().jenrlConstraint(lecture)) == null) continue;
                    jenrl.decJenrl(this.secondStudent());
                    if (jenrl.getNrStudents() != 0) continue;
                    vars = jenrl.variables().toArray();
                    for (j = 0; j < vars.length; ++j) {
                        jenrl.removeVariable((Lecture)vars[j]);
                    }
                    FinalSectioning.this.iModel.removeConstraint(jenrl);
                }
            }
            this.firstLecture().removeStudent(this.firstStudent());
            this.firstStudent().removeLecture(this.firstLecture());
            this.secondLecture().addStudent(this.firstStudent());
            this.firstStudent().addLecture(this.secondLecture());
            if (this.secondStudent() != null) {
                this.secondLecture().removeStudent(this.secondStudent());
                this.secondStudent().removeLecture(this.secondLecture());
                this.firstLecture().addStudent(this.secondStudent());
                this.secondStudent().addLecture(this.firstLecture());
            }
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.equals(this.secondLecture())) continue;
                jenrl = this.secondLecture().jenrlConstraint(lecture);
                if (jenrl == null) {
                    jenrl = new JenrlConstraint();
                    FinalSectioning.this.iModel.addConstraint(jenrl);
                    jenrl.addVariable(this.secondLecture());
                    jenrl.addVariable(lecture);
                }
                jenrl.incJenrl(this.firstStudent());
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.equals(this.firstLecture())) continue;
                    jenrl = this.firstLecture().jenrlConstraint(lecture);
                    if (jenrl == null) {
                        jenrl = new JenrlConstraint();
                        FinalSectioning.this.iModel.addConstraint(jenrl);
                        jenrl.addVariable(lecture);
                        jenrl.addVariable(this.firstLecture());
                    }
                    jenrl.incJenrl(this.secondStudent());
                }
            }
            if (this.getChildMoves() != null) {
                for (Move move : this.getChildMoves()) {
                    move.perform();
                }
            }
            return this.firstLecture().getModel().getCriterion(StudentConflict.class).getValue() < conflicts;
        }

        public double getDelta() {
            JenrlConstraint jenrl;
            double delta = 0.0;
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.getAssignment() == null || lecture.equals(this.firstLecture()) || (jenrl = this.firstLecture().jenrlConstraint(lecture)) == null || !jenrl.isInConflict()) continue;
                delta -= jenrl.getJenrlWeight(this.firstStudent());
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.getAssignment() == null || lecture.equals(this.secondLecture()) || (jenrl = this.secondLecture().jenrlConstraint(lecture)) == null || !jenrl.isInConflict()) continue;
                    delta -= jenrl.getJenrlWeight(this.secondStudent());
                }
            }
            for (Lecture lecture : this.firstStudent().getLectures()) {
                if (lecture.getAssignment() == null || lecture.equals(this.firstLecture())) continue;
                jenrl = this.secondLecture().jenrlConstraint(lecture);
                if (jenrl != null) {
                    if (!jenrl.isInConflict()) continue;
                    delta += jenrl.getJenrlWeight(this.firstStudent());
                    continue;
                }
                if (!JenrlConstraint.isInConflict((Placement)this.secondLecture().getAssignment(), (Placement)lecture.getAssignment(), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                delta += this.firstStudent().getJenrlWeight(this.secondLecture(), lecture);
            }
            if (this.secondStudent() != null) {
                for (Lecture lecture : this.secondStudent().getLectures()) {
                    if (lecture.getAssignment() == null || lecture.equals(this.secondLecture())) continue;
                    jenrl = this.firstLecture().jenrlConstraint(lecture);
                    if (jenrl != null) {
                        if (!jenrl.isInConflict()) continue;
                        delta += jenrl.getJenrlWeight(this.secondStudent());
                        continue;
                    }
                    if (!JenrlConstraint.isInConflict((Placement)this.firstLecture().getAssignment(), (Placement)lecture.getAssignment(), FinalSectioning.this.iModel.getDistanceMetric())) continue;
                    delta += this.secondStudent().getJenrlWeight(this.firstLecture(), lecture);
                }
            }
            Placement p1 = (Placement)this.firstLecture().getAssignment();
            Placement p2 = (Placement)this.secondLecture().getAssignment();
            delta += (double)(this.firstStudent().countConflictPlacements(p2) - this.firstStudent().countConflictPlacements(p1));
            if (this.secondStudent() != null) {
                delta += (double)(this.secondStudent().countConflictPlacements(p1) - this.secondStudent().countConflictPlacements(p2));
            }
            if (this.getChildMoves() != null) {
                for (Move move : this.getChildMoves()) {
                    delta += move.getDelta();
                }
            }
            return delta;
        }

        public boolean isTabu() {
            return false;
        }

        public String toString() {
            return "Move{" + this.firstStudent() + "/" + this.firstLecture() + " <-> " + this.secondStudent() + "/" + this.secondLecture() + ", d=" + this.getDelta() + ", ch=" + this.getChildMoves() + "}";
        }
    }
}

