/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import net.sf.cpsolver.ifs.model.Neighbour;
import net.sf.cpsolver.ifs.solution.Solution;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;
import net.sf.cpsolver.ifs.util.JProf;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NeighbourSelectionWithSuggestions
extends StandardNeighbourSelection<Lecture, Placement> {
    private double iSuggestionProbability = 0.1;
    private double iSuggestionProbabilityAllAssigned = 0.5;
    private int iSuggestionTimeout = 500;
    private int iSuggestionDepth = 4;
    private Solution<Lecture, Placement> iSolution = null;
    private SuggestionNeighbour iSuggestionNeighbour = null;
    private double iValue = 0.0;
    private int iNrAssigned = 0;
    private boolean iTimeoutReached = false;

    public NeighbourSelectionWithSuggestions(DataProperties properties) throws Exception {
        super(properties);
        this.iSuggestionProbability = properties.getPropertyDouble("Neighbour.SuggestionProbability", this.iSuggestionProbability);
        this.iSuggestionProbabilityAllAssigned = properties.getPropertyDouble("Neighbour.SuggestionProbabilityAllAssigned", this.iSuggestionProbabilityAllAssigned);
        this.iSuggestionTimeout = properties.getPropertyInt("Neighbour.SuggestionTimeout", this.iSuggestionTimeout);
        this.iSuggestionDepth = properties.getPropertyInt("Neighbour.SuggestionDepth", this.iSuggestionDepth);
    }

    public NeighbourSelectionWithSuggestions(Solver<Lecture, Placement> solver) throws Exception {
        this(solver.getProperties());
        this.init(solver);
    }

    @Override
    public void init(Solver<Lecture, Placement> solver) {
        super.init(solver);
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        Neighbour<Lecture, Placement> neighbour = null;
        if (solution.getModel().unassignedVariables().isEmpty()) {
            for (int d = this.iSuggestionDepth; d > 1; --d) {
                if (!(ToolBox.random() < Math.pow(this.iSuggestionProbabilityAllAssigned, d - 1))) continue;
                neighbour = this.selectNeighbourWithSuggestions(solution, this.selectVariable(solution), d);
                break;
            }
        } else {
            for (int d = this.iSuggestionDepth; d > 1; --d) {
                if (!(ToolBox.random() < Math.pow(this.iSuggestionProbability, d - 1))) continue;
                neighbour = this.selectNeighbourWithSuggestions(solution, this.selectVariable(solution), d);
                break;
            }
        }
        return neighbour != null ? neighbour : super.selectNeighbour(solution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Neighbour<Lecture, Placement> selectNeighbourWithSuggestions(Solution<Lecture, Placement> solution, Lecture lecture, int depth) {
        if (lecture == null) {
            return null;
        }
        this.iSolution = solution;
        this.iSuggestionNeighbour = null;
        this.iValue = solution.getModel().getTotalValue();
        this.iNrAssigned = solution.getModel().assignedVariables().size();
        this.iTimeoutReached = false;
        Solution<Lecture, Placement> solution2 = solution;
        synchronized (solution2) {
            ArrayList<Lecture> initialLectures = new ArrayList<Lecture>(1);
            initialLectures.add(lecture);
            this.backtrack(JProf.currentTimeMillis(), initialLectures, new HashMap<Lecture, Placement>(), new HashMap<Lecture, Placement>(), depth);
        }
        return this.iSuggestionNeighbour;
    }

    private boolean containsCommited(Collection<Placement> values) {
        if (((TimetableModel)this.iSolution.getModel()).hasConstantVariables()) {
            for (Placement placement : values) {
                Lecture lecture = (Lecture)placement.variable();
                if (!lecture.isCommitted()) continue;
                return true;
            }
        }
        return false;
    }

    private void backtrack(long startTime, List<Lecture> initialLectures, Map<Lecture, Placement> resolvedLectures, HashMap<Lecture, Placement> conflictsToResolve, int depth) {
        int nrUnassigned = conflictsToResolve.size();
        if ((initialLectures == null || initialLectures.isEmpty()) && nrUnassigned == 0) {
            if ((this.iSolution.getModel().assignedVariables().size() > this.iNrAssigned || this.iSolution.getModel().assignedVariables().size() == this.iNrAssigned && this.iValue > this.iSolution.getModel().getTotalValue()) && (this.iSuggestionNeighbour == null || this.iSuggestionNeighbour.compareTo(this.iSolution) >= 0)) {
                this.iSuggestionNeighbour = new SuggestionNeighbour(resolvedLectures);
            }
            return;
        }
        if (depth <= 0) {
            return;
        }
        if (this.iTimeoutReached || this.iSuggestionTimeout > 0 && JProf.currentTimeMillis() - startTime > (long)this.iSuggestionTimeout) {
            this.iTimeoutReached = true;
            return;
        }
        block0: for (Lecture lecture : initialLectures != null && !initialLectures.isEmpty() ? initialLectures : new ArrayList<Lecture>(conflictsToResolve.keySet())) {
            if (this.iTimeoutReached) break;
            if (resolvedLectures.containsKey(lecture)) continue;
            block1: for (Placement placement : lecture.values()) {
                Set<Placement> conflicts;
                if (this.iTimeoutReached) continue block0;
                if (placement.equals(lecture.getAssignment()) || placement.isHard() || nrUnassigned + (conflicts = this.iSolution.getModel().conflictValues(placement)).size() > depth || conflicts.contains(placement) || this.containsCommited(conflicts)) continue;
                for (Placement c : conflicts) {
                    if (!resolvedLectures.containsKey(c.variable())) continue;
                    continue block1;
                }
                Placement cur = (Placement)lecture.getAssignment();
                for (Placement c : conflicts) {
                    ((Lecture)c.variable()).unassign(0L);
                }
                if (cur != null) {
                    lecture.unassign(0L);
                }
                lecture.assign(0L, placement);
                for (Placement c : conflicts) {
                    conflictsToResolve.put((Lecture)c.variable(), c);
                }
                Placement resolvedConf = conflictsToResolve.remove(lecture);
                resolvedLectures.put(lecture, placement);
                this.backtrack(startTime, null, resolvedLectures, conflictsToResolve, depth - 1);
                resolvedLectures.remove(lecture);
                if (cur == null) {
                    lecture.unassign(0L);
                } else {
                    lecture.assign(0L, cur);
                }
                for (Placement p : conflicts) {
                    ((Lecture)p.variable()).assign(0L, p);
                    conflictsToResolve.remove(p.variable());
                }
                if (resolvedConf == null) continue;
                conflictsToResolve.put(lecture, resolvedConf);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SuggestionNeighbour
    extends Neighbour<Lecture, Placement> {
        private double iValue = 0.0;
        private List<Placement> iDifferentAssignments = null;

        public SuggestionNeighbour(Map<Lecture, Placement> resolvedLectures) {
            this.iValue = NeighbourSelectionWithSuggestions.this.iSolution.getModel().getTotalValue();
            this.iDifferentAssignments = new ArrayList<Placement>(resolvedLectures.values());
        }

        @Override
        public double value() {
            return this.iValue;
        }

        @Override
        public void assign(long iteration) {
            for (Placement p : this.iDifferentAssignments) {
                if (((Lecture)p.variable()).getAssignment() == null) continue;
                ((Lecture)p.variable()).unassign(iteration);
            }
            for (Placement p : this.iDifferentAssignments) {
                ((Lecture)p.variable()).assign(iteration, p);
            }
        }

        public int compareTo(Solution<Lecture, Placement> solution) {
            return Double.compare(this.iValue, NeighbourSelectionWithSuggestions.this.iSolution.getModel().getTotalValue());
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Suggestion{value=" + (this.iValue - NeighbourSelectionWithSuggestions.this.iSolution.getModel().getTotalValue()) + ": ");
            Iterator<Placement> e = this.iDifferentAssignments.iterator();
            while (e.hasNext()) {
                Placement p = e.next();
                sb.append("\n    " + ((Lecture)p.variable()).getName() + " " + p.getName() + (e.hasNext() ? "," : ""));
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

