/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import net.sf.cpsolver.coursett.constraint.JenrlConstraint;
import net.sf.cpsolver.coursett.criteria.additional.InstructorStudentConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorStudentHardConflict
extends InstructorStudentConflict {
    @Override
    public boolean isApplicable(Lecture l1, Lecture l2) {
        return super.isApplicable(l1, l2) && InstructorStudentHardConflict.oneInstructorOtherHard(l1, l2);
    }

    public static boolean oneInstructorOtherHard(Lecture l1, Lecture l2) {
        if (!InstructorStudentHardConflict.hard(l1, l2)) {
            return false;
        }
        JenrlConstraint jenrl = l1.jenrlConstraint(l2);
        if (jenrl == null) {
            return false;
        }
        for (Student student : jenrl.getInstructors()) {
            if (!l1.isSingleSection() && !student.getInstructor().variables().contains(jenrl.second()) || !l2.isSingleSection() && !student.getInstructor().variables().contains(jenrl.first())) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.InstructorHardStudentConflictWeight", 10.0 * config.getPropertyDouble("Comparator.HardStudentConflictWeight", 5.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrInstructorHardStudConfsWeight";
    }

    @Override
    public void getInfo(Map<String, String> info) {
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<Lecture> variables) {
    }
}

