/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria.additional;

import java.util.Collection;
import java.util.Map;
import net.sf.cpsolver.coursett.constraint.JenrlConstraint;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.criteria.additional.InstructorStudentHardConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorStudentConflict
extends StudentConflict {
    @Override
    protected double jointEnrollment(JenrlConstraint jenrl) {
        double ret = 0.0;
        for (Student student : jenrl.getInstructors()) {
            ret += student.getJenrlWeight((Lecture)jenrl.first(), (Lecture)jenrl.second());
        }
        return ret;
    }

    @Override
    public boolean inConflict(Placement p1, Placement p2) {
        return super.inConflict(p1, p2) && this.instructor(p1, p2);
    }

    public boolean instructor(Placement p1, Placement p2) {
        JenrlConstraint jenrl;
        JenrlConstraint jenrlConstraint = jenrl = p1 == null || p2 == null ? null : ((Lecture)p1.variable()).jenrlConstraint((Lecture)p2.variable());
        if (jenrl == null) {
            return false;
        }
        return jenrl.getNrInstructors() > 0;
    }

    @Override
    public void incJenrl(JenrlConstraint jenrl, double studentWeight, Double conflictPriority, Student student) {
        if (super.inConflict((Placement)((Lecture)jenrl.first()).getAssignment(), (Placement)((Lecture)jenrl.second()).getAssignment()) && student.getInstructor() != null && (student.getInstructor().variables().contains(jenrl.first()) || student.getInstructor().variables().contains(jenrl.second()))) {
            this.iValue += studentWeight;
        }
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.InstructorStudentConflictWeight", 10.0 * config.getPropertyDouble("Comparator.StudentConflictWeight", 1.0));
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.NrInstructorStudConfsWeight";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        super.getInfo(info);
        double conf = this.getValue();
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(InstructorStudentHardConflict.class);
            double hard = c == null ? 0.0 : c.getValue();
            info.put("Instructor student conflicts", sDoubleFormat.format(conf) + (hard > 0.0 ? " [hard: " + sDoubleFormat.format(hard) + "]" : ""));
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<Lecture> variables) {
        super.getInfo(info, variables);
        double conf = this.getValue(variables);
        if (conf > 0.0) {
            Criterion c = this.getModel().getCriterion(InstructorStudentHardConflict.class);
            double hard = c == null ? 0.0 : c.getValue(variables);
            info.put("Instructor student conflicts", sDoubleFormat.format(conf) + (hard > 0.0 ? " [hard: " + sDoubleFormat.format(hard) + "]" : ""));
        }
    }
}

