/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.List;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.constraint.RoomConstraint;
import net.sf.cpsolver.coursett.criteria.BrokenTimePatterns;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.util.DataProperties;

public class UselessHalfHours
extends BrokenTimePatterns {
    public double getWeightDefault(DataProperties config) {
        return 4.0 * config.getPropertyDouble("Comparator.UselessSlotWeight", 0.1);
    }

    public String getPlacementSelectionWeightName() {
        return "Placement.UselessSlotsWeight";
    }

    protected double penalty(RoomConstraint rc) {
        return UselessHalfHours.countUselessSlotsHalfHours(rc);
    }

    protected double penalty(RoomConstraint rc, Placement value) {
        return UselessHalfHours.countUselessSlotsHalfHours(rc, value);
    }

    private static boolean isEmpty(RoomConstraint rc, int slot, Placement placement) {
        List<Placement> assigned = rc.getResource(slot);
        return assigned.isEmpty() || placement != null && assigned.size() == 1 && ((Lecture)assigned.get(0).variable()).equals(placement.variable());
    }

    private static boolean isUselessBefore(RoomConstraint rc, int slot, Placement placement) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return !UselessHalfHours.isEmpty(rc, slot - 1, placement) && UselessHalfHours.isEmpty(rc, slot + 0, placement) && UselessHalfHours.isEmpty(rc, slot + 1, placement) && UselessHalfHours.isEmpty(rc, slot + 2, placement) && UselessHalfHours.isEmpty(rc, slot + 3, placement) && UselessHalfHours.isEmpty(rc, slot + 4, placement) && UselessHalfHours.isEmpty(rc, slot + 5, placement) && UselessHalfHours.isEmpty(rc, slot + 6, placement);
    }

    private static boolean isUselessAfter(RoomConstraint rc, int slot, Placement placement) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return UselessHalfHours.isEmpty(rc, slot - 1, placement) && UselessHalfHours.isEmpty(rc, slot + 0, placement) && UselessHalfHours.isEmpty(rc, slot + 1, placement) && UselessHalfHours.isEmpty(rc, slot + 2, placement) && UselessHalfHours.isEmpty(rc, slot + 3, placement) && UselessHalfHours.isEmpty(rc, slot + 4, placement) && UselessHalfHours.isEmpty(rc, slot + 5, placement) && !UselessHalfHours.isEmpty(rc, slot + 6, placement);
    }

    private static boolean isUseless(RoomConstraint rc, int slot, Placement placement) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return !UselessHalfHours.isEmpty(rc, slot - 1, placement) && UselessHalfHours.isEmpty(rc, slot + 0, placement) && UselessHalfHours.isEmpty(rc, slot + 1, placement) && UselessHalfHours.isEmpty(rc, slot + 2, placement) && UselessHalfHours.isEmpty(rc, slot + 3, placement) && UselessHalfHours.isEmpty(rc, slot + 4, placement) && UselessHalfHours.isEmpty(rc, slot + 5, placement) && !UselessHalfHours.isEmpty(rc, slot + 6, placement);
    }

    protected static int countUselessSlotsHalfHours(RoomConstraint rc, Placement placement) {
        int ret = 0;
        TimeLocation time = placement.getTimeLocation();
        int slot = time.getStartSlot() % 288;
        int days = time.getDayCode();
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            if ((Constants.DAY_CODES[d] & days) == 0) continue;
            if (UselessHalfHours.isUselessBefore(rc, d * 288 + slot - 6, placement)) {
                ++ret;
            }
            if (UselessHalfHours.isUselessAfter(rc, d * 288 + slot + time.getNrSlotsPerMeeting(), placement)) {
                ++ret;
            }
            if (time.getNrSlotsPerMeeting() != 6 || !UselessHalfHours.isUseless(rc, d * 288 + slot, placement)) continue;
            --ret;
        }
        return ret;
    }

    private static boolean isUseless(RoomConstraint rc, int slot) {
        int s = slot % 288;
        if (s - 1 < 0 || s + 6 >= 288) {
            return false;
        }
        return !rc.getResource(slot - 1).isEmpty() && rc.getResource(slot + 0).isEmpty() && rc.getResource(slot + 1).isEmpty() && rc.getResource(slot + 2).isEmpty() && rc.getResource(slot + 3).isEmpty() && rc.getResource(slot + 4).isEmpty() && rc.getResource(slot + 5).isEmpty() && !rc.getResource(slot + 6).isEmpty();
    }

    public static int countUselessSlotsHalfHours(RoomConstraint rc) {
        int ret = 0;
        for (int d = 0; d < Constants.NR_DAYS; ++d) {
            for (int s = 0; s < 288; ++s) {
                int slot = d * 288 + s;
                if (!UselessHalfHours.isUseless(rc, slot)) continue;
                ++ret;
            }
        }
        return ret;
    }
}

