/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.coursett.preference.PreferenceCombination;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooBigRooms
extends TimetablingCriterion {
    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.TooBigRoomWeight", 0.1);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.TooBigRoomWeight";
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = TooBigRooms.getTooBigRoomPreference(value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)TooBigRooms.getTooBigRoomPreference(conflict);
            }
        }
        return ret;
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Lecture lect : variables) {
            if (lect.getNrRooms() <= 0) continue;
            bounds[0] = bounds[0] + 4.0;
        }
        return bounds;
    }

    public static long getDiscouragedRoomSize(Placement value) {
        return Math.round(1.25 * (double)((Lecture)value.variable()).minRoomSize());
    }

    public static long getStronglyDiscouragedRoomSize(Placement value) {
        return Math.round(1.5 * (double)((Lecture)value.variable()).minRoomSize());
    }

    public static int getTooBigRoomPreference(Placement value) {
        if (value.isMultiRoom()) {
            PreferenceCombination pref = PreferenceCombination.getDefault();
            for (RoomLocation r : value.getRoomLocations()) {
                if ((long)r.getRoomSize() > TooBigRooms.getStronglyDiscouragedRoomSize(value)) {
                    pref.addPreferenceInt(4);
                    continue;
                }
                if ((long)r.getRoomSize() <= TooBigRooms.getDiscouragedRoomSize(value)) continue;
                pref.addPreferenceInt(1);
            }
            return pref.getPreferenceInt();
        }
        if ((long)value.getRoomLocation().getRoomSize() > TooBigRooms.getStronglyDiscouragedRoomSize(value)) {
            return 4;
        }
        if ((long)value.getRoomLocation().getRoomSize() > TooBigRooms.getDiscouragedRoomSize(value)) {
            return 1;
        }
        return 0;
    }
}

