/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimetablingCriterion
extends AbstractCriterion<Lecture, Placement> {
    private double[] iPlacementSelectionWeight = null;

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        if (this.getPlacementSelectionWeightName() != null) {
            this.iPlacementSelectionWeight = new double[]{0.0, 0.0, 0.0};
            for (int i = 0; i < 3; ++i) {
                this.iPlacementSelectionWeight[i] = solver.getProperties().getPropertyDouble(this.getPlacementSelectionWeightName() + (1 + i), this.getPlacementSelectionWeightDefault(i));
            }
        }
        return true;
    }

    public String getPlacementSelectionWeightName() {
        return "Placement." + this.getClass().getName().substring(1 + this.getClass().getName().lastIndexOf(46)) + "Weight";
    }

    public double getPlacementSelectionWeight(int level) {
        return this.iPlacementSelectionWeight == null ? 0.0 : this.iPlacementSelectionWeight[level];
    }

    public double getPlacementSelectionWeightDefault(int level) {
        return level <= 1 ? this.getWeight() : 0.0;
    }

    public String getAbbreviation() {
        return this.getName().replaceAll("[a-z ]", "");
    }

    public String toString() {
        double val = this.getValue();
        if (Math.abs(val) < 0.005 || this.getWeight() <= 0.01) {
            return "";
        }
        double[] bounds = this.getBounds();
        if (bounds[0] <= val && val <= bounds[1] && bounds[0] < bounds[1] && this.getName().endsWith(" Preferences")) {
            return this.getAbbreviation() + ":" + this.getPerc(val, bounds[0], bounds[1]) + "%";
        }
        if (bounds[1] <= val && val <= bounds[0] && bounds[1] < bounds[0] && this.getName().endsWith(" Preferences")) {
            return this.getAbbreviation() + ":" + this.getPercRev(val, bounds[1], bounds[0]) + "%";
        }
        if (bounds[0] != val || val != bounds[1]) {
            return this.getAbbreviation() + ":" + sDoubleFormat.format(this.getValue());
        }
        return "";
    }
}

