/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimePreferences
extends TimetablingCriterion {
    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.TimePreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.TimePreferenceWeight";
    }

    private double preference(Placement value) {
        int pref = value.getTimeLocation().getPreference();
        if (pref < -50) {
            return ((Lecture)value.variable()).getMinMaxTimePreference()[0];
        }
        if (pref > 50) {
            return ((Lecture)value.variable()).getMinMaxTimePreference()[1];
        }
        return value.getTimeLocation().getNormalizedPreference();
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        if (((Lecture)value.variable()).isCommitted()) {
            return 0.0;
        }
        double ret = ((Lecture)value.variable()).getWeight() * this.preference(value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= ((Lecture)conflict.variable()).getWeight() * this.preference(conflict);
            }
        }
        return ret;
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Lecture lect : variables) {
            if (lect.isCommitted()) continue;
            double[] p = lect.getMinMaxTimePreference();
            bounds[0] = bounds[0] + lect.getWeight() * p[0];
            bounds[1] = bounds[1] + lect.getWeight() * p[1];
        }
        return bounds;
    }
}

