/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.SpreadConstraint;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameSubpartBalancingPenalty
extends TimetablingCriterion {
    public SameSubpartBalancingPenalty() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 12.0 * config.getPropertyDouble("Comparator.SpreadPenaltyWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.SpreadPenaltyWeight";
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (SpreadConstraint sc : ((Lecture)value.variable()).getSpreadConstraints()) {
            ret += (double)sc.getPenalty(value);
        }
        return ret / 12.0;
    }

    @Override
    public double getValue() {
        return this.iValue / 12.0;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<SpreadConstraint> constraints = new HashSet<SpreadConstraint>();
        for (Lecture lect : variables) {
            for (SpreadConstraint sc : lect.getSpreadConstraints()) {
                if (!constraints.add(sc)) continue;
                ret += (double)sc.getPenalty();
            }
        }
        return ret / 12.0;
    }

    @Override
    public double[] getBounds() {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        return new double[]{0.0, 0.0};
    }
}

