/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.FlexibleConstraint;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleConstraintCriterion
extends TimetablingCriterion {
    private boolean iDebug;

    public FlexibleConstraintCriterion() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iWeight = solver.getProperties().getPropertyDouble("FlexibleConstraint.Weight", 1.0);
        this.iDebug = solver.getProperties().getPropertyBoolean("FlexibleConstraint.Debug", true);
        return true;
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.FlexibleConstrPreferenceWeight";
    }

    @Override
    public void getInfo(Map<String, String> info) {
        TimetableModel m = (TimetableModel)this.getModel();
        if (m.getFlexibleConstraints().isEmpty()) {
            return;
        }
        for (FlexibleConstraint.FlexibleConstraintType type : FlexibleConstraint.FlexibleConstraintType.values()) {
            StringBuilder debug = null;
            int violated = 0;
            int constraints = 0;
            for (FlexibleConstraint c : m.getFlexibleConstraints()) {
                if (!type.equals((Object)c.getType())) continue;
                ++constraints;
                if (c.isConsistent((Placement)null, (Placement)null)) continue;
                ++violated;
                if (!this.iDebug) continue;
                if (debug == null) {
                    debug = new StringBuilder(c.getOwner() + " (" + sDoubleFormat.format(c.getNrViolations(new HashSet<Placement>(), null)) + ")");
                    continue;
                }
                debug.append("; " + c.getOwner() + " (" + sDoubleFormat.format(c.getNrViolations(new HashSet<Placement>(), null)) + ")");
            }
            if (constraints <= 0) continue;
            info.put(type.getName() + " Constraints", this.getPerc(violated, 0.0, constraints) + "% (" + violated + ")");
            if (!this.iDebug || violated <= 0) continue;
            info.put(type.getName() + " Violations", debug.toString());
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Collection<Lecture> variables) {
        for (FlexibleConstraint.FlexibleConstraintType type : FlexibleConstraint.FlexibleConstraintType.values()) {
            HashSet<FlexibleConstraint> constraints = new HashSet<FlexibleConstraint>();
            for (Lecture lecture : variables) {
                for (FlexibleConstraint c : lecture.getFlexibleGroupConstraints()) {
                    if (!type.equals((Object)c.getType())) continue;
                    constraints.add(c);
                }
            }
            if (constraints.isEmpty()) continue;
            int violated = 0;
            StringBuilder debug = null;
            for (FlexibleConstraint c : constraints) {
                if (c.isConsistent((Placement)null, (Placement)null)) continue;
                ++violated;
                if (!this.iDebug) continue;
                if (debug == null) {
                    debug = new StringBuilder(c.getOwner());
                    continue;
                }
                debug.append("; " + c.getOwner());
            }
            info.put(type.getName() + " Constraints", this.getPerc(violated, 0.0, constraints.size()) + "% (" + violated + ")");
            if (!this.iDebug || violated <= 0) continue;
            info.put(type.getName() + " Violations", debug.toString());
        }
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        HashSet<FlexibleConstraint> flexibleConstraints = new HashSet<FlexibleConstraint>();
        for (Lecture lecture : variables) {
            flexibleConstraints.addAll(lecture.getFlexibleGroupConstraints());
        }
        int ret = 0;
        for (FlexibleConstraint gc : flexibleConstraints) {
            ret = (int)((double)ret + gc.getCurrentPreference(null, null));
        }
        return ret;
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
        assignments.put((Lecture)value.variable(), value);
        double ret = 0.0;
        for (FlexibleConstraint gc : ((Lecture)value.variable()).getFlexibleGroupConstraints()) {
            ret += gc.getCurrentPreference(conflicts, assignments);
        }
        assignments.put((Lecture)value.variable(), (Placement)null);
        for (FlexibleConstraint gc : ((Lecture)value.variable()).getFlexibleGroupConstraints()) {
            ret -= gc.getCurrentPreference(conflicts, assignments);
        }
        return ret;
    }
}

