/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.GroupConstraint;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionPreferences
extends TimetablingCriterion {
    public DistributionPreferences() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.ContrPreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.ConstrPreferenceWeight";
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = 0.0;
        for (GroupConstraint gc : ((Lecture)value.variable()).groupConstraints()) {
            ret += (double)gc.getCurrentPreference(value);
        }
        return ret;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<GroupConstraint> constraints = new HashSet<GroupConstraint>();
        for (Lecture lect : variables) {
            for (GroupConstraint gc : lect.groupConstraints()) {
                if (!constraints.add(gc)) continue;
                ret += (double)gc.getCurrentPreference();
            }
        }
        return ret;
    }

    @Override
    protected double[] computeBounds() {
        double[] bounds = new double[]{0.0, 0.0};
        for (GroupConstraint gc : ((TimetableModel)this.getModel()).getGroupConstraints()) {
            if (gc.isHard()) continue;
            bounds[0] = bounds[0] - (double)Math.abs(gc.getPreference());
            bounds[1] = bounds[1] + (double)(Math.abs(gc.getPreference()) * (gc.variables().size() * (gc.variables().size() - 1)) / 2);
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet<GroupConstraint> constraints = new HashSet<GroupConstraint>();
        for (Lecture lect : variables) {
            for (GroupConstraint gc : lect.groupConstraints()) {
                if (gc.isHard() || !constraints.add(gc)) continue;
                bounds[0] = bounds[0] - (double)Math.abs(gc.getPreference());
                bounds[1] = bounds[1] + (double)(Math.abs(gc.getPreference()) * (gc.variables().size() * (gc.variables().size() - 1)) / 2);
            }
        }
        return bounds;
    }
}

