/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.coursett.constraint.InstructorConstraint;
import net.sf.cpsolver.coursett.criteria.TimetablingCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.criteria.AbstractCriterion;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackToBackInstructorPreferences
extends TimetablingCriterion {
    public BackToBackInstructorPreferences() {
        this.iValueUpdateType = AbstractCriterion.ValueUpdateType.NoUpdate;
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0 * config.getPropertyDouble("Comparator.DistanceInstructorPreferenceWeight", 1.0);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.DistanceInstructorPreferenceWeight";
    }

    protected int penalty(Placement value) {
        int ret = 0;
        for (InstructorConstraint ic : ((Lecture)value.variable()).getInstructorConstraints()) {
            ret += ic.getPreference(value);
        }
        return ret;
    }

    @Override
    public double getValue(Placement value, Set<Placement> conflicts) {
        double ret = this.penalty(value);
        if (conflicts != null) {
            for (Placement conflict : conflicts) {
                ret -= (double)this.penalty(conflict);
            }
        }
        return ret;
    }

    @Override
    public double getValue(Collection<Lecture> variables) {
        double ret = 0.0;
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lect : variables) {
            for (InstructorConstraint ic : lect.getInstructorConstraints()) {
                if (!constraints.add(ic)) continue;
                ret += (double)ic.getPreference();
            }
        }
        return ret;
    }

    @Override
    protected double[] computeBounds() {
        double[] bounds = new double[]{0.0, 0.0};
        for (InstructorConstraint ic : ((TimetableModel)this.getModel()).getInstructorConstraints()) {
            bounds[1] = bounds[1] + (double)ic.getWorstPreference();
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Collection<Lecture> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        HashSet<InstructorConstraint> constraints = new HashSet<InstructorConstraint>();
        for (Lecture lect : variables) {
            for (InstructorConstraint ic : lect.getInstructorConstraints()) {
                if (!constraints.add(ic)) continue;
                bounds[1] = bounds[1] + (double)ic.getWorstPreference();
            }
        }
        return bounds;
    }
}

