/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.criteria.BrokenTimePatterns;
import net.sf.cpsolver.coursett.criteria.UselessHalfHours;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomSharingModel;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.model.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomConstraint
extends Constraint<Lecture, Placement> {
    private List<Placement>[] iResource;
    private Long iResourceId;
    private String iName;
    private Long iBuildingId;
    private int iCapacity = 0;
    private List<Placement>[] iAvailable = null;
    private boolean iConstraint = true;
    private Double iPosX = null;
    private Double iPosY = null;
    private boolean iIgnoreTooFar = false;
    private RoomSharingModel iRoomSharingModel = null;
    private Long iType = null;
    private int iLastUselessHalfHours = 0;
    private double iLastBrokenTimePatterns = 0.0;

    public RoomConstraint(Long id, String name, Long buildingId, int capacity, RoomSharingModel roomSharingModel, Double x, Double y, boolean ignoreTooFar, boolean constraint) {
        this.iResourceId = id;
        this.iName = name;
        this.iResource = new List[288 * Constants.NR_DAYS];
        this.iBuildingId = buildingId;
        this.iCapacity = capacity;
        this.iConstraint = constraint;
        for (int i = 0; i < this.iResource.length; ++i) {
            this.iResource[i] = new ArrayList<Placement>(3);
        }
        this.iRoomSharingModel = roomSharingModel;
        this.iPosX = x;
        this.iPosY = y;
        this.iIgnoreTooFar = ignoreTooFar;
    }

    public void setNotAvailable(Placement placement) {
        if (this.iAvailable == null) {
            this.iAvailable = new List[288 * Constants.NR_DAYS];
            for (int i = 0; i < this.iResource.length; ++i) {
                this.iAvailable[i] = null;
            }
        }
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            if (this.iAvailable[slot] == null) {
                this.iAvailable[slot] = new ArrayList<Placement>(1);
            }
            this.iAvailable[slot].add(placement);
        }
        for (Lecture lecture : this.variables()) {
            lecture.clearValueCache();
        }
    }

    public boolean isAvailable(int slot) {
        if (this.iAvailable != null && this.iAvailable[slot] != null && !this.iAvailable[slot].isEmpty()) {
            return false;
        }
        return this.getSharingModel() == null || !this.getSharingModel().isNotAvailable(slot);
    }

    public boolean isAvailable(Lecture lecture, TimeLocation time, Long scheduler) {
        if (this.iAvailable != null) {
            TimeLocation.IntEnumeration e = time.getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                if (this.iAvailable[slot] == null) continue;
                for (Placement p : this.iAvailable[slot]) {
                    if (lecture.canShareRoom((Lecture)p.variable()) || !time.shareWeeks(p.getTimeLocation())) continue;
                    return false;
                }
            }
        }
        return this.getSharingModel() == null || this.getSharingModel().isAvailable(time, scheduler);
    }

    public List<Placement>[] getAvailableArray() {
        return this.iAvailable;
    }

    public RoomSharingModel getSharingModel() {
        return this.iRoomSharingModel;
    }

    public Long getResourceId() {
        return this.iResourceId;
    }

    public Long getBuildingId() {
        return this.iBuildingId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String getRoomName() {
        return this.iName;
    }

    public int getCapacity() {
        return this.iCapacity;
    }

    public Placement getPlacement(int slot, int day) {
        for (Placement p : this.iResource[slot]) {
            if (!p.getTimeLocation().hasDay(day)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void computeConflicts(Placement placement, Set<Placement> conflicts) {
        if (!this.getConstraint()) {
            return;
        }
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return;
        }
        Lecture lecture = (Lecture)placement.variable();
        boolean canShareRoom = lecture.canShareRoom();
        int size = lecture.maxRoomUse();
        HashSet<Placement> skipPlacements = null;
        BitSet weekCode = placement.getTimeLocation().getWeekCode();
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement confPlacement : this.iResource[slot]) {
                if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(lecture.getAssignment())) continue;
                Lecture confLecture = (Lecture)confPlacement.variable();
                if (skipPlacements != null && skipPlacements.contains(confPlacement)) continue;
                if (canShareRoom && confPlacement.canShareRooms(placement) && confLecture.maxRoomUse() + size <= this.getCapacity()) {
                    size += confLecture.maxRoomUse();
                    if (skipPlacements == null) {
                        skipPlacements = new HashSet<Placement>();
                    }
                    skipPlacements.add(confPlacement);
                    continue;
                }
                conflicts.add(confPlacement);
            }
        }
    }

    @Override
    public boolean inConflict(Placement placement) {
        if (!this.getConstraint()) {
            return false;
        }
        Lecture lecture = (Lecture)placement.variable();
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        int size = lecture.maxRoomUse();
        HashSet<Placement> skipPlacements = null;
        BitSet weekCode = placement.getTimeLocation().getWeekCode();
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement confPlacement : this.iResource[slot]) {
                if (!confPlacement.getTimeLocation().shareWeeks(weekCode) || confPlacement.equals(lecture.getAssignment())) continue;
                Lecture confLecture = (Lecture)confPlacement.variable();
                if (skipPlacements != null && skipPlacements.contains(confPlacement)) continue;
                if (confPlacement.canShareRooms(placement) && confLecture.maxRoomUse() + size <= this.getCapacity()) {
                    size += confLecture.maxRoomUse();
                    if (skipPlacements == null) {
                        skipPlacements = new HashSet<Placement>();
                    }
                    skipPlacements.add(confPlacement);
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        if (!this.getConstraint()) {
            return true;
        }
        if (!p1.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        if (!p2.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        return p1.getTimeLocation().hasIntersection(p2.getTimeLocation()) && (!p1.canShareRooms(p2) || ((Lecture)p1.variable()).maxRoomUse() + ((Lecture)p2.variable()).maxRoomUse() > this.getCapacity());
    }

    @Override
    public void assigned(long iteration, Placement placement) {
        super.assigned(iteration, placement);
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return;
        }
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            this.iResource[slot].add(placement);
        }
        this.getModel().getCriterion(UselessHalfHours.class).inc(-this.iLastUselessHalfHours);
        this.iLastUselessHalfHours = UselessHalfHours.countUselessSlotsHalfHours(this);
        this.getModel().getCriterion(UselessHalfHours.class).inc(this.iLastUselessHalfHours);
        this.getModel().getCriterion(BrokenTimePatterns.class).inc(-this.iLastBrokenTimePatterns);
        this.iLastBrokenTimePatterns = (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(this) / 6.0;
        this.getModel().getCriterion(BrokenTimePatterns.class).inc(this.iLastBrokenTimePatterns);
    }

    @Override
    public void unassigned(long iteration, Placement placement) {
        super.unassigned(iteration, placement);
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return;
        }
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            this.iResource[slot].remove(placement);
        }
        this.getModel().getCriterion(UselessHalfHours.class).inc(-this.iLastUselessHalfHours);
        this.iLastUselessHalfHours = UselessHalfHours.countUselessSlotsHalfHours(this);
        this.getModel().getCriterion(UselessHalfHours.class).inc(this.iLastUselessHalfHours);
        this.getModel().getCriterion(BrokenTimePatterns.class).inc(-this.iLastBrokenTimePatterns);
        this.iLastBrokenTimePatterns = (double)BrokenTimePatterns.countUselessSlotsBrokenTimePatterns(this) / 6.0;
        this.getModel().getCriterion(BrokenTimePatterns.class).inc(this.iLastBrokenTimePatterns);
    }

    public List<Placement> getResource(int slot) {
        return this.iResource[slot];
    }

    public Placement[] getResourceOfWeek(int startDay) {
        Placement[] ret = new Placement[this.iResource.length];
        for (int i = 0; i < this.iResource.length; ++i) {
            ret[i] = this.getPlacement(i, startDay + i / 288);
        }
        return ret;
    }

    protected void printUsage(StringBuffer sb) {
        for (int slot = 0; slot < this.iResource.length; ++slot) {
            for (Placement p : this.iResource[slot]) {
                int day = slot / 288;
                int time = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                int h = time / 60;
                int m = time % 60;
                String d = Constants.DAY_NAMES_SHORT[day];
                int slots = p.getTimeLocation().getLength();
                int h2 = (time += 30 * slots) / 60;
                int m2 = time % 60;
                sb.append(sb.length() == 0 ? "" : ",\n        ").append("[" + d + (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a") + "-" + (h2 > 12 ? h2 - 12 : h2) + ":" + (m2 < 10 ? "0" : "") + m2 + (h2 >= 12 ? "p" : "a") + "]=").append(((Lecture)p.variable()).getName());
                slot += slots - 1;
            }
        }
    }

    public String toString() {
        return "Room " + this.getName();
    }

    public void setCoordinates(Double x, Double y) {
        this.iPosX = x;
        this.iPosY = y;
    }

    public Double getPosX() {
        return this.iPosX;
    }

    public Double getPosY() {
        return this.iPosY;
    }

    public boolean getIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public boolean getConstraint() {
        return this.iConstraint;
    }

    public Long getType() {
        return this.iType;
    }

    public void setType(Long type) {
        this.iType = type;
    }
}

