/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimizeNumberOfUsedRoomsConstraint
extends Constraint<Lecture, Placement>
implements WeakeningConstraint<Lecture, Placement> {
    private int iUnassignmentsToWeaken = 250;
    private long iUnassignment = 0L;
    private int iLimit = 1;
    private HashMap<RoomLocation, Set<Lecture>> iUsedRooms = new HashMap();
    boolean iEnabled = false;

    public MinimizeNumberOfUsedRoomsConstraint(DataProperties config) {
        this.iUnassignmentsToWeaken = config.getPropertyInt("MinimizeNumberOfUsedRooms.Unassignments2Weaken", this.iUnassignmentsToWeaken);
    }

    public boolean isOverLimit(Placement placement) {
        return this.getOverLimit(placement) > 0;
    }

    public int getOverLimit(Placement placement) {
        if (!this.iEnabled) {
            return 0;
        }
        if (this.iUnassignmentsToWeaken == 0) {
            return 0;
        }
        Lecture lecture = (Lecture)placement.variable();
        if (lecture.getNrRooms() <= 0) {
            return 0;
        }
        if (lecture.roomLocations().size() == lecture.getNrRooms()) {
            return 0;
        }
        if (lecture.isCommitted()) {
            return 0;
        }
        int usage = this.iUsedRooms.size();
        if (usage + lecture.getNrRooms() <= this.iLimit) {
            return 0;
        }
        if (placement.isMultiRoom()) {
            HashSet<RoomLocation> assignedRooms = new HashSet<RoomLocation>();
            if (lecture.getAssignment() != null) {
                assignedRooms.addAll(((Placement)lecture.getAssignment()).getRoomLocations());
            }
            for (RoomLocation r : placement.getRoomLocations()) {
                if (assignedRooms.remove(r) || this.iUsedRooms.containsKey(r)) continue;
                ++usage;
            }
            for (RoomLocation r : assignedRooms) {
                Set<Lecture> lects = this.iUsedRooms.get(r);
                if (lects == null || lects.size() != 1) continue;
                --usage;
            }
        } else {
            RoomLocation assignedRoom = lecture.getAssignment() != null && !((Placement)lecture.getAssignment()).equals(placement) ? ((Placement)lecture.getAssignment()).getRoomLocation() : null;
            RoomLocation room = placement.getRoomLocation();
            if (!room.equals(assignedRoom)) {
                Set<Lecture> lects;
                if (!this.iUsedRooms.containsKey(room)) {
                    ++usage;
                }
                if (assignedRoom != null && (lects = this.iUsedRooms.get(assignedRoom)) != null && lects.size() == 1) {
                    --usage;
                }
            }
        }
        if (usage <= this.iUsedRooms.size()) {
            return 0;
        }
        if (usage <= this.iLimit) {
            return 0;
        }
        return usage - this.iLimit;
    }

    @Override
    public void computeConflicts(Placement placement, Set<Placement> conflicts) {
        int overLimit = this.getOverLimit(placement);
        if (overLimit > 0) {
            ArrayList adepts = new ArrayList();
            for (Set<Lecture> lects : this.iUsedRooms.values()) {
                ArrayList placementsToUnassign = new ArrayList();
                boolean canUnassign = true;
                for (Lecture l : lects) {
                    if (l.isCommitted()) {
                        canUnassign = false;
                        break;
                    }
                    if (conflicts.contains(l.getAssignment())) continue;
                    placementsToUnassign.add(l.getAssignment());
                }
                if (!canUnassign) continue;
                adepts.add(placementsToUnassign);
            }
            if (adepts.size() < overLimit) {
                conflicts.add(placement);
            } else {
                Collections.sort(adepts, new Comparator<List<Placement>>(){

                    @Override
                    public int compare(List<Placement> c1, List<Placement> c2) {
                        return Double.compare(c1.size(), c2.size());
                    }
                });
                for (int i = 0; i < overLimit; ++i) {
                    conflicts.addAll((Collection)adepts.get(i));
                }
            }
        }
    }

    @Override
    public boolean inConflict(Placement placeement) {
        return this.isOverLimit(placeement);
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        return this.isOverLimit(value1) || this.isOverLimit(value2);
    }

    @Override
    public void assigned(long iteration, Placement placement) {
        super.assigned(iteration, placement);
        Lecture lecture = (Lecture)placement.variable();
        if (lecture.getNrRooms() <= 0) {
            return;
        }
        if (placement.isMultiRoom()) {
            for (RoomLocation r : placement.getRoomLocations()) {
                Set<Lecture> lects = this.iUsedRooms.get(r);
                if (lects == null) {
                    lects = new HashSet<Lecture>();
                    this.iUsedRooms.put(r, lects);
                }
                lects.add(lecture);
            }
        } else {
            RoomLocation r = placement.getRoomLocation();
            Set<Lecture> lects = this.iUsedRooms.get(r);
            if (lects == null) {
                lects = new HashSet<Lecture>();
                this.iUsedRooms.put(r, lects);
            }
            lects.add(lecture);
        }
    }

    @Override
    public void unassigned(long iteration, Placement placement) {
        super.unassigned(iteration, placement);
        Lecture lecture = (Lecture)placement.variable();
        if (lecture.getNrRooms() <= 0) {
            return;
        }
        if (placement.isMultiRoom()) {
            for (RoomLocation r : placement.getRoomLocations()) {
                Set<Lecture> lects = this.iUsedRooms.get(r);
                if (lects == null) continue;
                lects.remove(lecture);
                if (!lects.isEmpty()) continue;
                this.iUsedRooms.remove(r);
            }
        } else {
            RoomLocation r = placement.getRoomLocation();
            Set<Lecture> lects = this.iUsedRooms.get(r);
            if (lects != null) {
                lects.remove(lecture);
                if (lects.isEmpty()) {
                    this.iUsedRooms.remove(r);
                }
            }
        }
    }

    @Override
    public void weaken() {
        ++this.iUnassignment;
        if (this.iUnassignmentsToWeaken > 0 && this.iUnassignment % (long)this.iUnassignmentsToWeaken == 0L) {
            ++this.iLimit;
        }
    }

    @Override
    public String getName() {
        return "Minimize number of used rooms";
    }

    public int estimateLimit() {
        HashSet<RoomLocation> mandatoryRooms = new HashSet<RoomLocation>();
        for (Lecture lecture : this.variables()) {
            if (lecture.getNrRooms() == 0 || !lecture.isCommitted() && lecture.roomLocations().size() != 1) continue;
            mandatoryRooms.addAll(lecture.roomLocations());
        }
        double[][] histogram = new double[288][Constants.NR_DAYS_WEEK];
        for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                histogram[i][j] = 0.0;
            }
        }
        for (Lecture lecture : this.variables()) {
            if (lecture.getNrRooms() == 0) continue;
            List<Placement> values = lecture.values();
            for (Placement p : lecture.values()) {
                int endSlot;
                int firstSlot = p.getTimeLocation().getStartSlot();
                if (firstSlot > Constants.DAY_SLOTS_LAST || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < Constants.DAY_SLOTS_FIRST) continue;
                for (int i = firstSlot; i <= endSlot; ++i) {
                    int dayCode = p.getTimeLocation().getDayCode();
                    for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                        if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                        double[] dArray = histogram[i];
                        int n = j;
                        dArray[n] = dArray[n] + (double)lecture.getNrRooms() / (double)values.size();
                    }
                }
            }
        }
        int maxAverageRooms = 0;
        for (int i = 0; i < Constants.SLOTS_PER_DAY_NO_EVENINGS; ++i) {
            for (int j = 0; j < Constants.NR_DAYS_WEEK; ++j) {
                maxAverageRooms = Math.max(maxAverageRooms, (int)Math.ceil(histogram[i][j]));
            }
        }
        return Math.max(1, Math.max(mandatoryRooms.size(), maxAverageRooms));
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
        this.iLimit = Math.max(this.iUsedRooms.size(), this.estimateLimit());
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Minimize Number Of Rooms Used between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void weaken(Placement value) {
        if (this.isOverLimit(value)) {
            this.iLimit += this.getOverLimit(value);
        }
    }
}

