/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.HashSet;
import java.util.Set;
import net.sf.cpsolver.coursett.criteria.StudentConflict;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.criteria.Criterion;
import net.sf.cpsolver.ifs.model.BinaryConstraint;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.DistanceMetric;
import net.sf.cpsolver.ifs.util.ToolBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenrlConstraint
extends BinaryConstraint<Lecture, Placement>
implements WeakeningConstraint<Lecture, Placement> {
    private double iJenrl = 0.0;
    private double iPriority = 0.0;
    private Set<Student> iStudents = new HashSet<Student>();
    private Set<Student> iInstructors = new HashSet<Student>();
    private boolean iAdded = false;
    private Double iJenrlLimit = null;
    private double iTwiggle = 0.0;

    @Override
    public void addVariable(Lecture variable) {
        double maxConflicts;
        super.addVariable(variable);
        if (this.second() != null && variable.getModel() != null && variable.getModel() instanceof TimetableModel && (maxConflicts = ((TimetableModel)variable.getModel()).getProperties().getPropertyDouble("General.JenrlMaxConflicts", 1.0)) >= 0.0 && maxConflicts < 1.0) {
            this.iJenrlLimit = (double)Math.min(((Lecture)this.first()).maxClassLimit(), ((Lecture)this.second()).maxClassLimit()) * maxConflicts;
        }
    }

    @Override
    public void computeConflicts(Placement value, Set<Placement> conflicts) {
        if (this.inConflict(value)) {
            conflicts.add((Placement)((Lecture)this.another(value.variable())).getAssignment());
        }
    }

    @Override
    public boolean inConflict(Placement value) {
        if (!this.isOverLimit()) {
            return false;
        }
        Lecture other = (Lecture)this.another(value.variable());
        return other != null && other.getAssignment() != null && !other.isCommitted() && JenrlConstraint.isInConflict(value, (Placement)other.getAssignment(), this.getDistanceMetric());
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        return !this.isOverLimit() || !JenrlConstraint.isInConflict(value1, value2, this.getDistanceMetric());
    }

    @Override
    public void unassigned(long iteration, Placement value) {
        super.unassigned(iteration, value);
        if (this.iAdded) {
            this.iAdded = false;
            ((Lecture)this.first()).removeActiveJenrl(this);
            ((Lecture)this.second()).removeActiveJenrl(this);
        }
    }

    public static boolean isInConflict(Placement p1, Placement p2, DistanceMetric m) {
        return !StudentConflict.ignore(p1, p2) && (StudentConflict.distance(m, p1, p2) || StudentConflict.overlaps(p1, p2));
    }

    @Override
    public void assigned(long iteration, Placement value) {
        super.assigned(iteration, value);
        if (this.second() == null || ((Lecture)this.first()).getAssignment() == null || ((Lecture)this.second()).getAssignment() == null) {
            return;
        }
        if (JenrlConstraint.isInConflict((Placement)((Lecture)this.first()).getAssignment(), (Placement)((Lecture)this.second()).getAssignment(), this.getDistanceMetric())) {
            this.iAdded = true;
            ((Lecture)this.first()).addActiveJenrl(this);
            ((Lecture)this.second()).addActiveJenrl(this);
        }
    }

    public long jenrl(Lecture variable, Placement value) {
        Lecture anotherLecture;
        Lecture lecture = anotherLecture = ((Lecture)this.first()).equals(variable) ? (Lecture)this.second() : (Lecture)this.first();
        if (anotherLecture.getAssignment() == null) {
            return 0L;
        }
        return JenrlConstraint.isInConflict((Placement)anotherLecture.getAssignment(), value, this.getDistanceMetric()) ? Math.round(this.iJenrl) : 0L;
    }

    private DistanceMetric getDistanceMetric() {
        return this.getModel() == null ? null : ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    public boolean isInConflict() {
        return this.iAdded;
    }

    public void incJenrl(Student student) {
        boolean hard = this.isOverLimit();
        double jenrlWeight = student.getJenrlWeight((Lecture)this.first(), (Lecture)this.second());
        this.iJenrl += jenrlWeight;
        Double conflictPriority = student.getConflictingPriorty((Lecture)this.first(), (Lecture)this.second());
        if (conflictPriority != null) {
            this.iPriority += conflictPriority * jenrlWeight;
        }
        this.iStudents.add(student);
        if (student.getInstructor() != null && (student.getInstructor().variables().contains(this.first()) || student.getInstructor().variables().contains(this.second()))) {
            this.iInstructors.add(student);
        }
        for (Criterion criterion : this.getModel().getCriteria()) {
            if (!(criterion instanceof StudentConflict)) continue;
            ((StudentConflict)criterion).incJenrl(this, jenrlWeight, conflictPriority, student);
        }
        if (!hard && this.isOverLimit() && this.isInConflict()) {
            this.iJenrlLimit = this.iJenrlLimit + jenrlWeight;
        }
    }

    public double getJenrlWeight(Student student) {
        return student.getJenrlWeight((Lecture)this.first(), (Lecture)this.second());
    }

    public void decJenrl(Student student) {
        boolean hard = this.isOverLimit();
        double jenrlWeight = student.getJenrlWeight((Lecture)this.first(), (Lecture)this.second());
        this.iJenrl -= jenrlWeight;
        Double conflictPriority = student.getConflictingPriorty((Lecture)this.first(), (Lecture)this.second());
        if (conflictPriority != null) {
            this.iPriority -= conflictPriority * jenrlWeight;
        }
        this.iStudents.remove(student);
        this.iInstructors.remove(student);
        for (Criterion criterion : this.getModel().getCriteria()) {
            if (!(criterion instanceof StudentConflict)) continue;
            ((StudentConflict)criterion).incJenrl(this, -jenrlWeight, conflictPriority, student);
        }
        if (hard && !this.isOverLimit()) {
            double maxConflicts = ((TimetableModel)((Lecture)this.second()).getModel()).getProperties().getPropertyDouble("General.JenrlMaxConflicts", 1.0) + this.iTwiggle;
            this.iJenrlLimit = maxConflicts >= 0.0 && maxConflicts < 1.0 ? Double.valueOf(Math.max((double)Math.min(((Lecture)this.first()).maxClassLimit(), ((Lecture)this.second()).maxClassLimit()) * maxConflicts, this.iJenrlLimit - jenrlWeight)) : null;
        }
    }

    public long getJenrl() {
        return Math.round(this.iJenrl);
    }

    public double jenrl() {
        return this.iJenrl;
    }

    public double priority() {
        return this.iPriority;
    }

    public int getNrStudents() {
        return this.iStudents.size();
    }

    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public int getNrInstructors() {
        return this.iInstructors.size();
    }

    public Set<Student> getInstructors() {
        return this.iInstructors;
    }

    @Override
    public boolean isHard() {
        return true;
    }

    public boolean isOverLimit() {
        return this.iJenrlLimit != null && this.iJenrl > this.iJenrlLimit;
    }

    @Override
    public String getName() {
        return "Join Enrollment";
    }

    public String toString() {
        return "Join Enrollment between " + ((Lecture)this.first()).getName() + " and " + ((Lecture)this.second()).getName();
    }

    public boolean areStudentConflictsHard() {
        return StudentConflict.hard((Lecture)this.first(), (Lecture)this.second());
    }

    public boolean areStudentConflictsDistance() {
        return StudentConflict.distance(this.getDistanceMetric(), (Placement)((Lecture)this.first()).getAssignment(), (Placement)((Lecture)this.second()).getAssignment());
    }

    public boolean areStudentConflictsCommitted() {
        return StudentConflict.committed((Lecture)this.first(), (Lecture)this.second());
    }

    public boolean areStudentConflictsDistance(Placement value) {
        return StudentConflict.distance(this.getDistanceMetric(), value, (Placement)((Lecture)this.another(value.variable())).getAssignment());
    }

    public boolean isOfTheSameProblem() {
        return ToolBox.equals(((Lecture)this.first()).getSolverGroupId(), ((Lecture)this.second()).getSolverGroupId());
    }

    @Override
    public void weaken() {
        if (this.second() == null) {
            return;
        }
        this.iTwiggle += ((TimetableModel)((Lecture)this.second()).getModel()).getProperties().getPropertyDouble("General.JenrlMaxConflictsWeaken", 0.001);
        double maxConflicts = ((TimetableModel)((Lecture)this.second()).getModel()).getProperties().getPropertyDouble("General.JenrlMaxConflicts", 1.0) + this.iTwiggle;
        this.iJenrlLimit = maxConflicts >= 0.0 && maxConflicts < 1.0 ? Double.valueOf((double)Math.min(((Lecture)this.first()).maxClassLimit(), ((Lecture)this.second()).maxClassLimit()) * maxConflicts) : null;
    }

    @Override
    public void weaken(Placement value) {
        if (this.second() != null && this.inConflict(value)) {
            double maxConflicts = ((TimetableModel)((Lecture)this.second()).getModel()).getProperties().getPropertyDouble("General.JenrlMaxConflicts", 1.0) + this.iTwiggle;
            this.iTwiggle = (this.iJenrl + 1.0E-5) / (double)Math.min(((Lecture)this.first()).maxClassLimit(), ((Lecture)this.second()).maxClassLimit()) - maxConflicts;
            this.iJenrlLimit = maxConflicts + this.iTwiggle >= 0.0 && maxConflicts + this.iTwiggle < 1.0 ? Double.valueOf((double)Math.min(((Lecture)this.first()).maxClassLimit(), ((Lecture)this.second()).maxClassLimit()) * (maxConflicts + this.iTwiggle)) : null;
        }
    }

    public boolean isToBeIgnored() {
        return ((Lecture)this.first()).isToIgnoreStudentConflictsWith((Lecture)this.second());
    }
}

