/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.criteria.BackToBackInstructorPreferences;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.util.DistanceMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructorConstraint
extends Constraint<Lecture, Placement> {
    public int iPreference = 0;
    protected List<Placement>[] iResource;
    private Long iResourceId;
    private String iName;
    private String iPuid;
    private List<Placement> iUnavailabilities = null;
    private boolean iIgnoreDistances = false;
    private Long iType = null;

    public InstructorConstraint(Long id, String puid, String name, boolean ignDist) {
        this.iResourceId = id;
        this.iName = name;
        this.iPuid = puid;
        this.iIgnoreDistances = ignDist;
        this.iResource = new List[288 * Constants.DAY_CODES.length];
        for (int i = 0; i < this.iResource.length; ++i) {
            this.iResource[i] = new ArrayList<Placement>(3);
        }
    }

    public List<Placement> getPlacements(int slot, Placement placement) {
        return this.getPlacements(slot, placement.getTimeLocation().getWeekCode());
    }

    public List<Placement> getPlacements(int slot, BitSet weekCode) {
        ArrayList<Placement> placements = new ArrayList<Placement>(this.iResource[slot].size());
        for (Placement p : this.iResource[slot]) {
            if (!p.getTimeLocation().shareWeeks(weekCode)) continue;
            placements.add(p);
        }
        return placements;
    }

    public Placement getPlacement(int slot, int day) {
        for (Placement p : this.iResource[slot]) {
            if (!p.getTimeLocation().hasDay(day)) continue;
            return p;
        }
        return null;
    }

    public void setNotAvailable(Placement placement) {
        if (this.iUnavailabilities == null) {
            this.iUnavailabilities = new ArrayList<Placement>();
        }
        this.iUnavailabilities.add(placement);
        for (Lecture lecture : this.variables()) {
            lecture.clearValueCache();
        }
    }

    public boolean isAvailable(Lecture lecture, TimeLocation time) {
        if (this.iUnavailabilities == null) {
            return true;
        }
        for (Placement c : this.iUnavailabilities) {
            if (!c.getTimeLocation().hasIntersection(time) || lecture.canShareRoom((Lecture)c.variable())) continue;
            return false;
        }
        return true;
    }

    private DistanceMetric getDistanceMetric() {
        return ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    public boolean isAvailable(Lecture lecture, Placement placement) {
        if (this.iUnavailabilities == null) {
            return true;
        }
        TimeLocation t1 = placement.getTimeLocation();
        for (Placement c : this.iUnavailabilities) {
            TimeLocation t2;
            if (!(!c.getTimeLocation().hasIntersection(placement.getTimeLocation()) || lecture.canShareRoom((Lecture)c.variable()) && placement.sameRooms(c))) {
                return false;
            }
            if (this.iIgnoreDistances || !t1.shareDays(t2 = c.getTimeLocation()) || !t1.shareWeeks(t2) || !(t1.getStartSlot() + t1.getLength() == t2.getStartSlot() || t2.getStartSlot() + t2.getLength() == t1.getStartSlot() ? Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c) > this.getDistanceMetric().getInstructorProhibitedLimit() : this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses() && (t1.getStartSlot() + t1.getLength() < t2.getStartSlot() ? Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, c) > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength()) : t2.getStartSlot() + t2.getLength() < t1.getStartSlot() && Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, c) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())))) continue;
            return false;
        }
        return true;
    }

    public List<Placement> getUnavailabilities() {
        return this.iUnavailabilities;
    }

    @Deprecated
    public List<Placement>[] getAvailableArray() {
        if (this.iUnavailabilities == null) {
            return null;
        }
        List[] available = new List[288 * Constants.DAY_CODES.length];
        for (int i = 0; i < this.iResource.length; ++i) {
            available[i] = null;
        }
        for (Placement p : this.iUnavailabilities) {
            TimeLocation.IntEnumeration e = p.getTimeLocation().getSlots();
            while (e.hasMoreElements()) {
                int slot = (Integer)e.nextElement();
                if (available[slot] == null) {
                    available[slot] = new ArrayList(1);
                }
                available[slot].add(p);
            }
        }
        return available;
    }

    public int getDistancePreference(Placement p1, Placement p2) {
        TimeLocation t1 = p1.getTimeLocation();
        TimeLocation t2 = p2.getTimeLocation();
        if (t1 == null || t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) {
            return 0;
        }
        if (t1.getStartSlot() + t1.getLength() == t2.getStartSlot() || t2.getStartSlot() + t2.getLength() == t1.getStartSlot()) {
            double distance = Placement.getDistanceInMeters(this.getDistanceMetric(), p1, p2);
            if (distance <= this.getDistanceMetric().getInstructorNoPreferenceLimit()) {
                return 0;
            }
            if (distance <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                return 1;
            }
            if (this.iIgnoreDistances || distance <= this.getDistanceMetric().getInstructorProhibitedLimit()) {
                return 4;
            }
            return 100;
        }
        if (this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
            if (t1.getStartSlot() + t1.getLength() < t2.getStartSlot()) {
                int distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), p1, p2);
                if (distanceInMinutes > t1.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength())) {
                    return this.iIgnoreDistances ? 4 : 100;
                }
                if ((double)distanceInMinutes >= this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                    return 4;
                }
                if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - t1.getStartSlot() - t1.getLength())) {
                    return 1;
                }
            } else if (t2.getStartSlot() + t2.getLength() < t1.getStartSlot()) {
                int distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), p1, p2);
                if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                    return this.iIgnoreDistances ? 4 : 100;
                }
                if ((double)distanceInMinutes >= this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                    return 4;
                }
                if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                    return 1;
                }
            }
        }
        return 0;
    }

    public Long getResourceId() {
        return this.iResourceId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    @Override
    public void computeConflicts(Placement placement, Set<Placement> conflicts) {
        Lecture lecture = (Lecture)placement.variable();
        BitSet weekCode = placement.getTimeLocation().getWeekCode();
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement p : this.iResource[slot]) {
                if (p.equals(lecture.getAssignment()) || !p.getTimeLocation().shareWeeks(weekCode) || p.canShareRooms(placement) && p.sameRooms(placement)) continue;
                conflicts.add(p);
            }
        }
        if (!this.iIgnoreDistances) {
            e = placement.getTimeLocation().getStartSlots();
            while (e.hasMoreElements()) {
                int nextSlot;
                int startSlot = (Integer)e.nextElement();
                int prevSlot = startSlot - 1;
                if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                    for (Placement placement2 : this.getPlacements(prevSlot, placement)) {
                        if (lecture.equals(placement2.variable()) || placement2.canShareRooms(placement) && placement2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        conflicts.add(placement2);
                    }
                }
                if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                    for (Placement c2 : this.getPlacements(nextSlot, placement)) {
                        if (lecture.equals(c2.variable()) || c2.canShareRooms(placement) && c2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        conflicts.add(c2);
                    }
                }
                if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
                TimeLocation timeLocation = placement.getTimeLocation();
                for (Lecture other : this.assignedVariables()) {
                    if (other.getAssignment() == null || other.equals(placement.variable())) continue;
                    TimeLocation t2 = ((Placement)other.getAssignment()).getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                    if (timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot()) {
                        if (Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment()) <= timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) continue;
                        conflicts.add((Placement)other.getAssignment());
                        continue;
                    }
                    if (t2.getStartSlot() + t2.getLength() >= timeLocation.getStartSlot() || Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment()) <= t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) continue;
                    conflicts.add((Placement)other.getAssignment());
                }
            }
        }
    }

    @Override
    public boolean inConflict(Placement placement) {
        Lecture lecture = (Lecture)placement.variable();
        BitSet weekCode = placement.getTimeLocation().getWeekCode();
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            for (Placement p : this.iResource[slot]) {
                if (p.equals(lecture.getAssignment()) || !p.getTimeLocation().shareWeeks(weekCode) || p.canShareRooms(placement) && p.sameRooms(placement)) continue;
                return true;
            }
        }
        if (!this.iIgnoreDistances) {
            e = placement.getTimeLocation().getStartSlots();
            while (e.hasMoreElements()) {
                int nextSlot;
                int startSlot = (Integer)e.nextElement();
                int prevSlot = startSlot - 1;
                if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                    for (Placement placement2 : this.getPlacements(prevSlot, placement)) {
                        if (lecture.equals(placement2.variable()) || placement2.canShareRooms(placement) && placement2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        return true;
                    }
                }
                if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                    for (Placement c2 : this.getPlacements(nextSlot, placement)) {
                        if (lecture.equals(c2.variable()) || c2.canShareRooms(placement) && c2.sameRooms(placement) || !(Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2) > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                        return true;
                    }
                }
                if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
                TimeLocation timeLocation = placement.getTimeLocation();
                for (Lecture other : this.assignedVariables()) {
                    if (other.getAssignment() == null || other.equals(placement.variable())) continue;
                    TimeLocation t2 = ((Placement)other.getAssignment()).getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2) || !(timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot() ? Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment()) > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength()) : t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot() && Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment()) > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        if (p1.canShareRooms(p2) && p1.sameRooms(p2)) {
            return true;
        }
        if (p1.getTimeLocation().hasIntersection(p2.getTimeLocation())) {
            return false;
        }
        return this.getDistancePreference(p1, p2) != 100;
    }

    @Override
    public void assigned(long iteration, Placement placement) {
        super.assigned(iteration, placement);
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            this.iResource[slot].add(placement);
        }
        this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(-this.iPreference);
        this.iPreference = this.countPreference();
        this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(this.iPreference);
    }

    @Override
    public void unassigned(long iteration, Placement placement) {
        super.unassigned(iteration, placement);
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            this.iResource[slot].remove(placement);
        }
        this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(-this.iPreference);
        this.iPreference = this.countPreference();
        this.getModel().getCriterion(BackToBackInstructorPreferences.class).inc(this.iPreference);
    }

    public List<Placement> getResource(int slot) {
        return this.iResource[slot];
    }

    public Placement[] getResourceOfWeek(int startDay) {
        Placement[] ret = new Placement[this.iResource.length];
        for (int i = 0; i < this.iResource.length; ++i) {
            ret[i] = this.getPlacement(i, startDay + i / 288);
        }
        return ret;
    }

    public int countUselessSlots() {
        int ret = 0;
        for (int d = 0; d < Constants.DAY_CODES.length; ++d) {
            for (int s = 1; s < 287; ++s) {
                int slot = d * 288 + s;
                if (this.iResource[slot - 1] == null || this.iResource[slot] != null || this.iResource[slot + 1] == null) continue;
                ++ret;
            }
        }
        return ret;
    }

    protected void printUsage(StringBuffer sb) {
        for (int slot = 0; slot < this.iResource.length; ++slot) {
            for (Placement p : this.iResource[slot]) {
                int day = slot / 288;
                int time = slot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
                int h = time / 60;
                int m = time % 60;
                String d = Constants.DAY_NAMES_SHORT[day];
                int slots = p.getTimeLocation().getLength();
                int h2 = (time += 30 * slots) / 60;
                int m2 = time % 60;
                sb.append(sb.length() == 0 ? "" : ",\n        ").append("[" + d + (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? "p" : "a") + "-" + (h2 > 12 ? h2 - 12 : h2) + ":" + (m2 < 10 ? "0" : "") + m2 + (h2 >= 12 ? "p" : "a") + "]=").append(((Lecture)p.variable()).getName());
                slot += slots - 1;
            }
        }
    }

    public String toString() {
        return "Instructor " + this.getName();
    }

    public int getPreference(Placement value) {
        Lecture lecture = (Lecture)value.variable();
        Placement placement = value;
        int pref = 0;
        HashSet<Placement> checked = new HashSet<Placement>();
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getStartSlots();
        while (e.hasMoreElements()) {
            TimeLocation t2;
            int nextSlot;
            int startSlot = (Integer)e.nextElement();
            int prevSlot = startSlot - 1;
            if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                for (Placement placement2 : this.getPlacements(prevSlot, placement)) {
                    if (lecture.equals(placement2.variable()) || !checked.add(placement2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        ++pref;
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref += 4;
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref += 100;
                }
            }
            if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                for (Placement c2 : this.getPlacements(nextSlot, placement)) {
                    if (lecture.equals(c2.variable()) || !checked.add(c2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        ++pref;
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref += 4;
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref = 100;
                }
            }
            if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
            TimeLocation timeLocation = placement.getTimeLocation();
            Placement before = null;
            Placement after = null;
            for (Lecture other : this.assignedVariables()) {
                int distanceInMinutes;
                if (other.getAssignment() == null || other.equals(placement.variable())) continue;
                t2 = ((Placement)other.getAssignment()).getTimeLocation();
                if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                if (timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment());
                    if (distanceInMinutes > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref += this.iIgnoreDistances ? 4 : 100;
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        ++pref;
                    }
                } else if (t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment());
                    if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref += this.iIgnoreDistances ? 4 : 100;
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        ++pref;
                    }
                }
                if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                    if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                    after = (Placement)other.getAssignment();
                    continue;
                }
                if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                before = (Placement)other.getAssignment();
            }
            if (this.iUnavailabilities != null) {
                for (Placement c : this.iUnavailabilities) {
                    t2 = c.getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                    if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                        if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                        after = c;
                        continue;
                    }
                    if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                    before = c;
                }
            }
            if (before != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                pref += 4;
            }
            if (after != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), after, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                pref += 4;
            }
            if (before == null || after == null || !((double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, after) > this.getDistanceMetric().getInstructorLongTravelInMinutes())) continue;
            pref -= 4;
        }
        return pref;
    }

    public int getPreferenceCombination(Placement value) {
        Lecture lecture = (Lecture)value.variable();
        Placement placement = value;
        int pref = 0;
        HashSet<Placement> checked = new HashSet<Placement>();
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getStartSlots();
        while (e.hasMoreElements()) {
            TimeLocation t2;
            int nextSlot;
            int startSlot = (Integer)e.nextElement();
            int prevSlot = startSlot - 1;
            if (prevSlot >= 0 && prevSlot / 288 == startSlot / 288) {
                for (Placement placement2 : this.getPlacements(prevSlot, placement)) {
                    if (lecture.equals(placement2.variable()) || !checked.add(placement2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, placement2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        pref = Math.max(pref, 1);
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref = Math.max(pref, 4);
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref = Math.max(pref, 100);
                }
            }
            if ((nextSlot = startSlot + placement.getTimeLocation().getLength()) / 288 == startSlot / 288) {
                for (Placement c2 : this.getPlacements(nextSlot, placement)) {
                    if (lecture.equals(c2.variable()) || !checked.add(c2)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), placement, c2);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        pref = Math.max(pref, 1);
                    }
                    if (dist > this.getDistanceMetric().getInstructorDiscouragedLimit() && (dist <= this.getDistanceMetric().getInstructorProhibitedLimit() || this.iIgnoreDistances)) {
                        pref = Math.max(pref, 4);
                    }
                    if (this.iIgnoreDistances || !(dist > this.getDistanceMetric().getInstructorProhibitedLimit())) continue;
                    pref = 100;
                }
            }
            if (!this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) continue;
            TimeLocation timeLocation = placement.getTimeLocation();
            Placement before = null;
            Placement after = null;
            for (Lecture other : this.assignedVariables()) {
                int distanceInMinutes;
                if (other.getAssignment() == null || other.equals(placement.variable())) continue;
                t2 = ((Placement)other.getAssignment()).getTimeLocation();
                if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                if (timeLocation.getStartSlot() + timeLocation.getLength() < t2.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment());
                    if (distanceInMinutes > timeLocation.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref = Math.max(pref, this.iIgnoreDistances ? 4 : 100);
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t2.getStartSlot() - timeLocation.getStartSlot() - timeLocation.getLength())) {
                        pref = Math.max(pref, 1);
                    }
                } else if (t2.getStartSlot() + t2.getLength() < timeLocation.getStartSlot()) {
                    distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), placement, (Placement)other.getAssignment());
                    if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref = Math.max(pref, this.iIgnoreDistances ? 4 : 100);
                    } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (timeLocation.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                        pref = Math.max(pref, 1);
                    }
                }
                if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                    if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                    after = (Placement)other.getAssignment();
                    continue;
                }
                if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                before = (Placement)other.getAssignment();
            }
            if (this.iUnavailabilities != null) {
                for (Placement c : this.iUnavailabilities) {
                    t2 = c.getTimeLocation();
                    if (timeLocation == null || t2 == null || !timeLocation.shareDays(t2) || !timeLocation.shareWeeks(t2)) continue;
                    if (timeLocation.getStartSlot() + timeLocation.getLength() <= t2.getStartSlot()) {
                        if (after != null && t2.getStartSlot() >= after.getTimeLocation().getStartSlot()) continue;
                        after = c;
                        continue;
                    }
                    if (t2.getStartSlot() + t2.getLength() > timeLocation.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                    before = c;
                }
            }
            int tooLongTravel = 0;
            if (before != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                ++tooLongTravel;
            }
            if (after != null && (double)Placement.getDistanceInMinutes(this.getDistanceMetric(), after, placement) > this.getDistanceMetric().getInstructorLongTravelInMinutes()) {
                ++tooLongTravel;
            }
            if (tooLongTravel <= 0) continue;
            pref += Math.max(pref, 4);
        }
        return pref;
    }

    public int getPreference() {
        return this.iPreference;
    }

    public int countPreference() {
        int pref = 0;
        HashSet<Placement> checked = new HashSet<Placement>();
        for (int slot = 1; slot < this.iResource.length; ++slot) {
            if (slot % 288 == 0) continue;
            for (Placement placement : this.iResource[slot]) {
                for (Placement c : this.getPlacements(slot - 1, placement)) {
                    if (((Lecture)placement.variable()).equals(c.variable()) || !checked.add(c)) continue;
                    double dist = Placement.getDistanceInMeters(this.getDistanceMetric(), c, placement);
                    if (dist > this.getDistanceMetric().getInstructorNoPreferenceLimit() && dist <= this.getDistanceMetric().getInstructorDiscouragedLimit()) {
                        ++pref;
                    }
                    if (!(dist > this.getDistanceMetric().getInstructorDiscouragedLimit())) continue;
                    pref += 4;
                }
            }
        }
        if (this.getDistanceMetric().doComputeDistanceConflictsBetweenNonBTBClasses()) {
            for (Lecture p1 : this.assignedVariables()) {
                TimeLocation t2;
                TimeLocation t1;
                TimeLocation timeLocation = t1 = p1.getAssignment() == null ? null : ((Placement)p1.getAssignment()).getTimeLocation();
                if (t1 == null) continue;
                Placement before = null;
                for (Lecture p2 : this.assignedVariables()) {
                    if (p2.getAssignment() == null || p2.equals(p1) || (t2 = ((Placement)p2.getAssignment()).getTimeLocation()) == null || !t1.shareDays(t2) || !t1.shareWeeks(t2)) continue;
                    if (t2.getStartSlot() + t2.getLength() < t1.getStartSlot()) {
                        int distanceInMinutes = Placement.getDistanceInMinutes(this.getDistanceMetric(), (Placement)p1.getAssignment(), (Placement)p2.getAssignment());
                        if (distanceInMinutes > t2.getBreakTime() + Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                            pref += this.iIgnoreDistances ? 4 : 100;
                        } else if (distanceInMinutes > Constants.SLOT_LENGTH_MIN * (t1.getStartSlot() - t2.getStartSlot() - t2.getLength())) {
                            ++pref;
                        }
                    }
                    if (t2.getStartSlot() + t2.getLength() > t1.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                    before = (Placement)p2.getAssignment();
                }
                if (this.iUnavailabilities != null) {
                    for (Placement c : this.iUnavailabilities) {
                        t2 = c.getTimeLocation();
                        if (t2 == null || !t1.shareDays(t2) || !t1.shareWeeks(t2) || t2.getStartSlot() + t2.getLength() > t1.getStartSlot() || before != null && before.getTimeLocation().getStartSlot() >= t2.getStartSlot()) continue;
                        before = c;
                    }
                }
                if (before == null || !((double)Placement.getDistanceInMinutes(this.getDistanceMetric(), before, (Placement)p1.getAssignment()) > this.getDistanceMetric().getInstructorLongTravelInMinutes())) continue;
                pref += 4;
            }
        }
        return pref;
    }

    public int getWorstPreference() {
        return 4 * (this.variables().size() - 1);
    }

    public String getPuid() {
        return this.iPuid;
    }

    public boolean isIgnoreDistances() {
        return this.iIgnoreDistances;
    }

    public void setIgnoreDistances(boolean ignDist) {
        this.iIgnoreDistances = ignDist;
    }

    public Long getType() {
        return this.iType;
    }

    public void setType(Long type) {
        this.iType = type;
    }
}

