/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.constraint.BreakFlexibleConstraint;
import net.sf.cpsolver.coursett.constraint.MaxBlockFlexibleConstraint;
import net.sf.cpsolver.coursett.constraint.MaxBreaksFlexibleConstraint;
import net.sf.cpsolver.coursett.criteria.FlexibleConstraintCriterion;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.coursett.model.TimetableModel;
import net.sf.cpsolver.ifs.model.Constraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlexibleConstraint
extends Constraint<Lecture, Placement> {
    private int iPreference;
    private boolean iIsRequired;
    private double iLastPreference;
    private String iOwner;
    protected FlexibleConstraintType iConstraintType = null;
    protected String iReference = "";
    protected List<BitSet> iWeeks = null;

    @Override
    public abstract void computeConflicts(Placement var1, Set<Placement> var2);

    public abstract double getNrViolations(Set<Placement> var1, HashMap<Lecture, Placement> var2);

    public FlexibleConstraint(Long id, String owner, String preference, String reference) {
        this.iId = id;
        this.iReference = reference;
        this.iPreference = Constants.preference2preferenceLevel(preference);
        this.iIsRequired = preference.equals("R");
        this.iOwner = owner;
    }

    public List<BitSet> getWeeks() {
        if (this.iWeeks == null) {
            TimetableModel model = (TimetableModel)this.getModel();
            this.iWeeks = new ArrayList<BitSet>();
            boolean checkWeeks = model.getProperties().getPropertyBoolean("FlexibleConstraint.CheckWeeks", false);
            if (checkWeeks) {
                this.iWeeks = model.getWeeks();
            } else {
                this.iWeeks.add(null);
            }
        }
        return this.iWeeks;
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        HashMap<Lecture, Placement> assignments = new HashMap<Lecture, Placement>();
        if (value1 != null) {
            assignments.put((Lecture)value1.variable(), value1);
        }
        if (value2 != null) {
            assignments.put((Lecture)value2.variable(), value2);
        }
        if (this.getNrViolations(null, assignments) != 0.0) {
            return false;
        }
        return super.isConsistent(value1, value2);
    }

    protected Set<Placement> getRelevantPlacements(int dayCode, Set<Placement> conflicts, Placement value, HashMap<Lecture, Placement> assignments, BitSet week) {
        HashSet<Placement> placements = new HashSet<Placement>();
        for (Lecture lecture : this.variables()) {
            TimeLocation t;
            if (value != null && lecture.equals(value.variable())) continue;
            if (assignments != null && assignments.containsKey(lecture)) {
                TimeLocation t2;
                Placement p = assignments.get(lecture);
                if (p == null || !this.shareWeeksAndDay(t2 = p.getTimeLocation(), week, dayCode)) continue;
                placements.add(p);
                continue;
            }
            if (lecture.getAssignment() == null || ((Placement)lecture.getAssignment()).getTimeLocation() == null || conflicts != null && conflicts.contains(lecture.getAssignment()) || (t = ((Placement)lecture.getAssignment()).getTimeLocation()) == null || !this.shareWeeksAndDay(t, week, dayCode)) continue;
            placements.add((Placement)lecture.getAssignment());
        }
        if (value == null || conflicts != null && conflicts.contains(value)) {
            return placements;
        }
        if (this.shareWeeksAndDay(value.getTimeLocation(), week, dayCode)) {
            placements.add(value);
        }
        return placements;
    }

    private boolean shareWeeksAndDay(TimeLocation t, BitSet week, int dayCode) {
        boolean matchDay = (t.getDayCode() & dayCode) != 0;
        boolean matchWeek = week == null || t.shareWeeks(week);
        return matchDay && matchWeek;
    }

    protected List<Block> mergeToBlocks(List<Placement> sorted, int maxBreakBetweenBTB) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (int i = 0; i < sorted.size(); ++i) {
            Placement placement = sorted.get(i);
            boolean added = false;
            for (int j = 0; j < blocks.size(); ++j) {
                if (!((Block)blocks.get(j)).addPlacement(placement)) continue;
                added = true;
            }
            if (added) continue;
            Block block = new Block(maxBreakBetweenBTB);
            block.addPlacement(placement);
            blocks.add(block);
        }
        return blocks;
    }

    @Override
    public boolean isHard() {
        return this.iIsRequired;
    }

    @Override
    public String getName() {
        return this.iOwner + ": " + this.iConstraintType.getName();
    }

    public FlexibleConstraintType getType() {
        return this.iConstraintType;
    }

    @Override
    public void assigned(long iteration, Placement value) {
        super.assigned(iteration, value);
        this.updateCriterion();
    }

    public String getReference() {
        return this.iReference;
    }

    public String getOwner() {
        return this.iOwner;
    }

    public String getPrologPreference() {
        return Constants.preferenceLevel2preference(this.iPreference);
    }

    private void updateCriterion() {
        FlexibleConstraintCriterion pc = (FlexibleConstraintCriterion)this.getModel().getCriterion(FlexibleConstraintCriterion.class);
        if (pc != null && !this.isHard()) {
            pc.inc(-this.iLastPreference);
            this.iLastPreference = this.getCurrentPreference(null, null);
            pc.inc(this.iLastPreference);
        }
    }

    public double getCurrentPreference(Set<Placement> conflicts, HashMap<Lecture, Placement> assignments) {
        if (this.isHard()) {
            return 0.0;
        }
        double pref = this.getNrViolations(conflicts, assignments);
        if (pref == 0.0) {
            return -Math.abs(this.iPreference);
        }
        return (double)Math.abs(this.iPreference) * pref;
    }

    @Override
    public void unassigned(long iteration, Placement value) {
        super.unassigned(iteration, value);
        this.updateCriterion();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PlacementTimeComparator
    implements Comparator<Placement> {
        protected PlacementTimeComparator() {
        }

        @Override
        public int compare(Placement p1, Placement p2) {
            TimeLocation t1 = p1.getTimeLocation();
            TimeLocation t2 = p2.getTimeLocation();
            if (t1.getStartSlot() < t2.getStartSlot()) {
                return -1;
            }
            if (t1.getStartSlot() > t2.getStartSlot()) {
                return 1;
            }
            if (t1.getLength() < t2.getLength()) {
                return -1;
            }
            if (t1.getLength() > t2.getLength()) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Block {
        private int startSlotCurrentBlock = -1;
        private int endSlotCurrentBlock = -1;
        private int maxSlotsBetweenBackToBack = 4;
        private List<Placement> placements = new ArrayList<Placement>();

        public Block(int maxSlotsBetweenBTB) {
            this.maxSlotsBetweenBackToBack = maxSlotsBetweenBTB;
        }

        public boolean addPlacement(Placement placement) {
            if (placement == null) {
                return false;
            }
            TimeLocation t = placement.getTimeLocation();
            if (t == null) {
                return false;
            }
            if (this.placements.isEmpty()) {
                this.placements.add(placement);
                this.startSlotCurrentBlock = t.getStartSlot();
                this.endSlotCurrentBlock = t.getStartSlot() + t.getLength();
                return true;
            }
            if (t.getStartSlot() == this.startSlotCurrentBlock) {
                this.placements.add(placement);
                int tEnd = t.getStartSlot() + t.getLength();
                if (tEnd > this.endSlotCurrentBlock) {
                    this.endSlotCurrentBlock = tEnd;
                }
                return true;
            }
            if (this.endSlotCurrentBlock + this.maxSlotsBetweenBackToBack >= t.getStartSlot() && t.getStartSlot() >= this.startSlotCurrentBlock) {
                this.placements.add(placement);
                int tEnd = t.getStartSlot() + t.getLength();
                if (tEnd > this.endSlotCurrentBlock) {
                    this.endSlotCurrentBlock = tEnd;
                }
                return true;
            }
            return false;
        }

        public boolean haveSameStartTime() {
            if (!this.placements.isEmpty()) {
                int startSlot = this.placements.get(0).getTimeLocation().getStartSlot();
                for (Placement p : this.getPlacements()) {
                    if (p.getTimeLocation().getStartSlot() == startSlot) continue;
                    return false;
                }
            }
            return true;
        }

        public int getStartSlotCurrentBlock() {
            return this.startSlotCurrentBlock;
        }

        public int getEndSlotCurrentBlock() {
            return this.endSlotCurrentBlock;
        }

        public int getNbrPlacements() {
            return this.placements.size();
        }

        public List<Placement> getPlacements() {
            return this.placements;
        }

        public int getLengthInSlots() {
            return this.endSlotCurrentBlock - this.startSlotCurrentBlock;
        }

        public String toString() {
            return "[" + this.startSlotCurrentBlock + ", " + this.endSlotCurrentBlock + "]" + " PlacementsNbr: " + this.getNbrPlacements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlexibleConstraintType {
        MAXBLOCK_BACKTOBACK("_(MaxBlock):([0-9]+):([0-9]+)_", MaxBlockFlexibleConstraint.class, "Block"),
        BREAK("_(Break):([0-9]+):([0-9]+):([0-9]+)_", BreakFlexibleConstraint.class, "Break"),
        MAX_BREAKS("_(MaxBreaks):([0-9]+):([0-9]+)_", MaxBreaksFlexibleConstraint.class, "MaxBreaks");

        private String iPattern;
        private Class<? extends FlexibleConstraint> iImplementation;
        private String iName;

        private FlexibleConstraintType(String pattern, Class<? extends FlexibleConstraint> implementation, String name) {
            this.iPattern = pattern;
            this.iImplementation = implementation;
            this.iName = name;
        }

        public String getPattern() {
            return this.iPattern;
        }

        public String getName() {
            return this.iName;
        }

        public FlexibleConstraint create(Long id, String owner, String preference, String reference) throws IllegalArgumentException {
            try {
                return this.iImplementation.getConstructor(Long.class, String.class, String.class, String.class).newInstance(id, owner, preference, reference);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }
}

