/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett.constraint;

import java.util.Set;
import net.sf.cpsolver.coursett.constraint.RoomConstraint;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomSharingModel;
import net.sf.cpsolver.ifs.model.WeakeningConstraint;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscouragedRoomConstraint
extends RoomConstraint
implements WeakeningConstraint<Lecture, Placement> {
    int iUsage = 0;
    int iLimit = 0;
    boolean iEnabled = false;
    private int iUnassignmentsToWeaken = 1000;
    private long iUnassignment = 0L;

    public DiscouragedRoomConstraint(DataProperties config, Long id, String name, Long buildingId, int capacity, RoomSharingModel roomSharingModel, Double x, Double y, boolean ignoreTooFar, boolean constraint) {
        super(id, name, buildingId, capacity, roomSharingModel, x, y, ignoreTooFar, constraint);
        this.iUnassignmentsToWeaken = config.getPropertyInt("DiscouragedRoom.Unassignments2Weaken", this.iUnassignmentsToWeaken);
    }

    public int getLimit() {
        return this.iLimit;
    }

    public int getUsage() {
        return this.iUsage;
    }

    public boolean isOverLimit(Placement value) {
        if (!this.iEnabled) {
            return false;
        }
        if (this.iUnassignmentsToWeaken == 0) {
            return false;
        }
        Placement placement = value;
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return false;
        }
        Lecture lecture = (Lecture)placement.variable();
        if (lecture.roomLocations().size() == lecture.getNrRooms()) {
            return false;
        }
        if (lecture.isCommitted()) {
            return false;
        }
        if (lecture.getAssignment() != null && ((Placement)lecture.getAssignment()).hasRoomLocation(this.getResourceId())) {
            return false;
        }
        return this.iUsage + 1 > this.iLimit;
    }

    @Override
    public void computeConflicts(Placement value, Set<Placement> conflicts) {
        if (!this.getConstraint()) {
            return;
        }
        super.computeConflicts(value, conflicts);
        if (this.isOverLimit(value)) {
            conflicts.add(value);
        }
    }

    @Override
    public boolean inConflict(Placement value) {
        if (!this.getConstraint()) {
            return false;
        }
        if (this.isOverLimit(value)) {
            return true;
        }
        return super.inConflict(value);
    }

    @Override
    public boolean isConsistent(Placement value1, Placement value2) {
        if (!this.getConstraint()) {
            return true;
        }
        if (this.isOverLimit(value1) || this.isOverLimit(value2)) {
            return false;
        }
        return super.isConsistent(value1, value2);
    }

    @Override
    public void assigned(long iteration, Placement value) {
        super.assigned(iteration, value);
        Placement placement = value;
        if (!placement.hasRoomLocation(this.getResourceId())) {
            return;
        }
        Lecture lecture = (Lecture)placement.variable();
        if (lecture.isCommitted()) {
            return;
        }
        ++this.iUsage;
    }

    @Override
    public void unassigned(long iteration, Placement value) {
        super.unassigned(iteration, value);
        Placement placement = value;
        if (!placement.hasRoomLocation(this.getResourceId())) {
            ++this.iUnassignment;
            if (this.iUnassignmentsToWeaken > 0 && this.iUnassignment % (long)this.iUnassignmentsToWeaken == 0L) {
                ++this.iLimit;
            }
        } else {
            --this.iUsage;
        }
    }

    @Override
    public String getName() {
        return "discouraged " + super.getName();
    }

    @Override
    public String toString() {
        return "Discouraged " + super.toString();
    }

    public void setEnabled(boolean enabled) {
        this.iEnabled = enabled;
        this.iLimit = Math.max(this.iUsage, this.iLimit);
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    @Override
    public void weaken() {
        ++this.iLimit;
    }

    @Override
    public void weaken(Placement value) {
        while (this.isOverLimit(value)) {
            ++this.iLimit;
        }
    }
}

