/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.cpsolver.coursett.Constants;
import net.sf.cpsolver.coursett.IdConvertor;
import net.sf.cpsolver.coursett.TimetableSaver;
import net.sf.cpsolver.coursett.constraint.ClassLimitConstraint;
import net.sf.cpsolver.coursett.constraint.DiscouragedRoomConstraint;
import net.sf.cpsolver.coursett.constraint.FlexibleConstraint;
import net.sf.cpsolver.coursett.constraint.GroupConstraint;
import net.sf.cpsolver.coursett.constraint.IgnoreStudentConflictsConstraint;
import net.sf.cpsolver.coursett.constraint.InstructorConstraint;
import net.sf.cpsolver.coursett.constraint.MinimizeNumberOfUsedGroupsOfTime;
import net.sf.cpsolver.coursett.constraint.MinimizeNumberOfUsedRoomsConstraint;
import net.sf.cpsolver.coursett.constraint.RoomConstraint;
import net.sf.cpsolver.coursett.constraint.SpreadConstraint;
import net.sf.cpsolver.coursett.model.Configuration;
import net.sf.cpsolver.coursett.model.Lecture;
import net.sf.cpsolver.coursett.model.Placement;
import net.sf.cpsolver.coursett.model.RoomLocation;
import net.sf.cpsolver.coursett.model.RoomSharingModel;
import net.sf.cpsolver.coursett.model.Student;
import net.sf.cpsolver.coursett.model.TimeLocation;
import net.sf.cpsolver.ifs.model.Constraint;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ToolBox;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimetableXMLSaver
extends TimetableSaver {
    private static Logger sLogger = Logger.getLogger(TimetableXMLSaver.class);
    private static DecimalFormat[] sDF = new DecimalFormat[]{new DecimalFormat(""), new DecimalFormat("0"), new DecimalFormat("00"), new DecimalFormat("000"), new DecimalFormat("0000"), new DecimalFormat("00000"), new DecimalFormat("000000"), new DecimalFormat("0000000")};
    private static DecimalFormat sStudentWeightFormat = new DecimalFormat("0.0000", new DecimalFormatSymbols(Locale.US));
    public static boolean ANONYMISE = false;
    private boolean iConvertIds = false;
    private boolean iShowNames = false;
    private File iOutputFolder = new File(this.getModel().getProperties().getProperty("General.Output", "." + File.separator + "output"));
    private boolean iSaveBest = false;
    private boolean iSaveInitial = false;
    private boolean iSaveCurrent = false;
    private boolean iExportStudentSectioning = false;
    private IdConvertor iIdConvertor = null;

    public TimetableXMLSaver(Solver<Lecture, Placement> solver) {
        super(solver);
        this.iShowNames = this.getModel().getProperties().getPropertyBoolean("Xml.ShowNames", false);
        this.iExportStudentSectioning = this.getModel().getProperties().getPropertyBoolean("Xml.ExportStudentSectioning", false);
        if (ANONYMISE) {
            this.iConvertIds = this.getModel().getProperties().getPropertyBoolean("Xml.ConvertIds", true);
            this.iSaveBest = this.getModel().getProperties().getPropertyBoolean("Xml.SaveBest", false);
            this.iSaveInitial = this.getModel().getProperties().getPropertyBoolean("Xml.SaveInitial", false);
            this.iSaveCurrent = this.getModel().getProperties().getPropertyBoolean("Xml.SaveCurrent", true);
        } else {
            this.iConvertIds = this.getModel().getProperties().getPropertyBoolean("Xml.ConvertIds", false);
            this.iSaveBest = this.getModel().getProperties().getPropertyBoolean("Xml.SaveBest", true);
            this.iSaveInitial = this.getModel().getProperties().getPropertyBoolean("Xml.SaveInitial", true);
            this.iSaveCurrent = this.getModel().getProperties().getPropertyBoolean("Xml.SaveCurrent", true);
        }
    }

    private String getId(String type, String id) {
        if (!this.iConvertIds) {
            return id.toString();
        }
        if (this.iIdConvertor == null) {
            this.iIdConvertor = new IdConvertor(this.getModel().getProperties().getProperty("Xml.IdConv"));
        }
        return this.iIdConvertor.convert(type, id);
    }

    private String getId(String type, Number id) {
        return this.getId(type, id.toString());
    }

    private static String bitset2string(BitSet b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length(); ++i) {
            sb.append(b.get(i) ? "1" : "0");
        }
        return sb.toString();
    }

    @Override
    public void save() throws Exception {
        this.save(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public void save(File outFile) throws Exception {
        Element grEl;
        Element classEl;
        if (outFile == null) {
            outFile = new File(this.iOutputFolder, "solution.xml");
        }
        outFile.getParentFile().mkdirs();
        sLogger.debug((Object)("Writting XML data to:" + outFile));
        Document document = DocumentHelper.createDocument();
        document.addComment("University Course Timetabling");
        if (this.iSaveCurrent && !this.getModel().assignedVariables().isEmpty()) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map<String, String> solutionInfo = this.getSolution() == null ? this.getModel().getInfo() : this.getSolution().getInfo();
            for (Object key : new TreeSet<String>(solutionInfo.keySet())) {
                String value = solutionInfo.get(key);
                comments.append("    " + (String)key + ": " + value + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("timetable");
        root.addAttribute("version", "2.5");
        root.addAttribute("initiative", this.getModel().getProperties().getProperty("Data.Initiative"));
        root.addAttribute("term", this.getModel().getProperties().getProperty("Data.Term"));
        root.addAttribute("year", String.valueOf(this.getModel().getYear()));
        root.addAttribute("created", String.valueOf(new Date()));
        root.addAttribute("nrDays", String.valueOf(Constants.DAY_CODES.length));
        root.addAttribute("slotsPerDay", String.valueOf(288));
        if (!this.iConvertIds && this.getModel().getProperties().getProperty("General.SessionId") != null) {
            root.addAttribute("session", this.getModel().getProperties().getProperty("General.SessionId"));
        }
        if (this.iShowNames && !this.iConvertIds && this.getModel().getProperties().getProperty("General.SolverGroupId") != null) {
            root.addAttribute("solverGroup", this.getId("solverGroup", this.getModel().getProperties().getProperty("General.SolverGroupId")));
        }
        HashMap<String, Element> roomElements = new HashMap<String, Element>();
        Element roomsEl = root.addElement("rooms");
        for (RoomConstraint roomConstraint : this.getModel().getRoomConstraints()) {
            Map<Long, Integer> travelTimes;
            Element roomEl = roomsEl.addElement("room").addAttribute("id", this.getId("room", roomConstraint.getResourceId()));
            roomEl.addAttribute("constraint", "true");
            if (roomConstraint instanceof DiscouragedRoomConstraint) {
                roomEl.addAttribute("discouraged", "true");
            }
            if (this.iShowNames) {
                roomEl.addAttribute("name", roomConstraint.getRoomName());
            }
            if (!this.iConvertIds && roomConstraint.getBuildingId() != null) {
                roomEl.addAttribute("building", this.getId("bldg", roomConstraint.getBuildingId()));
            }
            roomElements.put(this.getId("room", roomConstraint.getResourceId()), roomEl);
            roomEl.addAttribute("capacity", String.valueOf(roomConstraint.getCapacity()));
            if (roomConstraint.getPosX() != null && roomConstraint.getPosY() != null) {
                roomEl.addAttribute("location", roomConstraint.getPosX() + "," + roomConstraint.getPosY());
            }
            if (roomConstraint.getIgnoreTooFar()) {
                roomEl.addAttribute("ignoreTooFar", "true");
            }
            if (!roomConstraint.getConstraint()) {
                roomEl.addAttribute("fake", "true");
            }
            if (roomConstraint.getSharingModel() != null) {
                RoomSharingModel sharingModel = roomConstraint.getSharingModel();
                Element sharingEl = roomEl.addElement("sharing");
                sharingEl.addElement("pattern").addAttribute("unit", String.valueOf(sharingModel.getStep())).setText(sharingModel.getPreferences());
                sharingEl.addElement("freeForAll").addAttribute("value", String.valueOf(sharingModel.getFreeForAllPrefChar()));
                sharingEl.addElement("notAvailable").addAttribute("value", String.valueOf(sharingModel.getNotAvailablePrefChar()));
                for (int i = 0; i < sharingModel.getNrDepartments(); ++i) {
                    sharingEl.addElement("department").addAttribute("value", String.valueOf((char)(48 + i))).addAttribute("id", this.getId("dept", sharingModel.getDepartmentIds()[i]));
                }
            }
            if (roomConstraint.getType() != null && this.iShowNames) {
                roomEl.addAttribute("type", roomConstraint.getType().toString());
            }
            if ((travelTimes = this.getModel().getDistanceMetric().getTravelTimes().get(roomConstraint.getResourceId())) == null) continue;
            for (Map.Entry time : travelTimes.entrySet()) {
                roomEl.addElement("travel-time").addAttribute("id", this.getId("room", (Number)time.getKey())).addAttribute("minutes", ((Integer)time.getValue()).toString());
            }
        }
        Element instructorsEl = root.addElement("instructors");
        Element departmentsEl = root.addElement("departments");
        HashMap<Long, String> depts = new HashMap<Long, String>();
        Element configsEl = this.iShowNames ? root.addElement("configurations") : null;
        HashSet<Configuration> configs = new HashSet<Configuration>();
        Element classesEl = root.addElement("classes");
        HashMap<Long, Element> classElements = new HashMap<Long, Element>();
        ArrayList vars = new ArrayList(this.getModel().variables());
        if (this.getModel().hasConstantVariables()) {
            vars.addAll(this.getModel().constantVariables());
        }
        for (Lecture lecture : vars) {
            Placement placement = (Placement)lecture.getAssignment();
            if (lecture.isCommitted() && placement == null) {
                placement = (Placement)lecture.getInitialAssignment();
            }
            Placement initialPlacement = (Placement)lecture.getInitialAssignment();
            Placement bestPlacement = (Placement)lecture.getBestAssignment();
            classEl = classesEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId()));
            classElements.put(lecture.getClassId(), classEl);
            if (this.iShowNames && lecture.getNote() != null) {
                classEl.addAttribute("note", lecture.getNote());
            }
            if (this.iShowNames && !lecture.isCommitted()) {
                classEl.addAttribute("ord", String.valueOf(lecture.getOrd()));
            }
            if (lecture.getWeight() != 1.0) {
                classEl.addAttribute("weight", String.valueOf(lecture.getWeight()));
            }
            if (this.iShowNames && lecture.getSolverGroupId() != null) {
                classEl.addAttribute("solverGroup", this.getId("solverGroup", lecture.getSolverGroupId()));
            }
            if (lecture.getParent() == null && lecture.getConfiguration() != null) {
                if (!this.iShowNames) {
                    classEl.addAttribute("offering", this.getId("offering", lecture.getConfiguration().getOfferingId().toString()));
                }
                classEl.addAttribute("config", this.getId("config", lecture.getConfiguration().getConfigId().toString()));
                if (this.iShowNames && configs.add(lecture.getConfiguration())) {
                    configsEl.addElement("config").addAttribute("id", this.getId("config", lecture.getConfiguration().getConfigId().toString())).addAttribute("limit", String.valueOf(lecture.getConfiguration().getLimit())).addAttribute("offering", this.getId("offering", lecture.getConfiguration().getOfferingId().toString()));
                }
            }
            classEl.addAttribute("committed", lecture.isCommitted() ? "true" : "false");
            if (lecture.getParent() != null) {
                classEl.addAttribute("parent", this.getId("class", lecture.getParent().getClassId()));
            }
            if (lecture.getSchedulingSubpartId() != null) {
                classEl.addAttribute("subpart", this.getId("subpart", lecture.getSchedulingSubpartId()));
            }
            if (this.iShowNames && lecture.isCommitted() && placement != null && placement.getAssignmentId() != null) {
                classEl.addAttribute("assignment", this.getId("assignment", placement.getAssignmentId()));
            }
            if (!lecture.isCommitted()) {
                if (lecture.minClassLimit() == lecture.maxClassLimit()) {
                    classEl.addAttribute("classLimit", String.valueOf(lecture.maxClassLimit()));
                } else {
                    classEl.addAttribute("minClassLimit", String.valueOf(lecture.minClassLimit()));
                    classEl.addAttribute("maxClassLimit", String.valueOf(lecture.maxClassLimit()));
                }
                if (lecture.roomToLimitRatio() != 1.0) {
                    classEl.addAttribute("roomToLimitRatio", sStudentWeightFormat.format(lecture.roomToLimitRatio()));
                }
            }
            if (lecture.getNrRooms() != 1) {
                classEl.addAttribute("nrRooms", String.valueOf(lecture.getNrRooms()));
            }
            if (this.iShowNames) {
                classEl.addAttribute("name", lecture.getName());
            }
            if (lecture.getDeptSpreadConstraint() != null) {
                classEl.addAttribute("department", this.getId("dept", lecture.getDeptSpreadConstraint().getDepartmentId()));
                depts.put(lecture.getDeptSpreadConstraint().getDepartmentId(), lecture.getDeptSpreadConstraint().getName());
            }
            if (lecture.getScheduler() != null) {
                classEl.addAttribute("scheduler", this.getId("dept", lecture.getScheduler()));
            }
            for (InstructorConstraint ic : lecture.getInstructorConstraints()) {
                Element instrEl = classEl.addElement("instructor").addAttribute("id", this.getId("inst", ic.getResourceId()));
                if ((lecture.isCommitted() || this.iSaveCurrent) && placement != null) {
                    instrEl.addAttribute("solution", "true");
                }
                if (this.iSaveInitial && initialPlacement != null) {
                    instrEl.addAttribute("initial", "true");
                }
                if (!this.iSaveBest || bestPlacement == null || bestPlacement.equals(placement)) continue;
                instrEl.addAttribute("best", "true");
            }
            for (RoomLocation rl : lecture.roomLocations()) {
                Element roomLocationEl = classEl.addElement("room");
                roomLocationEl.addAttribute("id", this.getId("room", rl.getId()));
                roomLocationEl.addAttribute("pref", String.valueOf(rl.getPreference()));
                if ((lecture.isCommitted() || this.iSaveCurrent) && placement != null && placement.hasRoomLocation(rl.getId())) {
                    roomLocationEl.addAttribute("solution", "true");
                }
                if (this.iSaveInitial && initialPlacement != null && initialPlacement.hasRoomLocation(rl.getId())) {
                    roomLocationEl.addAttribute("initial", "true");
                }
                if (this.iSaveBest && bestPlacement != null && !bestPlacement.equals(placement) && bestPlacement.hasRoomLocation(rl.getId())) {
                    roomLocationEl.addAttribute("best", "true");
                }
                if (roomElements.containsKey(this.getId("room", rl.getId()))) continue;
                Element roomEl = roomsEl.addElement("room").addAttribute("id", this.getId("room", rl.getId()));
                roomEl.addAttribute("constraint", "false");
                if (!this.iConvertIds && rl.getBuildingId() != null) {
                    roomEl.addAttribute("building", this.getId("bldg", rl.getBuildingId()));
                }
                if (this.iShowNames) {
                    roomEl.addAttribute("name", rl.getName());
                }
                roomElements.put(this.getId("room", rl.getId()), roomEl);
                roomEl.addAttribute("capacity", String.valueOf(rl.getRoomSize()));
                if (rl.getPosX() != null && rl.getPosY() != null) {
                    roomEl.addAttribute("location", rl.getPosX() + "," + rl.getPosY());
                }
                if (!rl.getIgnoreTooFar()) continue;
                roomEl.addAttribute("ignoreTooFar", "true");
            }
            boolean first = true;
            HashSet<Long> dp = new HashSet<Long>();
            for (TimeLocation tl : lecture.timeLocations()) {
                Element timeLocationEl = classEl.addElement("time");
                timeLocationEl.addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(tl.getDayCode()))));
                timeLocationEl.addAttribute("start", String.valueOf(tl.getStartSlot()));
                timeLocationEl.addAttribute("length", String.valueOf(tl.getLength()));
                timeLocationEl.addAttribute("breakTime", String.valueOf(tl.getBreakTime()));
                if (this.iShowNames) {
                    timeLocationEl.addAttribute("pref", String.valueOf(tl.getPreference()));
                    timeLocationEl.addAttribute("npref", String.valueOf(tl.getNormalizedPreference()));
                } else {
                    timeLocationEl.addAttribute("pref", String.valueOf(tl.getNormalizedPreference()));
                }
                if (!this.iConvertIds && tl.getTimePatternId() != null) {
                    timeLocationEl.addAttribute("pattern", this.getId("pat", tl.getTimePatternId()));
                }
                if (tl.getDatePatternId() != null && dp.add(tl.getDatePatternId())) {
                    Element dateEl = classEl.addElement("date");
                    dateEl.addAttribute("id", this.getId("dpat", String.valueOf(tl.getDatePatternId())));
                    if (this.iShowNames) {
                        dateEl.addAttribute("name", tl.getDatePatternName());
                    }
                    dateEl.addAttribute("pattern", TimetableXMLSaver.bitset2string(tl.getWeekCode()));
                }
                if (tl.getDatePatternPreference() != 0) {
                    timeLocationEl.addAttribute("datePref", String.valueOf(tl.getDatePatternPreference()));
                }
                if (tl.getTimePatternId() == null && first) {
                    if (this.iShowNames) {
                        classEl.addAttribute("datePatternName", tl.getDatePatternName());
                    }
                    classEl.addAttribute("dates", TimetableXMLSaver.bitset2string(tl.getWeekCode()));
                    first = false;
                }
                if (tl.getDatePatternId() != null) {
                    timeLocationEl.addAttribute("date", this.getId("dpat", String.valueOf(tl.getDatePatternId())));
                }
                if ((lecture.isCommitted() || this.iSaveCurrent) && placement != null && placement.getTimeLocation().equals(tl)) {
                    timeLocationEl.addAttribute("solution", "true");
                }
                if (this.iSaveInitial && initialPlacement != null && initialPlacement.getTimeLocation().equals(tl)) {
                    timeLocationEl.addAttribute("initial", "true");
                }
                if (!this.iSaveBest || bestPlacement == null || bestPlacement.equals(placement) || !bestPlacement.getTimeLocation().equals(tl)) continue;
                timeLocationEl.addAttribute("best", "true");
            }
        }
        for (Iterator<Constraint> ic : this.getModel().getInstructorConstraints()) {
            if (this.iShowNames || ((InstructorConstraint)((Object)ic)).isIgnoreDistances()) {
                Element instrEl = instructorsEl.addElement("instructor").addAttribute("id", this.getId("inst", ((InstructorConstraint)((Object)ic)).getResourceId()));
                if (this.iShowNames) {
                    if (((InstructorConstraint)((Object)ic)).getPuid() != null && ((InstructorConstraint)((Object)ic)).getPuid().length() > 0) {
                        instrEl.addAttribute("puid", ((InstructorConstraint)((Object)ic)).getPuid());
                    }
                    instrEl.addAttribute("name", ((InstructorConstraint)((Object)ic)).getName());
                    if (((InstructorConstraint)((Object)ic)).getType() != null && this.iShowNames) {
                        instrEl.addAttribute("type", ((InstructorConstraint)((Object)ic)).getType().toString());
                    }
                }
                if (((InstructorConstraint)((Object)ic)).isIgnoreDistances()) {
                    instrEl.addAttribute("ignDist", "true");
                }
            }
            if (((InstructorConstraint)((Object)ic)).getUnavailabilities() == null) continue;
            for (Placement placement : ((InstructorConstraint)((Object)ic)).getUnavailabilities()) {
                Iterator<Object> lecture = (Lecture)placement.variable();
                classEl = (Element)classElements.get(((Lecture)((Object)lecture)).getClassId());
                classEl.addElement("instructor").addAttribute("id", this.getId("inst", ((InstructorConstraint)((Object)ic)).getResourceId())).addAttribute("solution", "true");
            }
        }
        if (instructorsEl.elements().isEmpty()) {
            root.remove(instructorsEl);
        }
        Element grConstraintsEl = root.addElement("groupConstraints");
        for (Object gc : this.getModel().getGroupConstraints()) {
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(((GroupConstraint)gc).getId())));
            grEl.addAttribute("type", ((GroupConstraint)gc).getType().reference());
            grEl.addAttribute("pref", ((GroupConstraint)gc).getPrologPreference());
            for (Lecture l : ((Constraint)gc).variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
            }
        }
        for (SpreadConstraint spread : this.getModel().getSpreadConstraints()) {
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(spread.getId())));
            grEl.addAttribute("type", "SPREAD");
            grEl.addAttribute("pref", "R");
            if (this.iShowNames) {
                grEl.addAttribute("name", spread.getName());
            }
            for (Lecture l : spread.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
            }
        }
        for (Constraint c : this.getModel().constraints()) {
            if (c instanceof MinimizeNumberOfUsedRoomsConstraint) {
                grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(c.getId())));
                grEl.addAttribute("type", "MIN_ROOM_USE");
                grEl.addAttribute("pref", "R");
                for (Lecture l : c.variables()) {
                    grEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
                }
            }
            if (c instanceof MinimizeNumberOfUsedGroupsOfTime) {
                grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(c.getId())));
                grEl.addAttribute("type", ((MinimizeNumberOfUsedGroupsOfTime)c).getConstraintName());
                grEl.addAttribute("pref", "R");
                for (Lecture l : c.variables()) {
                    grEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
                }
            }
            if (!(c instanceof IgnoreStudentConflictsConstraint)) continue;
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(c.getId())));
            grEl.addAttribute("type", "NO_CONFLICT");
            grEl.addAttribute("pref", "R");
            for (Lecture l : c.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
            }
        }
        for (ClassLimitConstraint clc : this.getModel().getClassLimitConstraints()) {
            grEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(clc.getId())));
            grEl.addAttribute("type", "CLASS_LIMIT");
            grEl.addAttribute("pref", "R");
            if (clc.getParentLecture() != null) {
                grEl.addElement("parentClass").addAttribute("id", this.getId("class", clc.getParentLecture().getClassId()));
            } else {
                grEl.addAttribute("courseLimit", String.valueOf(clc.classLimit() - clc.getClassLimitDelta()));
            }
            if (clc.getClassLimitDelta() != 0) {
                grEl.addAttribute("delta", String.valueOf(clc.getClassLimitDelta()));
            }
            if (this.iShowNames) {
                grEl.addAttribute("name", clc.getName());
            }
            for (Lecture l : clc.variables()) {
                grEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
            }
        }
        for (Object gc : this.getModel().getFlexibleConstraints()) {
            Element flEl = grConstraintsEl.addElement("constraint").addAttribute("id", this.getId("gr", String.valueOf(((Constraint)gc).getId())));
            flEl.addAttribute("reference", ((FlexibleConstraint)gc).getReference());
            flEl.addAttribute("owner", ((FlexibleConstraint)gc).getOwner());
            flEl.addAttribute("pref", ((FlexibleConstraint)gc).getPrologPreference());
            flEl.addAttribute("type", ((FlexibleConstraint)gc).getType().toString());
            for (Lecture l : ((Constraint)gc).variables()) {
                flEl.addElement("class").addAttribute("id", this.getId("class", l.getClassId()));
            }
        }
        HashMap<Student, ArrayList<String>> students = new HashMap<Student, ArrayList<String>>();
        for (Object lecture : vars) {
            for (Student student : ((Lecture)lecture).students()) {
                ArrayList<String> enrls = (ArrayList<String>)students.get(student);
                if (enrls == null) {
                    enrls = new ArrayList<String>();
                    students.put(student, enrls);
                }
                enrls.add(this.getId("class", ((Lecture)lecture).getClassId()));
            }
        }
        Element studentsEl = root.addElement("students");
        for (Student student : new TreeSet(students.keySet())) {
            Map<Long, Set<Lecture>> canNotEnroll;
            Iterator<Object> entry2;
            Element stEl = studentsEl.addElement("student").addAttribute("id", this.getId("student", student.getId()));
            if (this.iShowNames) {
                if (student.getAcademicArea() != null) {
                    stEl.addAttribute("area", student.getAcademicArea());
                }
                if (student.getAcademicClassification() != null) {
                    stEl.addAttribute("classification", student.getAcademicClassification());
                }
                if (student.getMajor() != null) {
                    stEl.addAttribute("major", student.getMajor());
                }
                if (student.getCurriculum() != null) {
                    stEl.addAttribute("curriculum", student.getCurriculum());
                }
            }
            for (Iterator<Object> entry2 : student.getOfferingsMap().entrySet()) {
                Double priority;
                Long offeringId = entry2.getKey();
                Double weight = entry2.getValue();
                Element offEl = stEl.addElement("offering").addAttribute("id", this.getId("offering", offeringId.toString()));
                if (weight != 1.0) {
                    offEl.addAttribute("weight", sStudentWeightFormat.format(weight));
                }
                if ((priority = student.getPriority(offeringId)) == null) continue;
                offEl.addAttribute("priority", priority.toString());
            }
            if (this.iExportStudentSectioning || this.getModel().unassignedVariables().isEmpty() || student.getOfferingsMap().isEmpty()) {
                List lectures = (List)students.get(student);
                Collections.sort(lectures);
                entry2 = lectures.iterator();
                while (entry2.hasNext()) {
                    String classId = (String)entry2.next();
                    stEl.addElement("class").addAttribute("id", classId);
                }
            }
            if ((canNotEnroll = student.canNotEnrollSections()) != null) {
                entry2 = canNotEnroll.values().iterator();
                while (entry2.hasNext()) {
                    Set canNotEnrollLects = (Set)entry2.next();
                    Iterator i3 = canNotEnrollLects.iterator();
                    while (i3.hasNext()) {
                        stEl.addElement("prohibited-class").addAttribute("id", this.getId("class", ((Lecture)i3.next()).getClassId()));
                    }
                }
            }
            if (student.getCommitedPlacements() != null) {
                entry2 = student.getCommitedPlacements().iterator();
                while (entry2.hasNext()) {
                    Placement placement = (Placement)entry2.next();
                    stEl.addElement("class").addAttribute("id", this.getId("class", ((Lecture)placement.variable()).getClassId()));
                }
            }
            if (student.getInstructor() == null) continue;
            stEl.addAttribute("instructor", this.getId("inst", student.getInstructor().getResourceId()));
        }
        if (this.getModel().getProperties().getPropertyInt("MPP.GenTimePert", 0) > 0) {
            Element perturbationsEl = root.addElement("perturbations");
            int nrChanges = this.getModel().getProperties().getPropertyInt("MPP.GenTimePert", 0);
            ArrayList<Lecture> lectures = new ArrayList<Lecture>();
            while (lectures.size() < nrChanges) {
                Lecture lecture = (Lecture)ToolBox.random(this.getModel().assignedVariables());
                if (lecture.isCommitted() || lecture.timeLocations().size() <= 1 || lectures.contains(lecture)) continue;
                Placement placement = (Placement)lecture.getAssignment();
                TimeLocation tl = placement.getTimeLocation();
                perturbationsEl.addElement("class").addAttribute("id", this.getId("class", lecture.getClassId())).addAttribute("days", sDF[7].format(Long.parseLong(Integer.toBinaryString(tl.getDayCode())))).addAttribute("start", String.valueOf(tl.getStartSlot())).addAttribute("length", String.valueOf(tl.getLength()));
                lectures.add(lecture);
            }
        }
        for (Map.Entry entry : depts.entrySet()) {
            Long id = (Long)entry.getKey();
            String name = (String)entry.getValue();
            if (!this.iShowNames) continue;
            departmentsEl.addElement("department").addAttribute("id", this.getId("dept", id.toString())).addAttribute("name", name);
        }
        if (departmentsEl.elements().isEmpty()) {
            root.remove(departmentsEl);
        }
        if (this.iShowNames) {
            Progress.getInstance(this.getModel()).save(root);
            try {
                this.getSolver().getClass().getMethod("save", Element.class).invoke(this.getSolver(), root);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outFile);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
            fos.flush();
            fos.close();
            fos = null;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
        if (this.iConvertIds) {
            this.iIdConvertor.save();
        }
    }
}

