/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class IdConvertor {
    private static Logger sLogger = Logger.getLogger(IdConvertor.class);
    private static IdConvertor sInstance = null;
    private HashMap<String, HashMap<String, String>> iConversion = new HashMap();
    private String iFile = null;

    protected IdConvertor(String file) {
        this.iFile = file;
        this.load();
    }

    public static IdConvertor getInstance() {
        if (sInstance == null) {
            sInstance = new IdConvertor(null);
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String convert(String type, String id) {
        HashMap<String, HashMap<String, String>> hashMap = this.iConversion;
        synchronized (hashMap) {
            String newId;
            HashMap<String, String> conversion = this.iConversion.get(type);
            if (conversion == null) {
                conversion = new HashMap();
                this.iConversion.put(type, conversion);
            }
            if ((newId = conversion.get(id)) == null) {
                newId = String.valueOf(conversion.size() + 1);
                conversion.put(id, newId);
            }
            return newId;
        }
    }

    public void clear() {
        this.iConversion.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) {
        file.getParentFile().mkdirs();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("id-convertor");
        HashMap<String, HashMap<String, String>> hashMap = this.iConversion;
        synchronized (hashMap) {
            for (Map.Entry<String, HashMap<String, String>> entry : this.iConversion.entrySet()) {
                String type = entry.getKey();
                HashMap<String, String> conversion = entry.getValue();
                Element convEl = root.addElement(type);
                for (Map.Entry<String, String> idConv : conversion.entrySet()) {
                    convEl.addElement("conv").addAttribute("old", idConv.getKey()).addAttribute("new", idConv.getValue());
                }
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            new XMLWriter((OutputStream)fos, OutputFormat.createPrettyPrint()).write(document);
            fos.flush();
            fos.close();
            fos = null;
        }
        catch (Exception e) {
            sLogger.error((Object)("Unable to save id conversions, reason: " + e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public void save() {
        if (this.iFile == null) {
            this.iFile = System.getProperty("IdConvertor.File");
        }
        if (this.iFile != null) {
            this.save(new File(this.iFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            Document document = new SAXReader().read(file);
            Element root = document.getRootElement();
            HashMap<String, HashMap<String, String>> hashMap = this.iConversion;
            synchronized (hashMap) {
                this.iConversion.clear();
                Iterator i = root.elementIterator();
                while (i.hasNext()) {
                    Element convEl = (Element)i.next();
                    HashMap<String, String> conversion = new HashMap<String, String>();
                    this.iConversion.put(convEl.getName(), conversion);
                    Iterator j = convEl.elementIterator("conv");
                    while (j.hasNext()) {
                        Element e = (Element)j.next();
                        conversion.put(e.attributeValue("old"), e.attributeValue("new"));
                    }
                }
            }
        }
        catch (Exception e) {
            sLogger.error((Object)("Unable to load id conversions, reason: " + e.getMessage()), (Throwable)e);
        }
    }

    public void load() {
        if (this.iFile == null) {
            this.iFile = System.getProperty("IdConvertor.File");
        }
        if (this.iFile != null) {
            this.load(new File(this.iFile));
        }
    }
}

