/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.coursett;

public class Constants
extends net.sf.cpsolver.ifs.Constants {
    public static final int SLOTS_PER_DAY = 288;
    public static int[] DAY_CODES = new int[]{64, 32, 16, 8, 4, 2, 1};
    public static int DAY_CODE_ALL = 127;
    public static int DAY_CODE_WEEK = 124;
    public static int SLOT_LENGTH_MIN = 5;
    public static int FIRST_SLOT_TIME_MIN = 0;
    public static int DAY_SLOTS_FIRST = 90;
    public static int DAY_SLOTS_LAST = 209;
    public static int SLOTS_PER_DAY_NO_EVENINGS = DAY_SLOTS_LAST - DAY_SLOTS_FIRST + 1;
    public static String[] DAY_NAMES_SHORT = new String[]{"M", "T", "W", "Th", "F", "S", "Su"};
    public static int NR_DAYS = DAY_CODES.length;
    public static int NR_DAYS_WEEK = 5;
    public static final String sPreferenceProhibited = "P";
    public static final String sPreferenceRequired = "R";
    public static final String sPreferenceStronglyDiscouraged = "2";
    public static final String sPreferenceDiscouraged = "1";
    public static final String sPreferencePreferred = "-1";
    public static final String sPreferenceStronglyPreferred = "-2";
    public static final String sPreferenceNeutral = "0";
    public static final int sPreferenceLevelProhibited = 100;
    public static final int sPreferenceLevelRequired = -100;
    public static final int sPreferenceLevelStronglyDiscouraged = 4;
    public static final int sPreferenceLevelDiscouraged = 1;
    public static final int sPreferenceLevelPreferred = -1;
    public static final int sPreferenceLevelStronglyPreferred = -4;
    public static final int sPreferenceLevelNeutral = 0;

    public static int preference2preferenceLevel(String prologPref) {
        if (sPreferenceRequired.equals(prologPref)) {
            return -100;
        }
        if (sPreferenceStronglyPreferred.equals(prologPref)) {
            return -4;
        }
        if (sPreferencePreferred.equals(prologPref)) {
            return -1;
        }
        if (sPreferenceDiscouraged.equals(prologPref)) {
            return 1;
        }
        if (sPreferenceStronglyDiscouraged.equals(prologPref)) {
            return 4;
        }
        if (sPreferenceProhibited.equals(prologPref)) {
            return 100;
        }
        return 0;
    }

    public static String preferenceLevel2preference(int intPref) {
        if (intPref >= 50) {
            return sPreferenceProhibited;
        }
        if (intPref >= 4) {
            return sPreferenceStronglyDiscouraged;
        }
        if (intPref > 0) {
            return sPreferenceDiscouraged;
        }
        if (intPref <= -50) {
            return sPreferenceRequired;
        }
        if (intPref <= -4) {
            return sPreferenceStronglyPreferred;
        }
        if (intPref < 0) {
            return sPreferencePreferred;
        }
        return sPreferenceNeutral;
    }

    public static int time2slot(int hour, int min) {
        return (hour * 60 + min - FIRST_SLOT_TIME_MIN) / SLOT_LENGTH_MIN;
    }
}

