/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.util;

import java.io.PrintStream;
import net.sf.cpsolver.ifs.util.Progress;
import net.sf.cpsolver.ifs.util.ProgressListener;

public class ProgressWriter
implements ProgressListener {
    private PrintStream iTextOut = null;
    private static int TEXT_LENGTH = 28;
    private static int DOTS_LENGTH = 48;
    private int iPrintedDots = -1;

    public ProgressWriter(PrintStream out) {
        this.iTextOut = out;
    }

    public void statusChanged(String status) {
    }

    public void phaseChanged(String phase) {
        if (this.iPrintedDots > 0) {
            while (this.iPrintedDots < DOTS_LENGTH) {
                this.iTextOut.print(".");
                ++this.iPrintedDots;
            }
        }
        this.iTextOut.println();
        this.iTextOut.print(ProgressWriter.expand(phase, TEXT_LENGTH, ' ', false) + ": ");
        this.iPrintedDots = 0;
        this.iTextOut.flush();
    }

    public void progressChanged(long currentProgress, long maxProgress) {
        int dotsToPrint;
        int n = dotsToPrint = maxProgress == 0L ? 0 : (int)((long)DOTS_LENGTH * currentProgress / maxProgress);
        while (this.iPrintedDots < dotsToPrint) {
            this.iTextOut.print(".");
            ++this.iPrintedDots;
        }
        this.iTextOut.flush();
    }

    public void progressSaved() {
    }

    public void progressRestored() {
    }

    public void progressMessagePrinted(Progress.Message msg) {
    }

    private static String expand(String source, int length, char ch, boolean beg) {
        StringBuffer sb = new StringBuffer(source == null ? "" : (source.length() > length ? (beg ? source.substring(source.length() - length) : source.substring(0, length)) : source));
        while (sb.length() < length) {
            if (beg) {
                sb.insert(0, ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

