/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cpsolver.ifs.perturbations;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.cpsolver.ifs.extension.Extension;
import net.sf.cpsolver.ifs.extension.ViolatedInitials;
import net.sf.cpsolver.ifs.model.Model;
import net.sf.cpsolver.ifs.model.Value;
import net.sf.cpsolver.ifs.model.Variable;
import net.sf.cpsolver.ifs.perturbations.PerturbationsCounter;
import net.sf.cpsolver.ifs.solver.Solver;
import net.sf.cpsolver.ifs.util.DataProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPerturbationsCounter<V extends Variable<V, T>, T extends Value<V, T>>
implements PerturbationsCounter<V, T> {
    private ViolatedInitials<V, T> iViolatedInitials = null;
    protected static DecimalFormat sDoubleFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    public DefaultPerturbationsCounter(DataProperties properties) {
    }

    @Override
    public void init(Solver<V, T> solver) {
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!ViolatedInitials.class.isInstance(extension)) continue;
            this.iViolatedInitials = (ViolatedInitials)extension;
        }
    }

    @Override
    public double getPerturbationPenalty(Model<V, T> model) {
        double penalty = 0.0;
        for (Variable variable : model.perturbVariables()) {
            if (variable.getAssignment() == null || variable.getInitialAssignment() == null || ((Value)variable.getAssignment()).equals(variable.getInitialAssignment())) continue;
            penalty += this.getPenaltyD(variable.getAssignment(), variable.getInitialAssignment());
        }
        return penalty;
    }

    @Override
    public double getPerturbationPenalty(Model<V, T> model, Collection<V> variables) {
        double penalty = 0.0;
        for (Variable variable : variables) {
            if (variable.getAssignment() == null || variable.getInitialAssignment() == null || ((Value)variable.getAssignment()).equals(variable.getInitialAssignment())) continue;
            penalty += this.getPenaltyD(variable.getAssignment(), variable.getInitialAssignment());
        }
        return penalty;
    }

    protected ViolatedInitials<V, T> getViolatedInitials() {
        return this.iViolatedInitials;
    }

    protected double getPenalty(T assignedValue, T initialValue) {
        return 1.0;
    }

    protected double getPenaltyA(T selectedValue, T initialValue) {
        return this.getPenalty(null, initialValue);
    }

    protected double getPenaltyB(T selectedValue, T assignedValue, T initialValue) {
        return this.getPenalty(assignedValue, initialValue);
    }

    protected double getPenaltyC(T selectedValue, T assignedValue, T initialValue) {
        return -this.getPenalty(assignedValue, initialValue);
    }

    protected double getPenaltyD(T selectedValue, T initialValue) {
        return this.getPenalty(selectedValue, initialValue);
    }

    @Override
    public double getPerturbationPenalty(Model<V, T> model, T selectedValue, Collection<T> conflicts) {
        Set<T> violations;
        double penalty = 0.0;
        Set<T> set = violations = this.getViolatedInitials() == null ? null : this.getViolatedInitials().getViolatedInitials(selectedValue);
        if (violations != null) {
            for (Value aValue : violations) {
                if (((Variable)aValue.variable()).getAssignment() != null) continue;
                penalty += this.getPenaltyA(selectedValue, aValue);
            }
        }
        if (conflicts != null) {
            for (Value conflictValue : conflicts) {
                Object initialValue = ((Variable)conflictValue.variable()).getInitialAssignment();
                if (initialValue == null) continue;
                if (((Value)initialValue).equals(conflictValue)) {
                    penalty += this.getPenaltyB(selectedValue, conflictValue, initialValue);
                    continue;
                }
                if (violations != null && violations.contains(initialValue)) continue;
                penalty += this.getPenaltyC(selectedValue, conflictValue, initialValue);
            }
        }
        if (((Variable)((Value)selectedValue).variable()).getInitialAssignment() != null && !((Value)selectedValue).equals(((Variable)((Value)selectedValue).variable()).getInitialAssignment())) {
            penalty += this.getPenaltyD(selectedValue, ((Variable)((Value)selectedValue).variable()).getInitialAssignment());
        }
        return penalty;
    }

    @Override
    public void getInfo(Map<String, String> info, Model<V, T> model) {
        if (model.variablesWithInitialValue().size() > 0) {
            info.put("Perturbations: Total penalty", sDoubleFormat.format(this.getPerturbationPenalty(model)));
        }
    }

    @Override
    public void getInfo(Map<String, String> info, Model<V, T> model, Collection<V> variables) {
        if (model.variablesWithInitialValue().size() > 0) {
            info.put("Perturbations: Total penalty", sDoubleFormat.format(this.getPerturbationPenalty(model, variables)));
        }
    }
}

